/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LiteralWithSubstitutionHandler
extends MatchingHandler {
    private final String matchExpression;
    private Matcher matcher;
    private final List<SubstitutionHandler> handlers;

    public LiteralWithSubstitutionHandler(String _matchedExpression, List<SubstitutionHandler> _handlers) {
        this.matchExpression = _matchedExpression;
        this.handlers = _handlers;
    }

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
        String text = RegExpPredicate.getMeaningfulText(matchedNode);
        int offset = matchedNode.getText().indexOf(text);
        if (this.matcher == null) {
            this.matcher = Pattern.compile(this.matchExpression).matcher(text);
        } else {
            this.matcher.reset(text);
        }
        if (this.matcher.find()) {
            for (int i = 0; i < this.handlers.size(); ++i) {
                SubstitutionHandler handler = this.handlers.get(i);
                if (handler.handle(matchedNode, offset + this.matcher.start(i + 1), offset + this.matcher.end(i + 1), context)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

