/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UncheckedExceptionClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unchecked.exception.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/UncheckedExceptionClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unchecked.exception.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/UncheckedExceptionClassInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UncheckedExceptionClassVisitor();
    }

    private static class UncheckedExceptionClassVisitor
    extends BaseInspectionVisitor {
        private UncheckedExceptionClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/errorhandling/UncheckedExceptionClassInspection$UncheckedExceptionClassVisitor", "visitClass"));
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Throwable")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Exception") && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.RuntimeException")) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

