/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public class ClassNamingConventionInspectionBase
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 8;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ClassNamingConventionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String className = (String)infos[0];
        if (className.length() < this.getMinLength()) {
            String string = InspectionGadgetsBundle.message("class.name.convention.problem.descriptor.short", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ClassNamingConventionInspectionBase", "buildErrorString"));
            }
            return string;
        }
        if (className.length() > this.getMaxLength()) {
            String string = InspectionGadgetsBundle.message("class.name.convention.problem.descriptor.long", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ClassNamingConventionInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("class.name.convention.problem.descriptor.regex.mismatch", this.getRegex());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ClassNamingConventionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 8;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/naming/ClassNamingConventionInspectionBase$NamingConventionsVisitor", "visitClass"));
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (aClass.hasModifierProperty("abstract") && BaseInspection.isInspectionEnabled("AbstractClassNamingConvention", (PsiElement)aClass)) {
                return;
            }
            String name = aClass.getName();
            if (name == null || ClassNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            this.registerClassError(aClass, name);
        }
    }
}

