/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static Set<PsiType> getExceptionTypesHandled(PsiTryStatement statement) {
        PsiParameter[] parameters;
        HashSet<PsiType> out = new HashSet<PsiType>(10);
        for (PsiParameter parameter : parameters = statement.getCatchBlockParameters()) {
            PsiType type = parameter.getType();
            if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                List disjunctions = disjunctionType.getDisjunctions();
                out.addAll(disjunctions);
                continue;
            }
            out.add(type);
        }
        return out;
    }

    private static void calculateExceptionsThrownForStatement(PsiStatement statement, Set<PsiType> exceptionTypes) {
        if (statement == null) {
            return;
        }
        if (!(statement instanceof PsiBreakStatement) && !(statement instanceof PsiContinueStatement)) {
            if (statement instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
                PsiExpression returnValue = returnStatement.getReturnValue();
                if (returnValue != null) {
                    ExceptionUtils.calculateExceptionsThrownForExpression(returnValue, exceptionTypes);
                }
            } else if (statement instanceof PsiThrowStatement) {
                PsiThrowStatement throwStatement = (PsiThrowStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForThrowStatement(throwStatement, exceptionTypes);
            } else if (statement instanceof PsiExpressionListStatement) {
                PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForExpressionListStatement(expressionListStatement, exceptionTypes);
            } else if (statement instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
                PsiExpression expression = expressionStatement.getExpression();
                ExceptionUtils.calculateExceptionsThrownForExpression(expression, exceptionTypes);
            } else if (statement instanceof PsiAssertStatement) {
                PsiAssertStatement assertStatement = (PsiAssertStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForAssertStatement(assertStatement, exceptionTypes);
            } else if (statement instanceof PsiDeclarationStatement) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForDeclarationStatement(declarationStatement, exceptionTypes);
            } else if (statement instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForForStatement(forStatement, exceptionTypes);
            } else if (statement instanceof PsiForeachStatement) {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForForeachStatement(foreachStatement, exceptionTypes);
            } else if (statement instanceof PsiWhileStatement) {
                PsiWhileStatement whileStatement = (PsiWhileStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForWhileStatement(whileStatement, exceptionTypes);
            } else if (statement instanceof PsiDoWhileStatement) {
                PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForDoWhileStatement(doWhileStatement, exceptionTypes);
            } else if (statement instanceof PsiSynchronizedStatement) {
                PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForSynchronizedStatement(synchronizedStatement, exceptionTypes);
            } else if (statement instanceof PsiBlockStatement) {
                PsiBlockStatement block = (PsiBlockStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForBlockStatement(block, exceptionTypes);
            } else if (statement instanceof PsiLabeledStatement) {
                PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForLabeledStatement(labeledStatement, exceptionTypes);
            } else if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForIfStatement(ifStatement, exceptionTypes);
            } else if (statement instanceof PsiTryStatement) {
                PsiTryStatement tryStatement = (PsiTryStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForTryStatement(tryStatement, exceptionTypes);
            } else if (statement instanceof PsiSwitchStatement) {
                PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement;
                ExceptionUtils.calculateExceptionsThrownForSwitchStatement(switchStatement, exceptionTypes);
            }
        }
    }

    private static void calculateExceptionsThrownForLabeledStatement(PsiLabeledStatement labeledStatement, Set<PsiType> exceptionTypes) {
        PsiStatement statement = labeledStatement.getStatement();
        ExceptionUtils.calculateExceptionsThrownForStatement(statement, exceptionTypes);
    }

    private static void calculateExceptionsThrownForExpressionListStatement(PsiExpressionListStatement listStatement, Set<PsiType> exceptionTypes) {
        PsiExpression[] expressions;
        PsiExpressionList expressionList = listStatement.getExpressionList();
        for (PsiExpression expression : expressions = expressionList.getExpressions()) {
            ExceptionUtils.calculateExceptionsThrownForExpression(expression, exceptionTypes);
        }
    }

    private static void calculateExceptionsThrownForDeclarationStatement(PsiDeclarationStatement declarationStatement, Set<PsiType> exceptionTypes) {
        PsiElement[] elements;
        for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
            PsiVariable variable;
            PsiExpression initializer;
            if (!(element instanceof PsiVariable) || (initializer = (variable = (PsiVariable)element).getInitializer()) == null) continue;
            ExceptionUtils.calculateExceptionsThrownForExpression(initializer, exceptionTypes);
        }
    }

    private static void calculateExceptionsThrownForAssertStatement(PsiAssertStatement assertStatement, Set<PsiType> exceptionTypes) {
        PsiExpression assertCondition = assertStatement.getAssertCondition();
        ExceptionUtils.calculateExceptionsThrownForExpression(assertCondition, exceptionTypes);
        PsiExpression assertDescription = assertStatement.getAssertDescription();
        ExceptionUtils.calculateExceptionsThrownForExpression(assertDescription, exceptionTypes);
    }

    private static void calculateExceptionsThrownForThrowStatement(PsiThrowStatement throwStatement, Set<PsiType> exceptionTypes) {
        PsiExpression exception = throwStatement.getException();
        if (exception == null) {
            return;
        }
        PsiType type = exception.getType();
        if (type != null) {
            exceptionTypes.add(type);
        }
        ExceptionUtils.calculateExceptionsThrownForExpression(exception, exceptionTypes);
    }

    private static void calculateExceptionsThrownForSwitchStatement(PsiSwitchStatement switchStatement, Set<PsiType> exceptionTypes) {
        PsiExpression switchExpression = switchStatement.getExpression();
        ExceptionUtils.calculateExceptionsThrownForExpression(switchExpression, exceptionTypes);
        PsiCodeBlock body = switchStatement.getBody();
        ExceptionUtils.calculateExceptionsThrownForCodeBlock(body, exceptionTypes);
    }

    private static void calculateExceptionsThrownForTryStatement(PsiTryStatement tryStatement, Set<PsiType> exceptionTypes) {
        PsiCodeBlock[] catchBlocks;
        HashSet<PsiType> exceptionThrown = new HashSet<PsiType>(10);
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            ExceptionUtils.calculateExceptionsThrownForResourceList(resourceList, exceptionTypes);
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        ExceptionUtils.calculateExceptionsThrownForCodeBlock(tryBlock, exceptionThrown);
        Set<PsiType> exceptionHandled = ExceptionUtils.getExceptionTypesHandled(tryStatement);
        for (PsiType thrownType : exceptionThrown) {
            boolean found = false;
            for (PsiType handledType : exceptionHandled) {
                if (!handledType.isAssignableFrom(thrownType)) continue;
                found = true;
                break;
            }
            if (found) continue;
            exceptionTypes.add(thrownType);
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            ExceptionUtils.calculateExceptionsThrownForCodeBlock(finallyBlock, exceptionTypes);
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            ExceptionUtils.calculateExceptionsThrownForCodeBlock(catchBlock, exceptionTypes);
        }
    }

    public static void calculateExceptionsThrownForResourceList(PsiResourceList resourceList, Set<PsiType> exceptionTypes) {
        List resourceVariables = resourceList.getResourceVariables();
        block0: for (PsiResourceVariable variable : resourceVariables) {
            PsiMethod[] closeMethods;
            PsiClassType classType;
            PsiClass aClass;
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                ExceptionUtils.calculateExceptionsThrownForExpression(initializer, exceptionTypes);
            }
            PsiType type = variable.getType();
            PsiClassType autoCloseable = ExceptionUtils.getJavaLangAutoCloseable((PsiElement)resourceList);
            if (!(type instanceof PsiClassType) || !autoCloseable.isAssignableFrom(type) || (aClass = (classType = (PsiClassType)type).resolve()) == null) continue;
            for (PsiMethod method : closeMethods = aClass.findMethodsByName("close", true)) {
                PsiParameterList list = method.getParameterList();
                if (list.getParametersCount() != 0) continue;
                ExceptionUtils.calculateExceptionsDeclaredForMethod(method, exceptionTypes);
                continue block0;
            }
        }
    }

    private static PsiClassType getJavaLangAutoCloseable(PsiElement context) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        return factory.createTypeByFQClassName("java.lang.AutoCloseable", context.getResolveScope());
    }

    private static void calculateExceptionsThrownForIfStatement(PsiIfStatement ifStatement, Set<PsiType> exceptionTypes) {
        PsiExpression condition = ifStatement.getCondition();
        ExceptionUtils.calculateExceptionsThrownForExpression(condition, exceptionTypes);
        PsiStatement thenBranch = ifStatement.getThenBranch();
        ExceptionUtils.calculateExceptionsThrownForStatement(thenBranch, exceptionTypes);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        ExceptionUtils.calculateExceptionsThrownForStatement(elseBranch, exceptionTypes);
    }

    private static void calculateExceptionsThrownForBlockStatement(PsiBlockStatement block, Set<PsiType> exceptionTypes) {
        PsiCodeBlock codeBlock = block.getCodeBlock();
        ExceptionUtils.calculateExceptionsThrownForCodeBlock(codeBlock, exceptionTypes);
    }

    private static void calculateExceptionsThrownForSynchronizedStatement(PsiSynchronizedStatement synchronizedStatement, Set<PsiType> exceptionTypes) {
        PsiExpression lockExpression = synchronizedStatement.getLockExpression();
        if (lockExpression != null) {
            ExceptionUtils.calculateExceptionsThrownForExpression(lockExpression, exceptionTypes);
        }
        PsiCodeBlock body = synchronizedStatement.getBody();
        ExceptionUtils.calculateExceptionsThrownForCodeBlock(body, exceptionTypes);
    }

    private static void calculateExceptionsThrownForDoWhileStatement(PsiDoWhileStatement doWhileStatement, Set<PsiType> exceptionTypes) {
        PsiExpression condition = doWhileStatement.getCondition();
        ExceptionUtils.calculateExceptionsThrownForExpression(condition, exceptionTypes);
        PsiStatement body = doWhileStatement.getBody();
        ExceptionUtils.calculateExceptionsThrownForStatement(body, exceptionTypes);
    }

    private static void calculateExceptionsThrownForWhileStatement(PsiWhileStatement whileStatement, Set<PsiType> exceptionTypes) {
        PsiExpression condition = whileStatement.getCondition();
        ExceptionUtils.calculateExceptionsThrownForExpression(condition, exceptionTypes);
        PsiStatement body = whileStatement.getBody();
        ExceptionUtils.calculateExceptionsThrownForStatement(body, exceptionTypes);
    }

    private static void calculateExceptionsThrownForForStatement(PsiForStatement forStatement, Set<PsiType> exceptionTypes) {
        PsiStatement initialization = forStatement.getInitialization();
        ExceptionUtils.calculateExceptionsThrownForStatement(initialization, exceptionTypes);
        PsiExpression condition = forStatement.getCondition();
        ExceptionUtils.calculateExceptionsThrownForExpression(condition, exceptionTypes);
        PsiStatement update = forStatement.getUpdate();
        ExceptionUtils.calculateExceptionsThrownForStatement(update, exceptionTypes);
        PsiStatement body = forStatement.getBody();
        ExceptionUtils.calculateExceptionsThrownForStatement(body, exceptionTypes);
    }

    private static void calculateExceptionsThrownForForeachStatement(PsiForeachStatement foreachStatement, Set<PsiType> exceptionTypes) {
        PsiExpression iteratedValue = foreachStatement.getIteratedValue();
        ExceptionUtils.calculateExceptionsThrownForExpression(iteratedValue, exceptionTypes);
        PsiStatement body = foreachStatement.getBody();
        ExceptionUtils.calculateExceptionsThrownForStatement(body, exceptionTypes);
    }

    private static void calculateExceptionsThrownForExpression(PsiExpression expression, Set<PsiType> exceptionTypes) {
        if (expression == null) {
            return;
        }
        if (!(expression instanceof PsiThisExpression || expression instanceof PsiLiteralExpression || expression instanceof PsiSuperExpression || expression instanceof PsiClassObjectAccessExpression)) {
            if (expression instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForTypeCast(typeCastExpression, exceptionTypes);
            } else if (expression instanceof PsiInstanceOfExpression) {
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForInstanceOf(instanceOfExpression, exceptionTypes);
            } else if (expression instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
                PsiExpression qualifier = referenceExpression.getQualifierExpression();
                if (qualifier != null) {
                    ExceptionUtils.calculateExceptionsThrownForExpression(qualifier, exceptionTypes);
                }
            } else if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForMethodCall(methodCallExpression, exceptionTypes);
            } else if (expression instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForNewExpression(newExpression, exceptionTypes);
            } else if (expression instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForArrayInitializerExpression(arrayInitializerExpression, exceptionTypes);
            } else if (expression instanceof PsiArrayAccessExpression) {
                PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForArrayAccessExpression(arrayAccessExpression, exceptionTypes);
            } else if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForPrefixException(prefixExpression, exceptionTypes);
            } else if (expression instanceof PsiPostfixExpression) {
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForPostfixExpression(postfixExpression, exceptionTypes);
            } else if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForPolyadicExpression(polyadicExpression, exceptionTypes);
            } else if (expression instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForAssignmentExpression(assignmentExpression, exceptionTypes);
            } else if (expression instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
                ExceptionUtils.calculateExceptionsThrownForConditionalExpression(conditionalExpression, exceptionTypes);
            } else if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression innerExpression = parenthesizedExpression.getExpression();
                ExceptionUtils.calculateExceptionsThrownForExpression(innerExpression, exceptionTypes);
            }
        }
    }

    private static void calculateExceptionsThrownForTypeCast(PsiTypeCastExpression typeCastExpression, Set<PsiType> exceptionTypes) {
        PsiExpression operand = typeCastExpression.getOperand();
        ExceptionUtils.calculateExceptionsThrownForExpression(operand, exceptionTypes);
    }

    private static void calculateExceptionsThrownForInstanceOf(PsiInstanceOfExpression instanceOfExpression, Set<PsiType> exceptionTypes) {
        PsiExpression operand = instanceOfExpression.getOperand();
        ExceptionUtils.calculateExceptionsThrownForExpression(operand, exceptionTypes);
    }

    private static void calculateExceptionsThrownForNewExpression(PsiNewExpression newExpression, Set<PsiType> exceptionTypes) {
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList != null) {
            PsiExpression[] arguments;
            for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                ExceptionUtils.calculateExceptionsThrownForExpression(argument, exceptionTypes);
            }
        }
        PsiExpression[] arrayDimensions = newExpression.getArrayDimensions();
        for (PsiExpression arrayDimension : arrayDimensions) {
            ExceptionUtils.calculateExceptionsThrownForExpression(arrayDimension, exceptionTypes);
        }
        PsiExpression qualifier = newExpression.getQualifier();
        ExceptionUtils.calculateExceptionsThrownForExpression(qualifier, exceptionTypes);
        PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
        ExceptionUtils.calculateExceptionsThrownForExpression((PsiExpression)arrayInitializer, exceptionTypes);
        PsiMethod method = newExpression.resolveMethod();
        ExceptionUtils.calculateExceptionsDeclaredForMethod(method, exceptionTypes);
    }

    private static void calculateExceptionsThrownForMethodCall(PsiMethodCallExpression methodCallExpression, Set<PsiType> exceptionTypes) {
        PsiExpression[] expressions;
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        for (PsiExpression expression : expressions = argumentList.getExpressions()) {
            ExceptionUtils.calculateExceptionsThrownForExpression(expression, exceptionTypes);
        }
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        ExceptionUtils.calculateExceptionsThrownForExpression((PsiExpression)methodExpression, exceptionTypes);
        PsiMethod method = methodCallExpression.resolveMethod();
        ExceptionUtils.calculateExceptionsDeclaredForMethod(method, exceptionTypes);
    }

    public static void calculateExceptionsDeclaredForMethod(PsiMethod method, Set<PsiType> exceptionTypes) {
        if (method == null) {
            return;
        }
        PsiReferenceList throwsList = method.getThrowsList();
        PsiClassType[] types = throwsList.getReferencedTypes();
        Collections.addAll(exceptionTypes, types);
    }

    private static void calculateExceptionsThrownForConditionalExpression(PsiConditionalExpression conditionalExpression, Set<PsiType> exceptionTypes) {
        PsiExpression condition = conditionalExpression.getCondition();
        PsiExpression elseExpression = conditionalExpression.getElseExpression();
        PsiExpression thenExpression = conditionalExpression.getThenExpression();
        ExceptionUtils.calculateExceptionsThrownForExpression(condition, exceptionTypes);
        ExceptionUtils.calculateExceptionsThrownForExpression(elseExpression, exceptionTypes);
        ExceptionUtils.calculateExceptionsThrownForExpression(thenExpression, exceptionTypes);
    }

    private static void calculateExceptionsThrownForPolyadicExpression(PsiPolyadicExpression polyadicExpression, Set<PsiType> exceptionTypes) {
        PsiExpression[] operands;
        for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
            ExceptionUtils.calculateExceptionsThrownForExpression(operand, exceptionTypes);
        }
    }

    private static void calculateExceptionsThrownForAssignmentExpression(PsiAssignmentExpression assignmentExpression, Set<PsiType> exceptionTypes) {
        PsiExpression lOperand = assignmentExpression.getLExpression();
        ExceptionUtils.calculateExceptionsThrownForExpression(lOperand, exceptionTypes);
        PsiExpression rhs = assignmentExpression.getRExpression();
        ExceptionUtils.calculateExceptionsThrownForExpression(rhs, exceptionTypes);
    }

    private static void calculateExceptionsThrownForArrayInitializerExpression(PsiArrayInitializerExpression arrayInitializerExpression, Set<PsiType> exceptionTypes) {
        PsiExpression[] initializers;
        for (PsiExpression initializer : initializers = arrayInitializerExpression.getInitializers()) {
            ExceptionUtils.calculateExceptionsThrownForExpression(initializer, exceptionTypes);
        }
    }

    private static void calculateExceptionsThrownForArrayAccessExpression(PsiArrayAccessExpression arrayAccessExpression, Set<PsiType> exceptionTypes) {
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        ExceptionUtils.calculateExceptionsThrownForExpression(arrayExpression, exceptionTypes);
        PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
        ExceptionUtils.calculateExceptionsThrownForExpression(indexExpression, exceptionTypes);
    }

    private static void calculateExceptionsThrownForPrefixException(PsiPrefixExpression prefixExpression, Set<PsiType> exceptionTypes) {
        PsiExpression operand = prefixExpression.getOperand();
        ExceptionUtils.calculateExceptionsThrownForExpression(operand, exceptionTypes);
    }

    private static void calculateExceptionsThrownForPostfixExpression(PsiPostfixExpression postfixExpression, Set<PsiType> exceptionTypes) {
        PsiExpression operand = postfixExpression.getOperand();
        ExceptionUtils.calculateExceptionsThrownForExpression(operand, exceptionTypes);
    }

    public static void calculateExceptionsThrownForCodeBlock(PsiCodeBlock codeBlock, Set<PsiType> exceptionTypes) {
        PsiStatement[] statements;
        if (codeBlock == null) {
            return;
        }
        for (PsiStatement statement : statements = codeBlock.getStatements()) {
            ExceptionUtils.calculateExceptionsThrownForStatement(statement, exceptionTypes);
        }
    }
}

