/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.find.SearchInBackgroundOption;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageLimitUtil;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.SearchForUsagesRunnable;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageViewManagerImpl
extends UsageViewManager {
    private final Project myProject;
    private static final Key<UsageView> USAGE_VIEW_KEY = Key.create((String)"USAGE_VIEW");

    public UsageViewManagerImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/usages/impl/UsageViewManagerImpl", "<init>"));
        }
        this.myProject = project;
    }

    @Override
    @NotNull
    public UsageView createUsageView(@NotNull UsageTarget[] targets, @NotNull Usage[] usages, @NotNull UsageViewPresentation presentation, Factory<UsageSearcher> usageSearcherFactory) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/usages/impl/UsageViewManagerImpl", "createUsageView"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/usages/impl/UsageViewManagerImpl", "createUsageView"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/impl/UsageViewManagerImpl", "createUsageView"));
        }
        UsageViewImpl usageView = new UsageViewImpl(this.myProject, presentation, targets, usageSearcherFactory);
        UsageViewManagerImpl.appendUsages(usages, usageView);
        usageView.setSearchInProgress(false);
        UsageViewImpl usageViewImpl = usageView;
        if (usageViewImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "createUsageView"));
        }
        return usageViewImpl;
    }

    @Override
    @NotNull
    public UsageView showUsages(@NotNull UsageTarget[] searchedFor, @NotNull Usage[] foundUsages, @NotNull UsageViewPresentation presentation, Factory<UsageSearcher> factory) {
        if (searchedFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchedFor", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        if (foundUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foundUsages", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        UsageView usageView = this.createUsageView(searchedFor, foundUsages, presentation, factory);
        this.addContent((UsageViewImpl)usageView, presentation);
        this.showToolWindow(true);
        UsageView usageView2 = usageView;
        if (usageView2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        return usageView2;
    }

    @Override
    @NotNull
    public UsageView showUsages(@NotNull UsageTarget[] searchedFor, @NotNull Usage[] foundUsages, @NotNull UsageViewPresentation presentation) {
        if (searchedFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchedFor", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        if (foundUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foundUsages", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        UsageView usageView = this.showUsages(searchedFor, foundUsages, presentation, null);
        if (usageView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "showUsages"));
        }
        return usageView;
    }

    void addContent(@NotNull UsageViewImpl usageView, @NotNull UsageViewPresentation presentation) {
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/usages/impl/UsageViewManagerImpl", "addContent"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/impl/UsageViewManagerImpl", "addContent"));
        }
        Content content = com.intellij.usageView.UsageViewManager.getInstance(this.myProject).addContent(presentation.getTabText(), presentation.getTabName(), presentation.getToolwindowTitle(), true, usageView.getComponent(), presentation.isOpenInNewTab(), true);
        usageView.setContent(content);
        content.putUserData(USAGE_VIEW_KEY, usageView);
    }

    @Override
    public UsageView searchAndShowUsages(@NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, boolean showPanelIfOnlyOneUsage, boolean showNotFoundMessage, @NotNull UsageViewPresentation presentation, @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (searchFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFor", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        if (searcherFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcherFactory", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setShowNotFoundMessage(showNotFoundMessage);
        processPresentation.setShowPanelIfOnlyOneUsage(showPanelIfOnlyOneUsage);
        return this.doSearchAndShow(searchFor, searcherFactory, presentation, processPresentation, listener);
    }

    private UsageView doSearchAndShow(final @NotNull UsageTarget[] searchFor, final @NotNull Factory<UsageSearcher> searcherFactory, final @NotNull UsageViewPresentation presentation, final @NotNull FindUsagesProcessPresentation processPresentation, final @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (searchFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFor", "com/intellij/usages/impl/UsageViewManagerImpl", "doSearchAndShow"));
        }
        if (searcherFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcherFactory", "com/intellij/usages/impl/UsageViewManagerImpl", "doSearchAndShow"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/impl/UsageViewManagerImpl", "doSearchAndShow"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/usages/impl/UsageViewManagerImpl", "doSearchAndShow"));
        }
        final SearchScope searchScopeToWarnOfFallingOutOf = this.getMaxSearchScopeToWarnOfFallingOutOf(searchFor);
        final AtomicReference usageViewRef = new AtomicReference();
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, UsageViewManagerImpl.getProgressTitle(presentation), true, new SearchInBackgroundOption()){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/usages/impl/UsageViewManagerImpl$1", "run"));
                }
                new SearchForUsagesRunnable(UsageViewManagerImpl.this, UsageViewManagerImpl.this.myProject, usageViewRef, presentation, searchFor, (Factory<UsageSearcher>)searcherFactory, processPresentation, searchScopeToWarnOfFallingOutOf, listener).run();
            }

            @Override
            @NotNull
            public DumbModeAction getDumbModeAction() {
                DumbModeAction dumbModeAction = DumbModeAction.CANCEL;
                if (dumbModeAction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl$1", "getDumbModeAction"));
                }
                return dumbModeAction;
            }

            @Override
            @Nullable
            public Task.NotificationInfo getNotificationInfo() {
                String notification = usageViewRef.get() != null ? ((UsageViewImpl)usageViewRef.get()).getUsagesCount() + " Usage(s) Found" : "No Usages Found";
                return new Task.NotificationInfo("Find Usages", "Find Usages Finished", notification);
            }
        };
        ProgressManager.getInstance().run(task);
        return (UsageView)usageViewRef.get();
    }

    @NotNull
    SearchScope getMaxSearchScopeToWarnOfFallingOutOf(@NotNull UsageTarget[] searchFor) {
        if (searchFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFor", "com/intellij/usages/impl/UsageViewManagerImpl", "getMaxSearchScopeToWarnOfFallingOutOf"));
        }
        UsageTarget target = searchFor[0];
        if (target instanceof TypeSafeDataProvider) {
            final SearchScope[] scope = new SearchScope[1];
            ((TypeSafeDataProvider)((Object)target)).calcData(UsageView.USAGE_SCOPE, new DataSink(){

                @Override
                public <T> void put(DataKey<T> key, T data) {
                    scope[0] = (SearchScope)data;
                }
            });
            SearchScope searchScope = scope[0];
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "getMaxSearchScopeToWarnOfFallingOutOf"));
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.myProject);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "getMaxSearchScopeToWarnOfFallingOutOf"));
        }
        return globalSearchScope;
    }

    @Override
    public void searchAndShowUsages(@NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull UsageViewPresentation presentation, @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (searchFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFor", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        if (searcherFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcherFactory", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/impl/UsageViewManagerImpl", "searchAndShowUsages"));
        }
        this.doSearchAndShow(searchFor, searcherFactory, presentation, processPresentation, listener);
    }

    @Override
    public UsageView getSelectedUsageView() {
        Content content = com.intellij.usageView.UsageViewManager.getInstance(this.myProject).getSelectedContent();
        if (content != null) {
            return (UsageView)content.getUserData(USAGE_VIEW_KEY);
        }
        return null;
    }

    @NotNull
    public static String getProgressTitle(@NotNull UsageViewPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/impl/UsageViewManagerImpl", "getProgressTitle"));
        }
        String scopeText = presentation.getScopeText();
        String usagesString = StringUtil.capitalize((String)presentation.getUsagesString());
        String string = UsageViewBundle.message("progress.searching.for.in", usagesString, scopeText, presentation.getContextText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "getProgressTitle"));
        }
        return string;
    }

    void showToolWindow(boolean activateWindow) {
        ToolWindow toolWindow = ToolWindowManager.getInstance(this.myProject).getToolWindow(ToolWindowId.FIND);
        toolWindow.show(null);
        if (activateWindow && !toolWindow.isActive()) {
            toolWindow.activate(null);
        }
    }

    private static void appendUsages(final @NotNull Usage[] foundUsages, final @NotNull UsageViewImpl usageView) {
        if (foundUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foundUsages", "com/intellij/usages/impl/UsageViewManagerImpl", "appendUsages"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/usages/impl/UsageViewManagerImpl", "appendUsages"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (Usage foundUsage : foundUsages) {
                    usageView.appendUsage(foundUsage);
                }
            }
        });
    }

    public static void showTooManyUsagesWarning(final @NotNull Project project, final @NotNull TooManyUsagesStatus tooManyUsagesStatus, final @NotNull ProgressIndicator indicator, final @NotNull UsageViewPresentation presentation, final int usageCount, final @Nullable UsageViewImpl usageView) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/usages/impl/UsageViewManagerImpl", "showTooManyUsagesWarning"));
        }
        if (tooManyUsagesStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooManyUsagesStatus", "com/intellij/usages/impl/UsageViewManagerImpl", "showTooManyUsagesWarning"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/usages/impl/UsageViewManagerImpl", "showTooManyUsagesWarning"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/impl/UsageViewManagerImpl", "showTooManyUsagesWarning"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (usageView != null && usageView.searchHasBeenCancelled() || indicator.isCanceled()) {
                    return;
                }
                String message = UsageViewBundle.message("find.excessive.usage.count.prompt", usageCount, StringUtil.pluralize((String)presentation.getUsagesWord()));
                UsageLimitUtil.Result ret = UsageLimitUtil.showTooManyUsagesWarning(project, message, presentation);
                if (ret == UsageLimitUtil.Result.ABORT) {
                    if (usageView != null) {
                        usageView.cancelCurrentSearch();
                    }
                    indicator.cancel();
                }
                tooManyUsagesStatus.userResponded();
            }
        });
    }

    public static long getFileLength(final @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/usages/impl/UsageViewManagerImpl", "getFileLength"));
        }
        final long[] length = new long[]{-1L};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (!virtualFile.isValid()) {
                    return;
                }
                if (virtualFile.getFileType().isBinary()) {
                    return;
                }
                length[0] = virtualFile.getLength();
            }
        });
        return length[0];
    }

    @NotNull
    public static String presentableSize(long bytes) {
        long megabytes = bytes / 0x100000L;
        String string = UsageViewBundle.message("find.file.size.megabytes", Long.toString(megabytes));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "presentableSize"));
        }
        return string;
    }

    public static boolean isInScope(@NotNull Usage usage, @NotNull SearchScope searchScope) {
        VirtualFile file;
        VirtualFile virtualFile;
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/UsageViewManagerImpl", "isInScope"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/usages/impl/UsageViewManagerImpl", "isInScope"));
        }
        PsiElement element = null;
        if (usage instanceof UsageInFile) {
            virtualFile = ((UsageInFile)usage).getFile();
        } else if (usage instanceof PsiElementUsage) {
            element = ((PsiElementUsage)usage).getElement();
            virtualFile = PsiUtilCore.getVirtualFile(element);
        } else {
            virtualFile = file = null;
        }
        if (file != null) {
            return UsageViewManagerImpl.isFileInScope(file, searchScope);
        }
        if (element != null) {
            return searchScope instanceof EverythingGlobalScope || searchScope instanceof ProjectScopeImpl || searchScope instanceof ProjectAndLibrariesScope;
        }
        return false;
    }

    private static boolean isFileInScope(@NotNull VirtualFile file, @NotNull SearchScope searchScope) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/usages/impl/UsageViewManagerImpl", "isFileInScope"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/usages/impl/UsageViewManagerImpl", "isFileInScope"));
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        if (searchScope instanceof LocalSearchScope) {
            return ((LocalSearchScope)searchScope).isInScope(file);
        }
        return ((GlobalSearchScope)searchScope).contains(file);
    }

    @NotNull
    public static String outOfScopeMessage(int nUsages, @NotNull SearchScope searchScope) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/usages/impl/UsageViewManagerImpl", "outOfScopeMessage"));
        }
        String string = (nUsages == 1 ? "One usage is" : nUsages + " usages are") + " out of scope '" + searchScope.getDisplayName() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageViewManagerImpl", "outOfScopeMessage"));
        }
        return string;
    }
}

