/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DuplicateResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("DuplicateDefinition", "Duplicate definitions of resources", "You can define a resource multiple times in different resource folders; that's how string translations are done, for example. However, defining the same resource more than once in the same resource folder is likely an error, for example attempting to add a new resource without realizing that the name is already used, and so on.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(DuplicateResourceDetector.class, Scope.ALL_RESOURCES_SCOPE, Scope.RESOURCE_FILE_SCOPE));
    public static final Issue TYPE_MISMATCH = Issue.create("ReferenceType", "Incorrect reference types", "When you generate a resource alias, the resource you are pointing to must be of the same type as the alias", Category.CORRECTNESS, 8, Severity.FATAL, new Implementation(DuplicateResourceDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private static final String PRODUCT = "product";
    private Map<ResourceType, Set<String>> mTypeMap;
    private Map<ResourceType, List<Pair<String, Location.Handle>>> mLocations;
    private File mParent;

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    @Override
    @Nullable
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("name");
    }

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    @Override
    public void beforeCheckFile(@NonNull Context context) {
        File parent = context.file.getParentFile();
        if (!parent.equals(this.mParent)) {
            this.mParent = parent;
            this.mTypeMap = Maps.newEnumMap(ResourceType.class);
            this.mLocations = Maps.newEnumMap(ResourceType.class);
        }
    }

    @Override
    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        String name;
        HashSet names;
        String tag;
        Element element = attribute.getOwnerElement();
        if (element.hasAttribute(PRODUCT)) {
            return;
        }
        String typeString = tag = element.getTagName();
        if (tag.equals("item") && ((typeString = element.getAttribute("type")) == null || typeString.isEmpty())) {
            if (element.getParentNode().getNodeName().equals(ResourceType.STYLE.getName()) && DuplicateResourceDetector.isFirstElementChild(element)) {
                DuplicateResourceDetector.checkUniqueNames(context, (Element)element.getParentNode());
            }
            return;
        }
        ResourceType type = ResourceType.getEnum((String)typeString);
        if (type == null) {
            return;
        }
        if (type == ResourceType.ATTR && element.getParentNode().getNodeName().equals(ResourceType.DECLARE_STYLEABLE.getName())) {
            if (DuplicateResourceDetector.isFirstElementChild(element)) {
                DuplicateResourceDetector.checkUniqueNames(context, (Element)element.getParentNode());
            }
            return;
        }
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        block0: for (int i = 0; i < childCount; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            int length = text.length();
            for (int j = 0; j < length; ++j) {
                char c = text.charAt(j);
                if (c == '@') {
                    ResourceUrl url;
                    if (text.regionMatches(false, j + 1, typeString, 0, typeString.length()) || !context.isEnabled(TYPE_MISMATCH) || (url = ResourceUrl.parse((String)text.trim())) == null || url.type == type || type == ResourceType.DRAWABLE && (url.type == ResourceType.COLOR || url.type == ResourceType.MIPMAP)) break block0;
                    String message = "Unexpected resource reference type; expected value of type `@" + type + "/`";
                    context.report(TYPE_MISMATCH, element, context.getLocation(child), message);
                    break block0;
                }
                if (!Character.isWhitespace(c)) break block0;
            }
            break;
        }
        if ((names = this.mTypeMap.get(type)) == null) {
            names = Sets.newHashSetWithExpectedSize((int)40);
            this.mTypeMap.put(type, names);
        }
        String originalName = name = attribute.getValue();
        if (names.contains(name = name.replace('.', '_').replace('-', '_').replace(':', '_'))) {
            String message = String.format("`%1$s` has already been defined in this folder", name);
            if (!name.equals(originalName)) {
                message = message + " (`" + name + "` is equivalent to `" + originalName + "`)";
            }
            Location location = context.getLocation(attribute);
            List<Pair<String, Location.Handle>> list = this.mLocations.get(type);
            for (Pair<String, Location.Handle> pair : list) {
                if (!name.equals(pair.getFirst())) continue;
                Location secondary = ((Location.Handle)pair.getSecond()).resolve();
                secondary.setMessage("Previously defined here");
                location.setSecondary(secondary);
            }
            context.report(ISSUE, attribute, location, message);
        } else {
            names.add(name);
            ArrayList list = this.mLocations.get(type);
            if (list == null) {
                list = Lists.newArrayList();
                this.mLocations.put(type, list);
            }
            Location.Handle handle = context.createLocationHandle(attribute);
            list.add(Pair.of((Object)name, (Object)handle));
        }
    }

    private static void checkUniqueNames(XmlContext context, Element parent) {
        List<Element> items = LintUtils.getChildren(parent);
        if (items.size() > 1) {
            HashSet names = Sets.newHashSet();
            for (Element item : items) {
                Attr nameNode = item.getAttributeNode("name");
                if (nameNode == null) continue;
                String name = nameNode.getValue();
                if (names.contains(name) && context.isEnabled(ISSUE)) {
                    Location location = context.getLocation(nameNode);
                    for (Element prevItem : items) {
                        Attr attribute = item.getAttributeNode("name");
                        if (attribute == null || !name.equals(attribute.getValue())) continue;
                        assert (prevItem != item);
                        Location prev = context.getLocation(prevItem);
                        prev.setMessage("Previously defined here");
                        location.setSecondary(prev);
                        break;
                    }
                    String message = String.format("`%1$s` has already been defined in this `<%2$s>`", name, parent.getTagName());
                    context.report(ISSUE, nameNode, location, message);
                }
                names.add(name);
            }
        }
    }

    private static boolean isFirstElementChild(Node node) {
        for (node = node.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    public static String getExpectedType(@NonNull String message, @NonNull TextFormat format) {
        return LintUtils.findSubstring(format.toText(message), "value of type @", "/");
    }
}

