/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitCommit;
import git4idea.GitExecutionException;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitImpl
implements Git {
    private final Logger LOG = Logger.getInstance(Git.class);
    public static final String[] ERROR_INDICATORS = new String[]{"error", "remote: error", "fatal", "Cannot", "Could not", "Interactive rebase already started", "refusing to pull", "cannot rebase:", "conflict", "unable"};

    @Override
    @NotNull
    public GitCommandResult init(@NotNull Project project, @NotNull VirtualFile root, GitLineHandlerListener ... listeners) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/commands/GitImpl", "init"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/commands/GitImpl", "init"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "init"));
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.INIT);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "init"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public Set<VirtualFile> untrackedFiles(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<VirtualFile> files) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/commands/GitImpl", "untrackedFiles"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/commands/GitImpl", "untrackedFiles"));
        }
        HashSet<VirtualFile> untrackedFiles = new HashSet<VirtualFile>();
        if (files == null) {
            untrackedFiles.addAll(this.untrackedFilesNoChunk(project, root, null));
        } else {
            for (List relativePaths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
                untrackedFiles.addAll(this.untrackedFilesNoChunk(project, root, relativePaths));
            }
        }
        HashSet<VirtualFile> hashSet = untrackedFiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "untrackedFiles"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> untrackedFilesNoChunk(@NotNull Project project, @NotNull VirtualFile root, @Nullable List<String> relativePaths) throws VcsException {
        String output;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/commands/GitImpl", "untrackedFilesNoChunk"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/commands/GitImpl", "untrackedFilesNoChunk"));
        }
        HashSet<VirtualFile> untrackedFiles = new HashSet<VirtualFile>();
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LS_FILES);
        h.setSilent(true);
        h.addParameters("--exclude-standard", "--others", "-z");
        h.endOptions();
        if (relativePaths != null) {
            h.addParameters(relativePaths);
        }
        if (StringUtil.isEmptyOrSpaces((String)(output = h.run()))) {
            HashSet<VirtualFile> hashSet = untrackedFiles;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "untrackedFilesNoChunk"));
            }
            return hashSet;
        }
        for (String relPath : output.split("\u0000")) {
            VirtualFile f = root.findFileByRelativePath(relPath);
            if (f == null) {
                this.LOG.info(String.format("VirtualFile for path [%s] is null", relPath));
                continue;
            }
            untrackedFiles.add(f);
        }
        HashSet<VirtualFile> hashSet = untrackedFiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "untrackedFilesNoChunk"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public GitCommandResult clone(final @NotNull Project project, final @NotNull File parentDirectory, final @NotNull String url, final @NotNull String clonedDirectoryName, final GitLineHandlerListener ... listeners) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/commands/GitImpl", "clone"));
        }
        if (parentDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDirectory", "git4idea/commands/GitImpl", "clone"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitImpl", "clone"));
        }
        if (clonedDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clonedDirectoryName", "git4idea/commands/GitImpl", "clone"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "clone"));
        }
        GitCommandResult gitCommandResult = GitImpl.run(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler handler = new GitLineHandler(project, parentDirectory, GitCommand.CLONE);
                handler.setStdoutSuppressed(false);
                handler.setUrl(url);
                handler.addParameters("--progress");
                handler.addParameters(url);
                handler.addParameters(clonedDirectoryName);
                GitImpl.addListeners(handler, listeners);
                return handler;
            }
        });
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "clone"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult config(@NotNull GitRepository repository, String ... params) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "config"));
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CONFIG);
        h.addParameters(params);
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "config"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult diff(@NotNull GitRepository repository, @NotNull List<String> parameters, @NotNull String range) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "diff"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/commands/GitImpl", "diff"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "git4idea/commands/GitImpl", "diff"));
        }
        GitLineHandler diff = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.DIFF);
        diff.addParameters(parameters);
        diff.addParameters(range);
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        GitCommandResult gitCommandResult = GitImpl.run(diff);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "diff"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkAttr(@NotNull GitRepository repository, @NotNull Collection<String> attributes, @NotNull Collection<VirtualFile> files) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "checkAttr"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "git4idea/commands/GitImpl", "checkAttr"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/commands/GitImpl", "checkAttr"));
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECK_ATTR);
        h.addParameters(new ArrayList<String>(attributes));
        h.endOptions();
        h.addRelativeFiles(files);
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "checkAttr"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult stashSave(@NotNull GitRepository repository, @NotNull String message) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "stashSave"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/commands/GitImpl", "stashSave"));
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        h.addParameters("save");
        h.addParameters(message);
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "stashSave"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult stashPop(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "stashPop"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "stashPop"));
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        handler.addParameters("pop");
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = GitImpl.run(handler);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "stashPop"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public List<GitCommit> history(@NotNull GitRepository repository, @NotNull String range) {
        List<GitCommit> list;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "history"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "git4idea/commands/GitImpl", "history"));
        }
        try {
            list = GitHistoryUtils.history(repository.getProject(), repository.getRoot(), range);
        }
        catch (VcsException e) {
            throw new GitExecutionException("Couldn't get [git log " + range + "] on repository [" + repository.getRoot() + "]", e);
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "history"));
        }
        return list;
    }

    @Override
    @NotNull
    public GitCommandResult merge(@NotNull GitRepository repository, @NotNull String branchToMerge, @Nullable List<String> additionalParams, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "merge"));
        }
        if (branchToMerge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchToMerge", "git4idea/commands/GitImpl", "merge"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "merge"));
        }
        GitLineHandler mergeHandler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.MERGE);
        mergeHandler.setSilent(false);
        mergeHandler.addParameters(branchToMerge);
        if (additionalParams != null) {
            mergeHandler.addParameters(additionalParams);
        }
        for (GitLineHandlerListener listener : listeners) {
            mergeHandler.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = GitImpl.run(mergeHandler);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "merge"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkout(@NotNull GitRepository repository, @NotNull String reference, @Nullable String newBranch, boolean force, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "checkout"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "git4idea/commands/GitImpl", "checkout"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "checkout"));
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        if (force) {
            h.addParameters("--force");
        }
        if (newBranch == null) {
            h.addParameters(reference);
        } else {
            h.addParameters("-b", newBranch, reference);
        }
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "checkout"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkoutNewBranch(@NotNull GitRepository repository, @NotNull String branchName, @Nullable GitLineHandlerListener listener) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "checkoutNewBranch"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/commands/GitImpl", "checkoutNewBranch"));
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT.readLockingCommand());
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters("-b");
        h.addParameters(branchName);
        if (listener != null) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "checkoutNewBranch"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult createNewTag(@NotNull GitRepository repository, @NotNull String tagName, @Nullable GitLineHandlerListener listener, @NotNull String reference) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "createNewTag"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "git4idea/commands/GitImpl", "createNewTag"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "git4idea/commands/GitImpl", "createNewTag"));
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.TAG);
        h.setSilent(false);
        h.addParameters(tagName);
        if (!reference.isEmpty()) {
            h.addParameters(reference);
        }
        if (listener != null) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "createNewTag"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchDelete(@NotNull GitRepository repository, @NotNull String branchName, boolean force, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "branchDelete"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/commands/GitImpl", "branchDelete"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "branchDelete"));
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters(force ? "-D" : "-d");
        h.addParameters(branchName);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "branchDelete"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchContains(@NotNull GitRepository repository, @NotNull String commit) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "branchContains"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/commands/GitImpl", "branchContains"));
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.addParameters("--contains", commit);
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "branchContains"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchCreate(@NotNull GitRepository repository, @NotNull String branchName) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "branchCreate"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/commands/GitImpl", "branchCreate"));
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setStdoutSuppressed(false);
        h.addParameters(branchName);
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "branchCreate"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult reset(@NotNull GitRepository repository, @NotNull GitResetMode mode, @NotNull String target, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "reset"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "git4idea/commands/GitImpl", "reset"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "git4idea/commands/GitImpl", "reset"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "reset"));
        }
        GitCommandResult gitCommandResult = GitImpl.reset(repository, mode.getArgument(), target, listeners);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "reset"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult resetMerge(@NotNull GitRepository repository, @Nullable String revision) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "resetMerge"));
        }
        GitCommandResult gitCommandResult = GitImpl.reset(repository, "--merge", revision, new GitLineHandlerListener[0]);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "resetMerge"));
        }
        return gitCommandResult;
    }

    @NotNull
    private static GitCommandResult reset(@NotNull GitRepository repository, @NotNull String argument, @Nullable String target, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "reset"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "git4idea/commands/GitImpl", "reset"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "reset"));
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.RESET);
        handler.addParameters(argument);
        if (target != null) {
            handler.addParameters(target);
        }
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = GitImpl.run(handler);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "reset"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult tip(@NotNull GitRepository repository, @NotNull String branchName) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "tip"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/commands/GitImpl", "tip"));
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REV_LIST);
        h.addParameters("-1");
        h.addParameters(branchName);
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "tip"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull String remote, @Nullable String url, @NotNull String spec, boolean updateTracking, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "push"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/commands/GitImpl", "push"));
        }
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "git4idea/commands/GitImpl", "push"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "push"));
        }
        GitCommandResult gitCommandResult = this.doPush(repository, remote, url, spec, false, updateTracking, null, listeners);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "push"));
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult doPush(final @NotNull GitRepository repository, final @NotNull String remote, final @Nullable String url, final @NotNull String spec, final boolean force, final boolean updateTracking, final @Nullable String tagMode, final GitLineHandlerListener ... listeners) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "doPush"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/commands/GitImpl", "doPush"));
        }
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "git4idea/commands/GitImpl", "doPush"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "doPush"));
        }
        GitCommandResult gitCommandResult = this.runCommand(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.PUSH);
                if (url != null) {
                    h.setUrl(url);
                }
                h.setSilent(false);
                h.setStdoutSuppressed(false);
                GitImpl.addListeners(h, listeners);
                h.addProgressParameter();
                h.addParameters("--porcelain");
                h.addParameters(remote);
                h.addParameters(spec);
                if (updateTracking) {
                    h.addParameters("--set-upstream");
                }
                if (force) {
                    h.addParameters("--force");
                }
                if (tagMode != null) {
                    h.addParameters(tagMode);
                }
                return h;
            }
        });
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "doPush"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull String remote, @Nullable String url, @NotNull String spec, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "push"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/commands/GitImpl", "push"));
        }
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "git4idea/commands/GitImpl", "push"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "push"));
        }
        GitCommandResult gitCommandResult = this.push(repository, remote, url, spec, false, listeners);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "push"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull GitLocalBranch source, @NotNull GitRemoteBranch target, boolean force, boolean updateTracking, @Nullable String tagMode, GitLineHandlerListener ... listeners) {
        String url;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "push"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "git4idea/commands/GitImpl", "push"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "git4idea/commands/GitImpl", "push"));
        }
        GitRemote remote = target.getRemote();
        Collection<String> pushUrls = remote.getPushUrls();
        if (pushUrls.isEmpty()) {
            this.LOG.error("No urls or pushUrls are defined for " + remote);
            url = null;
        } else {
            url = pushUrls.iterator().next();
        }
        String spec = source.getFullName() + ":" + target.getNameForRemoteOperations();
        GitCommandResult gitCommandResult = this.doPush(repository, remote.getName(), url, spec, force, updateTracking, tagMode, listeners);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "push"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult show(@NotNull GitRepository repository, String ... params) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "show"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "git4idea/commands/GitImpl", "show"));
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.SHOW);
        handler.addParameters(params);
        GitCommandResult gitCommandResult = GitImpl.run(handler);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "show"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult cherryPick(@NotNull GitRepository repository, @NotNull String hash, boolean autoCommit, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "cherryPick"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/commands/GitImpl", "cherryPick"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "cherryPick"));
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHERRY_PICK);
        handler.addParameters("-x");
        if (!autoCommit) {
            handler.addParameters("-n");
        }
        handler.addParameters(hash);
        GitImpl.addListeners(handler, listeners);
        handler.setSilent(false);
        handler.setStdoutSuppressed(false);
        GitCommandResult gitCommandResult = GitImpl.run(handler);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "cherryPick"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult getUnmergedFiles(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "getUnmergedFiles"));
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.LS_FILES);
        h.addParameters("--unmerged");
        h.setSilent(true);
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "getUnmergedFiles"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult fetch(final @NotNull GitRepository repository, final @NotNull String url, final @NotNull String remote, final @NotNull List<GitLineHandlerListener> listeners, final String ... params) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "fetch"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitImpl", "fetch"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/commands/GitImpl", "fetch"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "fetch"));
        }
        GitCommandResult gitCommandResult = this.runCommand(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.FETCH);
                h.setSilent(false);
                h.setStdoutSuppressed(false);
                h.setUrl(url);
                h.addParameters(remote);
                h.addParameters(params);
                h.addProgressParameter();
                GitVcs vcs = GitVcs.getInstance(repository.getProject());
                if (vcs != null && GitVersionSpecialty.SUPPORTS_FETCH_PRUNE.existsIn(vcs.getVersion())) {
                    h.addParameters("--prune");
                }
                GitImpl.addListeners(h, listeners);
                return h;
            }
        });
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "fetch"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult addRemote(@NotNull GitRepository repository, @NotNull String name, @NotNull String url) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/commands/GitImpl", "addRemote"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/commands/GitImpl", "addRemote"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitImpl", "addRemote"));
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("add", name, url);
        GitCommandResult gitCommandResult = GitImpl.run(h);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "addRemote"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull File workingDir, @NotNull String url) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/commands/GitImpl", "lsRemote"));
        }
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "git4idea/commands/GitImpl", "lsRemote"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitImpl", "lsRemote"));
        }
        GitCommandResult gitCommandResult = this.doLsRemote(project, workingDir, url, url, new String[0]);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "lsRemote"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull GitRemote remote, String ... additionalParameters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/commands/GitImpl", "lsRemote"));
        }
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "git4idea/commands/GitImpl", "lsRemote"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/commands/GitImpl", "lsRemote"));
        }
        GitCommandResult gitCommandResult = this.doLsRemote(project, VfsUtilCore.virtualToIoFile((VirtualFile)workingDir), remote.getName(), remote.getFirstUrl(), additionalParameters);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "lsRemote"));
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult doLsRemote(final @NotNull Project project, final @NotNull File workingDir, final @NotNull String remoteId, final @Nullable String authenticationUrl, final String ... additionalParameters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/commands/GitImpl", "doLsRemote"));
        }
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "git4idea/commands/GitImpl", "doLsRemote"));
        }
        if (remoteId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteId", "git4idea/commands/GitImpl", "doLsRemote"));
        }
        GitCommandResult gitCommandResult = GitImpl.run(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler h = new GitLineHandler(project, workingDir, GitCommand.LS_REMOTE);
                h.addParameters(additionalParameters);
                h.addParameters(remoteId);
                if (authenticationUrl != null) {
                    h.setUrl(authenticationUrl);
                } else {
                    GitImpl.this.LOG.error("No valid URLs for remote " + remoteId);
                }
                return h;
            }
        });
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "doLsRemote"));
        }
        return gitCommandResult;
    }

    private static void addListeners(@NotNull GitLineHandler handler, GitLineHandlerListener ... listeners) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/commands/GitImpl", "addListeners"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "addListeners"));
        }
        GitImpl.addListeners(handler, Arrays.asList(listeners));
    }

    private static void addListeners(@NotNull GitLineHandler handler, @NotNull List<GitLineHandlerListener> listeners) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/commands/GitImpl", "addListeners"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/commands/GitImpl", "addListeners"));
        }
        for (GitLineHandlerListener listener : listeners) {
            handler.addLineListener(listener);
        }
    }

    @NotNull
    private static GitCommandResult run(@NotNull Computable<GitLineHandler> handlerConstructor) {
        boolean success;
        boolean authFailed;
        if (handlerConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlerConstructor", "git4idea/commands/GitImpl", "run"));
        }
        final ArrayList<String> errorOutput = new ArrayList<String>();
        final ArrayList<String> output = new ArrayList<String>();
        final AtomicInteger exitCode = new AtomicInteger();
        final AtomicBoolean startFailed = new AtomicBoolean();
        final AtomicReference<Object> exception = new AtomicReference<Object>();
        int authAttempt = 0;
        do {
            errorOutput.clear();
            output.clear();
            exitCode.set(0);
            startFailed.set(false);
            exception.set(null);
            GitLineHandler handler = (GitLineHandler)handlerConstructor.compute();
            handler.addLineListener(new GitLineHandlerListener(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (GitImpl.isError(line)) {
                        errorOutput.add(line);
                    } else {
                        output.add(line);
                    }
                }

                public void processTerminated(int code) {
                    exitCode.set(code);
                }

                public void startFailed(Throwable t) {
                    startFailed.set(true);
                    errorOutput.add("Failed to start Git process");
                    exception.set(t);
                }
            });
            handler.runInCurrentThread(null);
            authFailed = handler.hasHttpAuthFailed();
            boolean bl = success = !startFailed.get() && errorOutput.isEmpty() && (handler.isIgnoredErrorCode(exitCode.get()) || exitCode.get() == 0);
        } while (authFailed && authAttempt++ < 2);
        GitCommandResult gitCommandResult = new GitCommandResult(success, exitCode.get(), errorOutput, output, null);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "run"));
        }
        return gitCommandResult;
    }

    @NotNull
    private static GitCommandResult run(@NotNull GitLineHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/commands/GitImpl", "run"));
        }
        GitCommandResult gitCommandResult = GitImpl.run((Computable<GitLineHandler>)new Computable.PredefinedValueComputable((Object)handler));
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "run"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull Computable<GitLineHandler> handlerConstructor) {
        if (handlerConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlerConstructor", "git4idea/commands/GitImpl", "runCommand"));
        }
        GitCommandResult gitCommandResult = GitImpl.run(handlerConstructor);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "runCommand"));
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(final @NotNull GitLineHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/commands/GitImpl", "runCommand"));
        }
        GitCommandResult gitCommandResult = this.runCommand(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                return handler;
            }
        });
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitImpl", "runCommand"));
        }
        return gitCommandResult;
    }

    private static boolean isError(String text) {
        for (String indicator : ERROR_INDICATORS) {
            if (!text.trim().toLowerCase().startsWith(indicator.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

