/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitTextHandler
extends GitHandler {
    private OSProcessHandler myHandler;
    private volatile boolean myIsDestroyed;
    private final Object myProcessStateLock;

    protected GitTextHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/commands/GitTextHandler", "<init>"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "git4idea/commands/GitTextHandler", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "git4idea/commands/GitTextHandler", "<init>"));
        }
        super(project, directory, command);
        this.myProcessStateLock = new Object();
    }

    protected GitTextHandler(Project project, VirtualFile vcsRoot, GitCommand command) {
        super(project, vcsRoot, command);
        this.myProcessStateLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Process startProcess() throws ExecutionException {
        Object object = this.myProcessStateLock;
        synchronized (object) {
            if (this.myIsDestroyed) {
                return null;
            }
            ProcessHandler processHandler = this.createProcess(this.myCommandLine);
            this.myHandler = (OSProcessHandler)processHandler;
            return this.myHandler.getProcess();
        }
    }

    @Override
    protected void startHandlingStreams() {
        if (this.myHandler == null) {
            return;
        }
        this.myHandler.addProcessListener(new ProcessListener(){

            public void startNotified(ProcessEvent event) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processTerminated(ProcessEvent event) {
                int exitCode = event.getExitCode();
                try {
                    GitTextHandler.this.setExitCode(exitCode);
                    GitTextHandler.this.cleanupEnv();
                    GitTextHandler.this.processTerminated(exitCode);
                }
                finally {
                    GitTextHandler.this.listeners().processTerminated(exitCode);
                }
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                GitTextHandler.this.onTextAvailable(event.getText(), outputType);
            }
        });
        this.myHandler.startNotify();
    }

    protected abstract void processTerminated(int var1);

    protected abstract void onTextAvailable(String var1, Key var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyProcess() {
        Object object = this.myProcessStateLock;
        synchronized (object) {
            this.myIsDestroyed = true;
            if (this.myHandler != null) {
                this.myHandler.destroyProcess();
            }
        }
    }

    @Override
    protected void waitForProcess() {
        if (this.myHandler != null) {
            this.myHandler.waitFor();
        }
    }

    public ProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "git4idea/commands/GitTextHandler", "createProcess"));
        }
        Process process = commandLine.createProcess();
        return new MyOSProcessHandler(process, commandLine, this.getCharset());
    }

    private static class MyOSProcessHandler
    extends OSProcessHandler {
        @NotNull
        private final Charset myCharset;

        public MyOSProcessHandler(Process process, GeneralCommandLine commandLine, @NotNull Charset charset) {
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "git4idea/commands/GitTextHandler$MyOSProcessHandler", "<init>"));
            }
            super(process, commandLine.getCommandLineString());
            this.myCharset = charset;
        }

        @NotNull
        public Charset getCharset() {
            Charset charset = this.myCharset;
            if (charset == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitTextHandler$MyOSProcessHandler", "getCharset"));
            }
            return charset;
        }
    }
}

