/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.FileUtils;

public final class DirectoryObject
extends AbstractFileObject {
    private static final DirectoryObject ROOT = new DirectoryObject("/");

    public static DirectoryObject getRoot() {
        return ROOT;
    }

    public static DirectoryObject createInstance(String relativeFileName) {
        return new DirectoryObject(relativeFileName);
    }

    public static DirectoryObject createInstance(DirectoryObject directoryObject, String directoryPathRelativeToDirectoryObject) {
        String relativeFileName = FileUtils.ensureTrailingSlash(directoryObject.getPath()) + FileUtils.removeLeadingSlash(directoryPathRelativeToDirectoryObject);
        return DirectoryObject.createInstance(relativeFileName);
    }

    private DirectoryObject(String relativeFileName) {
        super(relativeFileName);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    public final boolean isParentOf(AbstractFileObject abstractFileObject) {
        String directoryPath = this.getPath();
        String path = abstractFileObject.getPath();
        if (path.length() <= directoryPath.length()) {
            return false;
        }
        return path.startsWith(directoryPath);
    }
}

