/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SvnScopeZipper
implements Runnable {
    @NotNull
    private final VcsDirtyScope myIn;
    @NotNull
    private final List<FilePath> myRecursiveDirs;
    @NotNull
    private final Map<String, MyDirNonRecursive> myNonRecursiveDirs;

    public SvnScopeZipper(@NotNull VcsDirtyScope in) {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/idea/svn/SvnScopeZipper", "<init>"));
        }
        this.myIn = in;
        this.myRecursiveDirs = ContainerUtil.newArrayList((Iterable)in.getRecursivelyDirtyDirectories());
        this.myNonRecursiveDirs = ContainerUtil.newHashMap();
    }

    @Override
    public void run() {
        Set files = this.myIn.getDirtyFilesNoExpand();
        for (FilePath file : files) {
            if (file.isDirectory()) {
                VirtualFile vFile = file.getVirtualFile();
                MyDirNonRecursive me = this.createOrGet(file);
                if (vFile == null || !vFile.isValid()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    me.add((FilePath)new FilePathImpl(child));
                }
                continue;
            }
            FilePath parent = file.getParentPath();
            if (parent == null) continue;
            MyDirNonRecursive item = this.createOrGet(parent);
            item.add(file);
        }
    }

    @NotNull
    private MyDirNonRecursive createOrGet(@NotNull FilePath parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/idea/svn/SvnScopeZipper", "createOrGet"));
        }
        String key = SvnScopeZipper.getKey(parent);
        MyDirNonRecursive result = this.myNonRecursiveDirs.get(key);
        if (result == null) {
            result = new MyDirNonRecursive(parent);
            this.myNonRecursiveDirs.put(key, result);
        }
        MyDirNonRecursive myDirNonRecursive = result;
        if (myDirNonRecursive == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnScopeZipper", "createOrGet"));
        }
        return myDirNonRecursive;
    }

    @NotNull
    public List<FilePath> getRecursiveDirs() {
        List<FilePath> list = this.myRecursiveDirs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnScopeZipper", "getRecursiveDirs"));
        }
        return list;
    }

    @NotNull
    public Map<String, MyDirNonRecursive> getNonRecursiveDirs() {
        Map<String, MyDirNonRecursive> map = this.myNonRecursiveDirs;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnScopeZipper", "getNonRecursiveDirs"));
        }
        return map;
    }

    public static String getKey(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnScopeZipper", "getKey"));
        }
        return path.getPresentableUrl();
    }

    static class MyDirNonRecursive {
        @NotNull
        private final FilePath myDir;
        @NotNull
        private final Map<String, FilePath> myChildren;

        private MyDirNonRecursive(@NotNull FilePath dir) {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/idea/svn/SvnScopeZipper$MyDirNonRecursive", "<init>"));
            }
            this.myDir = dir;
            this.myChildren = ContainerUtil.newHashMap();
        }

        public void add(@NotNull FilePath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnScopeZipper$MyDirNonRecursive", "add"));
            }
            this.myChildren.put(SvnScopeZipper.getKey(path), path);
        }

        @NotNull
        public Collection<FilePath> getChildrenList() {
            Collection<FilePath> collection = this.myChildren.values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnScopeZipper$MyDirNonRecursive", "getChildrenList"));
            }
            return collection;
        }

        @NotNull
        public FilePath getDir() {
            FilePath filePath = this.myDir;
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnScopeZipper$MyDirNonRecursive", "getDir"));
            }
            return filePath;
        }
    }
}

