/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnFileSystemListener;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.properties.PropertiesMap;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.rollback.CopiedAsideInfo;
import org.jetbrains.idea.svn.rollback.ThroughRenameInfo;
import org.jetbrains.idea.svn.rollback.UnversionedAndNotTouchedFilesGroupCollector;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class Reverter {
    @NotNull
    private final SvnVcs myVcs;
    private final ProgressTracker myHandler;
    private final List<VcsException> myExceptions;
    private final List<CopiedAsideInfo> myFromToModified;
    private final Map<File, PropertiesMap> myProperties;

    Reverter(@NotNull SvnVcs vcs, @NotNull RollbackProgressListener listener, @NotNull List<VcsException> exceptions) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/rollback/Reverter", "<init>"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/idea/svn/rollback/Reverter", "<init>"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "org/jetbrains/idea/svn/rollback/Reverter", "<init>"));
        }
        this.myVcs = vcs;
        this.myHandler = Reverter.createRevertHandler(exceptions, listener);
        this.myExceptions = exceptions;
        this.myFromToModified = ContainerUtil.newArrayList();
        this.myProperties = ContainerUtil.newHashMap();
    }

    public void revert(@NotNull Collection<File> files, boolean recursive) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/svn/rollback/Reverter", "revert"));
        }
        if (files.isEmpty()) {
            return;
        }
        File target = files.iterator().next();
        try {
            this.myVcs.getFactory(target).createRevertClient().revert(files, Depth.allOrEmpty(recursive), this.myHandler);
        }
        catch (VcsException e) {
            this.processRevertError(e);
        }
    }

    public void moveRenamesToTmp(@NotNull UnversionedAndNotTouchedFilesGroupCollector collector) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/idea/svn/rollback/Reverter", "moveRenamesToTmp"));
        }
        try {
            File tmp = FileUtil.createTempDirectory((String)"forRename", (String)"");
            PropertyConsumer handler = Reverter.createPropertyHandler(this.myProperties, collector);
            for (Map.Entry<File, ThroughRenameInfo> entry : collector.getFromTo().entrySet()) {
                File source = entry.getKey();
                ThroughRenameInfo info = entry.getValue();
                if (info.isVersioned()) {
                    this.myVcs.getFactory(source).createPropertyClient().list(SvnTarget.fromFile((File)source), SVNRevision.WORKING, Depth.EMPTY, handler);
                }
                if (source.isDirectory()) {
                    if (FileUtil.filesEqual((File)info.getTo(), (File)info.getFirstTo())) continue;
                    this.myFromToModified.add(new CopiedAsideInfo(info.getParentImmediateReverted(), info.getTo(), info.getFirstTo(), null));
                    continue;
                }
                File tmpFile = FileUtil.createTempFile((File)tmp, (String)source.getName(), (String)"", (boolean)false);
                tmpFile.mkdirs();
                FileUtil.delete((File)tmpFile);
                FileUtil.copy((File)source, (File)tmpFile);
                this.myFromToModified.add(new CopiedAsideInfo(info.getParentImmediateReverted(), info.getTo(), info.getFirstTo(), tmpFile));
            }
        }
        catch (IOException e) {
            this.myExceptions.add(new VcsException((Throwable)e));
        }
        catch (VcsException e) {
            this.myExceptions.add(e);
        }
    }

    public void moveGroup() {
        Collections.sort(this.myFromToModified, new Comparator<CopiedAsideInfo>(){

            @Override
            public int compare(CopiedAsideInfo o1, CopiedAsideInfo o2) {
                return FileUtil.compareFiles((File)o1.getTo(), (File)o2.getTo());
            }
        });
        for (CopiedAsideInfo info : this.myFromToModified) {
            if (!info.getParentImmediateReverted().exists()) continue;
            try {
                File root;
                File from = info.getFrom();
                final File target = info.getTo();
                if (from != null && !FileUtil.filesEqual((File)from, (File)target) && !target.exists()) {
                    SvnFileSystemListener.moveFileWithSvn(this.myVcs, from, target);
                }
                if ((root = info.getTmpPlace()) == null) continue;
                if (!root.isDirectory()) {
                    if (target.exists()) {
                        FileUtil.copy((File)root, (File)target);
                        continue;
                    }
                    FileUtil.rename((File)root, (File)target);
                    continue;
                }
                FileUtil.processFilesRecursively((File)root, (Processor)new Processor<File>(){

                    public boolean process(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        String relativePath = FileUtil.getRelativePath((String)root.getPath(), (String)file.getPath(), (char)File.separatorChar);
                        File newFile = new File(target, relativePath);
                        newFile.getParentFile().mkdirs();
                        try {
                            if (target.exists()) {
                                FileUtil.copy((File)file, (File)newFile);
                            } else {
                                FileUtil.rename((File)file, (File)newFile);
                            }
                        }
                        catch (IOException e) {
                            Reverter.this.myExceptions.add(new VcsException((Throwable)e));
                        }
                        return true;
                    }
                });
            }
            catch (IOException e) {
                this.myExceptions.add(new VcsException((Throwable)e));
            }
            catch (VcsException e) {
                this.myExceptions.add(e);
            }
        }
        this.applyProperties();
    }

    private void applyProperties() {
        for (Map.Entry<File, PropertiesMap> entry : this.myProperties.entrySet()) {
            File file = entry.getKey();
            try {
                this.myVcs.getFactory(file).createPropertyClient().setProperties(file, entry.getValue());
            }
            catch (VcsException e) {
                this.myExceptions.add(e);
            }
        }
    }

    private void processRevertError(@NotNull VcsException e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/rollback/Reverter", "processRevertError"));
        }
        if (e.getCause() instanceof SVNException) {
            SVNException cause = (SVNException)e.getCause();
            if (cause.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) {
                this.myExceptions.add(e);
            }
        } else {
            this.myExceptions.add(e);
        }
    }

    @NotNull
    private static ProgressTracker createRevertHandler(final @NotNull List<VcsException> exceptions, final @NotNull RollbackProgressListener listener) {
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "org/jetbrains/idea/svn/rollback/Reverter", "createRevertHandler"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/idea/svn/rollback/Reverter", "createRevertHandler"));
        }
        ProgressTracker progressTracker = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                File file;
                if (event.getAction() == EventAction.REVERT && (file = event.getFile()) != null) {
                    listener.accept(file);
                }
                if (event.getAction() == EventAction.FAILED_REVERT) {
                    exceptions.add(new VcsException("Revert failed"));
                }
            }

            @Override
            public void checkCancelled() {
                listener.checkCanceled();
            }
        };
        if (progressTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/rollback/Reverter", "createRevertHandler"));
        }
        return progressTracker;
    }

    @NotNull
    private static PropertyConsumer createPropertyHandler(final @NotNull Map<File, PropertiesMap> properties, final @NotNull UnversionedAndNotTouchedFilesGroupCollector collector) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/svn/rollback/Reverter", "createPropertyHandler"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/idea/svn/rollback/Reverter", "createPropertyHandler"));
        }
        PropertyConsumer propertyConsumer = new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) throws SVNException {
                ThroughRenameInfo info = collector.findToFile((FilePath)new FilePathImpl(path, path.isDirectory()), null);
                if (info != null) {
                    if (!properties.containsKey(info.getTo())) {
                        properties.put(info.getTo(), new PropertiesMap());
                    }
                    ((PropertiesMap)((Object)properties.get(info.getTo()))).put(property.getName(), property.getValue());
                }
            }

            @Override
            public void handleProperty(SVNURL url, PropertyData property) throws SVNException {
            }

            @Override
            public void handleProperty(long revision, PropertyData property) throws SVNException {
            }
        };
        if (propertyConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/rollback/Reverter", "createPropertyHandler"));
        }
        return propertyConsumer;
    }
}

