/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class ComboBoxPropertyEditor<V>
extends PropertyEditor<V> {
    protected final ComboBox myCbx = new ComboBox(-1);

    public ComboBoxPropertyEditor() {
        this.myCbx.setBorder(null);
        this.myCbx.addPopupMenuListener((PopupMenuListener)new MyPopupMenuListener());
    }

    @Override
    public final void updateUI() {
        SwingUtilities.updateComponentTreeUI((Component)this.myCbx);
        ListCellRenderer renderer = this.myCbx.getRenderer();
        if (renderer instanceof JComponent) {
            SwingUtilities.updateComponentTreeUI((JComponent)((Object)renderer));
        }
    }

    @Override
    public V getValue() throws Exception {
        if (this.myCbx.isEditable()) {
            Component editorComponent = this.myCbx.getEditor().getEditorComponent();
            return (V)((JTextField)editorComponent).getText();
        }
        return (V)this.myCbx.getSelectedItem();
    }

    private final class MyPopupMenuListener
    implements PopupMenuListener {
        private boolean myCancelled;

        private MyPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.myCancelled = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (!this.myCancelled) {
                ComboBoxPropertyEditor.this.fireValueCommitted(true, true);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.myCancelled = true;
        }
    }
}

