/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AstTransformContributor;

public class GrTypeDefinitionMembersCache {
    private static final Logger LOG = Logger.getInstance(GrTypeDefinitionMembersCache.class);
    private static final Condition<PsiMethod> CONSTRUCTOR_CONDITION = new Condition<PsiMethod>(){

        public boolean value(PsiMethod method) {
            return method.isConstructor();
        }
    };
    private final SimpleModificationTracker myTreeChangeTracker = new SimpleModificationTracker();
    private final GrTypeDefinition myDefinition;

    public GrTypeDefinitionMembersCache(GrTypeDefinition definition) {
        this.myDefinition = definition;
    }

    public GrMethod[] getCodeMethods() {
        return (GrMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<GrMethod[]>(){

            @Nullable
            public CachedValueProvider.Result<GrMethod[]> compute() {
                GrTypeDefinitionBody body = GrTypeDefinitionMembersCache.this.myDefinition.getBody();
                GrMethod[] methods = body != null ? body.getMethods() : GrMethod.EMPTY_ARRAY;
                return CachedValueProvider.Result.create((Object)methods, (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker});
            }
        });
    }

    public GrMethod[] getCodeConstructors() {
        return (GrMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<GrMethod[]>(){

            @Nullable
            public CachedValueProvider.Result<GrMethod[]> compute() {
                GrMethod[] methods;
                GrTypeDefinitionBody body = GrTypeDefinitionMembersCache.this.myDefinition.getBody();
                if (body != null) {
                    List result = ContainerUtil.findAll((Object[])body.getMethods(), (Condition)CONSTRUCTOR_CONDITION);
                    methods = result.toArray(new GrMethod[result.size()]);
                } else {
                    methods = GrMethod.EMPTY_ARRAY;
                }
                return CachedValueProvider.Result.create((Object)methods, (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker});
            }
        });
    }

    public PsiMethod[] getConstructors() {
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiMethod[]> compute() {
                List result = ContainerUtil.findAll((Object[])GrTypeDefinitionMembersCache.this.myDefinition.getMethods(), (Condition)CONSTRUCTOR_CONDITION);
                return CachedValueProvider.Result.create((Object)result.toArray(new PsiMethod[result.size()]), (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    public PsiClass[] getInnerClasses() {
        return (PsiClass[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<PsiClass[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiClass[]> compute() {
                GrTypeDefinitionBody body = GrTypeDefinitionMembersCache.this.myDefinition.getBody();
                PsiClass[] inners = body != null ? body.getInnerClasses() : PsiClass.EMPTY_ARRAY;
                return CachedValueProvider.Result.create((Object)inners, (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker});
            }
        });
    }

    public GrField[] getFields() {
        return (GrField[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<GrField[]>(){

            @Nullable
            public CachedValueProvider.Result<GrField[]> compute() {
                List fields = GrTypeDefinitionMembersCache.this.getFieldsImpl();
                return CachedValueProvider.Result.create((Object)fields.toArray(new GrField[fields.size()]), (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    private List<GrField> getFieldsImpl() {
        ArrayList fields = ContainerUtil.newArrayList((Object[])this.myDefinition.getCodeFields());
        fields.addAll(this.getSyntheticFields());
        return fields;
    }

    private List<GrField> getSyntheticFields() {
        return (List)CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<List<GrField>>(){

            @Nullable
            public CachedValueProvider.Result<List<GrField>> compute() {
                return CachedValueProvider.Result.create(AstTransformContributor.runContributorsForFields(GrTypeDefinitionMembersCache.this.myDefinition), (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    public PsiMethod[] getMethods() {
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)this.myDefinition, (CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

            public CachedValueProvider.Result<PsiMethod[]> compute() {
                ArrayList result = ContainerUtil.newArrayList();
                GrClassImplUtil.collectMethodsFromBody(GrTypeDefinitionMembersCache.this.myDefinition, result);
                for (PsiMethod method : AstTransformContributor.runContributorsForMethods(GrTypeDefinitionMembersCache.this.myDefinition)) {
                    GrClassImplUtil.addExpandingReflectedMethods(result, method);
                }
                for (GrField field : GrTypeDefinitionMembersCache.this.getSyntheticFields()) {
                    if (!field.isProperty()) continue;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)field.getSetter());
                    Collections.addAll(result, field.getGetters());
                }
                return CachedValueProvider.Result.create((Object)result.toArray(new PsiMethod[result.size()]), (Object[])new Object[]{GrTypeDefinitionMembersCache.this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    public void dropCaches() {
        this.myTreeChangeTracker.incModificationCount();
    }

    public static class TraitCollector
    extends AstTransformContributor {
        @Override
        public void collectMethods(@NotNull GrTypeDefinition clazz, Collection<PsiMethod> collector) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector", "collectMethods"));
            }
            if (clazz.isInterface() && !clazz.isTrait()) {
                return;
            }
            GrImplementsClause clause = clazz.getImplementsClause();
            if (clause == null) {
                return;
            }
            PsiClassType[] types = clause.getReferencedTypes();
            List<PsiClassType.ClassResolveResult> traits = TraitCollector.getSuperTraitsByCorrectOrder(types);
            if (traits.isEmpty()) {
                return;
            }
            Object[] codeMethods = clazz.getCodeMethods();
            HashSet existingSignatures = ContainerUtil.newHashSet((Iterable)ContainerUtil.map((Object[])codeMethods, (Function)new Function<PsiMethod, MethodSignature>(){

                public MethodSignature fun(PsiMethod method) {
                    return method.getSignature(PsiSubstitutor.EMPTY);
                }
            }));
            for (PsiClassType.ClassResolveResult resolveResult : traits) {
                GrTypeDefinition trait = (GrTypeDefinition)resolveResult.getElement();
                LOG.assertTrue(trait != null);
                List<CandidateInfo> concreteTraitMethods = new TraitProcessor<PsiMethod>(trait, resolveResult.getSubstitutor()){

                    @Override
                    protected void processTrait(@NotNull GrTypeDefinition trait, @NotNull PsiSubstitutor substitutor) {
                        if (trait == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trait", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector$2", "processTrait"));
                        }
                        if (substitutor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector$2", "processTrait"));
                        }
                        for (GrMethod grMethod : trait.getCodeMethods()) {
                            if (grMethod.getModifierList().hasExplicitModifier("abstract")) continue;
                            this.addCandidate(grMethod, substitutor);
                        }
                        for (GrDocCommentOwner grDocCommentOwner : trait.getCodeFields()) {
                            if (!grDocCommentOwner.isProperty()) continue;
                            for (GrAccessorMethod method : grDocCommentOwner.getGetters()) {
                                this.addCandidate(method, substitutor);
                            }
                            GrAccessorMethod setter = grDocCommentOwner.getSetter();
                            if (setter == null) continue;
                            this.addCandidate(setter, substitutor);
                        }
                    }
                }.getResult();
                for (CandidateInfo candidateInfo : concreteTraitMethods) {
                    List<GrMethod> methodsToAdd = TraitCollector.getExpandingMethods(clazz, candidateInfo);
                    for (GrMethod impl : methodsToAdd) {
                        if (!existingSignatures.add(impl.getSignature(PsiSubstitutor.EMPTY))) continue;
                        collector.add(impl);
                    }
                }
            }
        }

        @Override
        public void collectFields(@NotNull GrTypeDefinition clazz, Collection<GrField> collector) {
            GrImplementsClause clause;
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector", "collectFields"));
            }
            if (clazz.isInterface() && !clazz.isTrait()) {
                return;
            }
            if (clazz.isTrait()) {
                for (GrField field : clazz.getCodeFields()) {
                    collector.add(new GrTraitField(field, clazz, PsiSubstitutor.EMPTY));
                }
            }
            if ((clause = clazz.getImplementsClause()) == null) {
                return;
            }
            PsiClassType[] types = clause.getReferencedTypes();
            List<PsiClassType.ClassResolveResult> traits = TraitCollector.getSuperTraitsByCorrectOrder(types);
            for (PsiClassType.ClassResolveResult resolveResult : traits) {
                GrTypeDefinition trait = (GrTypeDefinition)resolveResult.getElement();
                LOG.assertTrue(trait != null);
                List<CandidateInfo> traitFields = new TraitProcessor<PsiField>(trait, resolveResult.getSubstitutor()){

                    @Override
                    protected void processTrait(@NotNull GrTypeDefinition trait, @NotNull PsiSubstitutor substitutor) {
                        if (trait == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trait", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector$3", "processTrait"));
                        }
                        if (substitutor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector$3", "processTrait"));
                        }
                        for (GrField field : trait.getCodeFields()) {
                            this.addCandidate(field, substitutor);
                        }
                    }
                }.getResult();
                for (CandidateInfo candidateInfo : traitFields) {
                    collector.add(new GrTraitField((PsiField)candidateInfo.getElement(), clazz, candidateInfo.getSubstitutor()));
                }
            }
            if (clazz.isTrait()) {
                for (GrField field : clazz.getCodeFields()) {
                    collector.add(new GrTraitField(field, clazz, PsiSubstitutor.EMPTY));
                }
            }
        }

        @NotNull
        private static List<GrMethod> getExpandingMethods(@NotNull GrTypeDefinition clazz, @NotNull CandidateInfo candidateInfo) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector", "getExpandingMethods"));
            }
            if (candidateInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateInfo", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector", "getExpandingMethods"));
            }
            PsiMethod method = (PsiMethod)candidateInfo.getElement();
            GrLightMethodBuilder implementation = GrTraitMethod.create(method, candidateInfo.getSubstitutor()).setContainingClass(clazz);
            implementation.getModifierList().removeModifier(1024);
            GrReflectedMethod[] reflectedMethods = implementation.getReflectedMethods();
            List<GrMethod> list = reflectedMethods.length > 0 ? Arrays.asList(reflectedMethods) : Collections.singletonList(implementation);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector", "getExpandingMethods"));
            }
            return list;
        }

        @NotNull
        private static List<PsiClassType.ClassResolveResult> getSuperTraitsByCorrectOrder(@NotNull PsiClassType[] types) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector", "getSuperTraitsByCorrectOrder"));
            }
            ArrayList traits = ContainerUtil.newArrayList();
            for (int i = types.length - 1; i >= 0; --i) {
                PsiClassType.ClassResolveResult resolveResult = types[i].resolveGenerics();
                PsiClass superClass = resolveResult.getElement();
                if (!GrTraitUtil.isTrait(superClass)) continue;
                traits.add(resolveResult);
            }
            ArrayList arrayList = traits;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector", "getSuperTraitsByCorrectOrder"));
            }
            return arrayList;
        }

        private static abstract class TraitProcessor<T extends PsiElement> {
            private final ArrayList<CandidateInfo> result;
            private final Set<PsiClass> processed;

            public TraitProcessor(@NotNull GrTypeDefinition superClass, @NotNull PsiSubstitutor substitutor) {
                if (superClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector$TraitProcessor", "<init>"));
                }
                if (substitutor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector$TraitProcessor", "<init>"));
                }
                this.result = ContainerUtil.newArrayList();
                this.processed = ContainerUtil.newHashSet();
                this.process(superClass, substitutor);
            }

            @NotNull
            public List<CandidateInfo> getResult() {
                ArrayList<CandidateInfo> arrayList = this.result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector$TraitProcessor", "getResult"));
                }
                return arrayList;
            }

            private void process(@NotNull GrTypeDefinition trait, @NotNull PsiSubstitutor substitutor) {
                if (trait == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trait", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector$TraitProcessor", "process"));
                }
                if (substitutor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache$TraitCollector$TraitProcessor", "process"));
                }
                assert (trait.isTrait());
                if (!this.processed.add(trait)) {
                    return;
                }
                this.processTrait(trait, substitutor);
                List traits = TraitCollector.getSuperTraitsByCorrectOrder(trait.getSuperTypes());
                for (PsiClassType.ClassResolveResult resolveResult : traits) {
                    PsiClass superClass = resolveResult.getElement();
                    if (!GrTraitUtil.isTrait(superClass)) continue;
                    PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)trait, (PsiSubstitutor)substitutor);
                    this.process((GrTypeDefinition)superClass, superSubstitutor);
                }
            }

            protected abstract void processTrait(@NotNull GrTypeDefinition var1, @NotNull PsiSubstitutor var2);

            protected void addCandidate(T element, PsiSubstitutor substitutor) {
                this.result.add(new CandidateInfo(element, substitutor));
            }
        }
    }
}

