/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenServerSettings
implements Serializable,
Cloneable {
    private int myLoggingLevel;
    @Nullable
    private File myMavenHome;
    @Nullable
    private File myUserSettingsFile;
    @Nullable
    private File myGlobalSettingsFile;
    @Nullable
    private File myLocalRepository;
    @NotNull
    private Properties myUserProperties = new Properties();
    private boolean isOffline;
    @NotNull
    private UpdatePolicy myPluginUpdatePolicy = UpdatePolicy.DO_NOT_UPDATE;
    @NotNull
    private UpdatePolicy mySnapshotUpdatePolicy = UpdatePolicy.ALWAYS_UPDATE;
    private String projectJdk;

    @Nullable
    public String getProjectJdk() {
        return this.projectJdk;
    }

    public void setProjectJdk(@Nullable String projectJdk) {
        this.projectJdk = projectJdk;
    }

    public int getLoggingLevel() {
        return this.myLoggingLevel;
    }

    public void setLoggingLevel(int loggingLevel) {
        this.myLoggingLevel = loggingLevel;
    }

    @NotNull
    public Properties getUserProperties() {
        Properties properties = this.myUserProperties;
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerSettings", "getUserProperties"));
        }
        return properties;
    }

    public void setUserProperties(@NotNull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/maven/server/MavenServerSettings", "setUserProperties"));
        }
        this.myUserProperties = properties;
    }

    @Nullable
    public File getMavenHome() {
        return this.myMavenHome;
    }

    public void setMavenHome(@Nullable File mavenHome) {
        this.myMavenHome = mavenHome;
    }

    @Nullable
    public File getUserSettingsFile() {
        return this.myUserSettingsFile;
    }

    public void setUserSettingsFile(@Nullable File userSettingsFile) {
        this.myUserSettingsFile = userSettingsFile;
    }

    @Nullable
    public File getGlobalSettingsFile() {
        return this.myGlobalSettingsFile;
    }

    public void setGlobalSettingsFile(@Nullable File globalSettingsFile) {
        this.myGlobalSettingsFile = globalSettingsFile;
    }

    @Nullable
    public File getLocalRepository() {
        return this.myLocalRepository;
    }

    public void setLocalRepository(@Nullable File localRepository) {
        this.myLocalRepository = localRepository;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public void setOffline(boolean offline) {
        this.isOffline = offline;
    }

    @NotNull
    public UpdatePolicy getPluginUpdatePolicy() {
        UpdatePolicy updatePolicy = this.myPluginUpdatePolicy;
        if (updatePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerSettings", "getPluginUpdatePolicy"));
        }
        return updatePolicy;
    }

    public void setPluginUpdatePolicy(@NotNull UpdatePolicy pluginUpdatePolicy) {
        if (pluginUpdatePolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginUpdatePolicy", "org/jetbrains/idea/maven/server/MavenServerSettings", "setPluginUpdatePolicy"));
        }
        this.myPluginUpdatePolicy = pluginUpdatePolicy;
    }

    @NotNull
    public UpdatePolicy getSnapshotUpdatePolicy() {
        UpdatePolicy updatePolicy = this.mySnapshotUpdatePolicy;
        if (updatePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerSettings", "getSnapshotUpdatePolicy"));
        }
        return updatePolicy;
    }

    public void setSnapshotUpdatePolicy(@NotNull UpdatePolicy snapshotUpdatePolicy) {
        if (snapshotUpdatePolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snapshotUpdatePolicy", "org/jetbrains/idea/maven/server/MavenServerSettings", "setSnapshotUpdatePolicy"));
        }
        this.mySnapshotUpdatePolicy = snapshotUpdatePolicy;
    }

    public MavenServerSettings clone() {
        try {
            return (MavenServerSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum UpdatePolicy {
        ALWAYS_UPDATE,
        DO_NOT_UPDATE;

    }
}

