/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.tools.idea.editors.navigation.ActivityInspector;
import com.android.tools.idea.editors.navigation.AndroidRootComponent;
import com.android.tools.idea.editors.navigation.Event;
import com.android.tools.idea.editors.navigation.Inspector;
import com.android.tools.idea.editors.navigation.MenuInspector;
import com.android.tools.idea.editors.navigation.NavigationView;
import com.android.tools.idea.editors.navigation.RenderingParameters;
import com.android.tools.idea.editors.navigation.Transform;
import com.android.tools.idea.editors.navigation.TransitionInspector;
import com.android.tools.idea.editors.navigation.Utilities;
import com.android.tools.idea.editors.navigation.macros.Analyser;
import com.android.tools.idea.editors.navigation.macros.FragmentEntry;
import com.android.tools.idea.editors.navigation.model.ActivityState;
import com.android.tools.idea.editors.navigation.model.Locator;
import com.android.tools.idea.editors.navigation.model.MenuState;
import com.android.tools.idea.editors.navigation.model.ModelDimension;
import com.android.tools.idea.editors.navigation.model.ModelPoint;
import com.android.tools.idea.editors.navigation.model.NavigationModel;
import com.android.tools.idea.editors.navigation.model.State;
import com.android.tools.idea.editors.navigation.model.Transition;
import com.android.tools.idea.rendering.RenderedView;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Selections {
    private static final Color SELECTION_COLOR = JBColor.BLUE;
    private static final int SELECTION_RECTANGLE_LINE_WIDTH = 2;
    public static final Event STATE_LOCATIONS_UPDATED = Event.update(Map.class);
    public static final boolean MOVE_MENUS_WITH_ACTIVITIES = true;
    public static final boolean SNAP_ON_MOUSE_UP = false;
    public static Selection NULL = new EmptySelection();

    Selections() {
    }

    private static void configureHyperLinkLabelForClassName(final RenderingParameters renderingParameters, HyperlinkLabel link, final @Nullable String className) {
        link.setOpaque(false);
        if (className == null) {
            return;
        }
        link.setHyperlinkText(className.substring(1 + className.lastIndexOf(46)));
        link.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                PsiClass psiClass = Utilities.getPsiClass(renderingParameters.configuration.getModule(), className);
                if (psiClass != null) {
                    AndroidRootComponent.launchEditor(renderingParameters, psiClass.getContainingFile(), false);
                }
            }
        });
    }

    private static void configureHyperlinkForXMLFile(final RenderingParameters renderingParameters, HyperlinkLabel link, @Nullable String linkText, final @Nullable String xmlFileName, final boolean isMenu) {
        link.setOpaque(false);
        link.setHyperlinkText(linkText == null ? "" : linkText);
        link.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                PsiFile layoutXmlFile = NavigationView.getLayoutXmlFile(isMenu, xmlFileName, renderingParameters.configuration, renderingParameters.project);
                AndroidRootComponent.launchEditor(renderingParameters, layoutXmlFile, false);
            }
        });
    }

    private static void configureHyperlinkForXMLFile(RenderingParameters renderingParameters, HyperlinkLabel link, @Nullable String xmlFileName, boolean isMenu) {
        Selections.configureHyperlinkForXMLFile(renderingParameters, link, xmlFileName, xmlFileName, isMenu);
    }

    static class ViewSelection
    extends Selection {
        private final AndroidRootComponent mySourceComponent;
        private final NavigationView myNavigationView;
        private final RenderedView myNamedLeaf;
        @NotNull
        private Point myMouseLocation;

        ViewSelection(@NotNull AndroidRootComponent sourceComponent, @NotNull Point mouseDownLocation, @Nullable RenderedView namedLeaf, @NotNull NavigationView navigationView) {
            if (sourceComponent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceComponent", "com/android/tools/idea/editors/navigation/Selections$ViewSelection", "<init>"));
            }
            if (mouseDownLocation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseDownLocation", "com/android/tools/idea/editors/navigation/Selections$ViewSelection", "<init>"));
            }
            if (navigationView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationView", "com/android/tools/idea/editors/navigation/Selections$ViewSelection", "<init>"));
            }
            this.mySourceComponent = sourceComponent;
            this.myMouseLocation = mouseDownLocation;
            this.myNamedLeaf = namedLeaf;
            this.myNavigationView = navigationView;
        }

        @Override
        protected void moveTo(Point location) {
            this.myMouseLocation = location;
        }

        @Override
        protected void paint(Graphics g, boolean hasFocus) {
        }

        @Override
        protected void paintOver(Graphics g) {
            int lineWidth = this.mySourceComponent.transform.modelToViewW(12);
            Graphics2D lineGraphics = Utilities.createLineGraphics(g, lineWidth);
            Rectangle sourceBounds = NavigationView.getBounds(this.mySourceComponent, this.myNamedLeaf);
            Rectangle destBounds = this.myNavigationView.getNamedLeafBoundsAt(this.mySourceComponent, this.myMouseLocation, false);
            Utilities.Line midLine = Utilities.getMidLine(sourceBounds, new Rectangle(this.myMouseLocation));
            Point[] controlPoints = NavigationView.getControlPoints(sourceBounds, destBounds, midLine);
            this.myNavigationView.drawTransition(lineGraphics, sourceBounds, destBounds, controlPoints);
        }

        @Override
        protected Selection finaliseSelectionLocation(Point mouseUpLocation) {
            this.myNavigationView.createTransition(this.mySourceComponent, this.myNamedLeaf, mouseUpLocation);
            return NULL;
        }

        @Override
        protected void remove() {
        }
    }

    static class AndroidRootComponentSelection
    extends ComponentSelection<AndroidRootComponent> {
        protected final Point myMouseDownLocation;
        protected final Point myOrigComponentLocation;
        @NotNull
        private final State myState;
        private final Transform myTransform;

        AndroidRootComponentSelection(NavigationModel navigationModel, AndroidRootComponent component, Transition transition, RenderingParameters renderingParameters, Point mouseDownLocation, @NotNull State state, Transform transform) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/navigation/Selections$AndroidRootComponentSelection", "<init>"));
            }
            super(renderingParameters, navigationModel, component, transition);
            this.myMouseDownLocation = mouseDownLocation;
            this.myOrigComponentLocation = ((AndroidRootComponent)this.myComponent).getLocation();
            this.myState = state;
            this.myTransform = transform;
        }

        private void moveTo(Point location, boolean snap) {
            MenuState menuState;
            Point newLocation = Utilities.sum(Utilities.diff(location, this.myMouseDownLocation), this.myOrigComponentLocation);
            if (snap) {
                newLocation = Utilities.snap(newLocation, this.myTransform.modelToView(ModelDimension.create(NavigationView.MIDDLE_SNAP_GRID)));
            }
            Map<State, ModelPoint> stateToLocation = this.myNavigationModel.getStateToLocation();
            Point oldLocation = this.myTransform.modelToView(stateToLocation.get(this.myState));
            stateToLocation.put(this.myState, this.myTransform.viewToModel(newLocation));
            if (this.myState instanceof ActivityState && (menuState = this.myNavigationModel.findAssociatedMenuState((ActivityState)this.myState)) != null) {
                Point delta = Utilities.diff(newLocation, oldLocation);
                stateToLocation.put(menuState, this.myTransform.viewToModel(Utilities.sum(delta, this.myTransform.modelToView(stateToLocation.get(menuState)))));
            }
            this.myNavigationModel.getListeners().notify(STATE_LOCATIONS_UPDATED);
        }

        @Override
        protected void moveTo(Point location) {
            this.moveTo(location, false);
        }

        @Override
        protected Selection finaliseSelectionLocation(Point location) {
            this.moveTo(location, false);
            return this;
        }

        @Override
        protected void configureInspector(final Inspector inspector) {
            this.myState.accept(new State.Visitor(){

                @Override
                public void visit(ActivityState activity) {
                    Module module = AndroidRootComponentSelection.this.myRenderingParameters.configuration.getModule();
                    ActivityInspector activityInspector = new ActivityInspector();
                    HyperlinkLabel link = activityInspector.classNameLabel;
                    String className = activity.getClassName();
                    Selections.configureHyperLinkLabelForClassName(AndroidRootComponentSelection.this.myRenderingParameters, link, className);
                    link = activityInspector.xmlFileNameLabel;
                    String xmlFileName = Analyser.getXMLFileName(module, activity.getClassName(), true);
                    Selections.configureHyperlinkForXMLFile(AndroidRootComponentSelection.this.myRenderingParameters, link, xmlFileName, false);
                    JPanel fragmentList = activityInspector.fragmentList;
                    fragmentList.removeAll();
                    fragmentList.setLayout(new BoxLayout(fragmentList, 1));
                    for (FragmentEntry entry : activity.getFragments()) {
                        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel();
                        Selections.configureHyperLinkLabelForClassName(AndroidRootComponentSelection.this.myRenderingParameters, hyperlinkLabel, entry.className);
                        fragmentList.add((Component)hyperlinkLabel);
                    }
                    inspector.setInspectorComponent(activityInspector.container);
                }

                @Override
                public void visit(MenuState menu) {
                    MenuInspector menuInspector = new MenuInspector();
                    Selections.configureHyperLinkLabelForClassName(AndroidRootComponentSelection.this.myRenderingParameters, menuInspector.classNameLabel, menu.getClassName());
                    Selections.configureHyperlinkForXMLFile(AndroidRootComponentSelection.this.myRenderingParameters, menuInspector.xmlFileNameLabel, menu.getXmlResourceName(), true);
                    inspector.setInspectorComponent(menuInspector.container);
                }
            });
        }
    }

    static class ComponentSelection<T extends Component>
    extends Selection {
        protected final RenderingParameters myRenderingParameters;
        protected final T myComponent;
        protected final Transition myTransition;
        protected final NavigationModel myNavigationModel;

        ComponentSelection(RenderingParameters renderingParameters, NavigationModel navigationModel, T component, Transition transition) {
            this.myRenderingParameters = renderingParameters;
            this.myNavigationModel = navigationModel;
            this.myComponent = component;
            this.myTransition = transition;
        }

        @Override
        protected void moveTo(Point location) {
        }

        @Override
        protected void paint(Graphics g, boolean hasFocus) {
            if (hasFocus) {
                Graphics2D g2D = (Graphics2D)g.create();
                g2D.setStroke(new BasicStroke(2.0f));
                g2D.setColor(SELECTION_COLOR);
                Rectangle selection = ((Component)this.myComponent).getBounds();
                int l = 1;
                selection.grow(l, l);
                g2D.drawRect(selection.x, selection.y, selection.width, selection.height);
            }
        }

        @Override
        protected void paintOver(Graphics g) {
        }

        @Override
        protected Selection finaliseSelectionLocation(Point location) {
            return this;
        }

        @Override
        protected void remove() {
        }

        @Override
        protected void configureInspector(Inspector inspector) {
            final Module module = this.myRenderingParameters.configuration.getModule();
            final TransitionInspector transitionInspector = new TransitionInspector();
            final Locator source = this.myTransition.getSource();
            State sourceState = source.getState();
            final boolean isFragment = source.getFragmentClassName() != null;
            final String hostClassName = isFragment ? source.getFragmentClassName() : sourceState.getClassName();
            Selections.configureHyperLinkLabelForClassName(this.myRenderingParameters, transitionInspector.source, hostClassName);
            sourceState.accept(new State.Visitor(){

                @Override
                public void visit(ActivityState state) {
                    String xmlFileName = Analyser.getXMLFileName(module, hostClassName, !isFragment);
                    Selections.configureHyperlinkForXMLFile(ComponentSelection.this.myRenderingParameters, transitionInspector.sourceViewId, source.getViewId(), xmlFileName, false);
                }

                @Override
                public void visit(MenuState state) {
                    String xmlFileName = state.getXmlResourceName();
                    Selections.configureHyperlinkForXMLFile(ComponentSelection.this.myRenderingParameters, transitionInspector.sourceViewId, source.getViewId(), xmlFileName, true);
                }
            });
            JComboBox comboBox = transitionInspector.gesture;
            comboBox.addItem("Press");
            comboBox.setSelectedItem(this.myTransition.getType());
            comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ComponentSelection.this.myTransition.setType((String)itemEvent.getItem());
                    ComponentSelection.this.myNavigationModel.getListeners().notify(Event.update(Transition.class));
                }
            });
            Selections.configureHyperLinkLabelForClassName(this.myRenderingParameters, transitionInspector.destination, this.myTransition.getDestination().getState().getClassName());
            inspector.setInspectorComponent(transitionInspector.container);
        }
    }

    private static class EmptySelection
    extends Selection {
        private EmptySelection() {
        }

        @Override
        protected void moveTo(Point location) {
        }

        @Override
        protected void paint(Graphics g, boolean hasFocus) {
        }

        @Override
        protected void paintOver(Graphics g) {
        }

        @Override
        protected Selection finaliseSelectionLocation(Point location) {
            return this;
        }

        @Override
        protected void remove() {
        }
    }

    static abstract class Selection {
        Selection() {
        }

        protected abstract void moveTo(Point var1);

        protected abstract Selection finaliseSelectionLocation(Point var1);

        protected abstract void paint(Graphics var1, boolean var2);

        protected abstract void paintOver(Graphics var1);

        protected abstract void remove();

        protected void configureInspector(Inspector inspector) {
        }
    }
}

