/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.SdkConstants;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.CommonBundle;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.android.actions.AndroidEnableAdbServiceAction;
import org.jetbrains.android.actions.AndroidRunDdmsAction;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.logcat.AdbErrors;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdkUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.sdk.AndroidSdkUtils");
    public static final String DEFAULT_PLATFORM_NAME_PROPERTY = "AndroidPlatformName";
    public static final String SDK_NAME_PREFIX = "Android ";
    public static final String DEFAULT_JDK_NAME = "JDK";
    private static final String MAC_SDK_URL = "https://dl.google.com/android/android-sdk_r22.6.2-macosx.zip";
    private static final String LINUX_SDK_URL = "https://dl.google.com/android/android-sdk_r22.6.2-linux.tgz";
    private static final String WINDOWS_SDK_URL = "https://dl.google.com/android/android-sdk_r22.6.2-windows.zip";
    private static AndroidSdkData ourSdkData;

    private AndroidSdkUtils() {
    }

    @Nullable
    private static VirtualFile getPlatformDir(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "getPlatformDir"));
        }
        String platformPath = target.isPlatform() ? target.getLocation() : target.getParent().getLocation();
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)platformPath));
    }

    @NotNull
    public static List<VirtualFile> getPlatformAndAddOnJars(@NotNull IAndroidTarget target) {
        IAndroidTarget.IOptionalLibrary[] libs;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "getPlatformAndAddOnJars"));
        }
        VirtualFile platformDir = AndroidSdkUtils.getPlatformDir(target);
        if (platformDir == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "getPlatformAndAddOnJars"));
            }
            return list;
        }
        VirtualFile androidJar = platformDir.findChild("android.jar");
        if (androidJar == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "getPlatformAndAddOnJars"));
            }
            return list;
        }
        ArrayList result = Lists.newArrayList();
        VirtualFile androidJarRoot = JarFileSystem.getInstance().findFileByPath(androidJar.getPath() + "!/");
        if (androidJarRoot != null) {
            result.add(androidJarRoot);
        }
        if ((libs = target.getOptionalLibraries()) != null) {
            for (IAndroidTarget.IOptionalLibrary lib : libs) {
                VirtualFile libRoot = JarFileSystem.getInstance().findFileByPath(lib.getJarPath() + "!/");
                if (libRoot == null) continue;
                result.add(libRoot);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "getPlatformAndAddOnJars"));
        }
        return arrayList;
    }

    @NotNull
    public static List<OrderRoot> getLibraryRootsForTarget(@NotNull IAndroidTarget target, @Nullable String sdkPath, boolean addPlatformAndAddOnJars) {
        String annotationsJarPath;
        JarFileSystem jarFileSystem;
        VirtualFile annotationsJar;
        VirtualFile resFolder;
        String resFolderPath;
        VirtualFile f;
        VirtualFile platformSourcesDir;
        VirtualFile platformDir;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "getLibraryRootsForTarget"));
        }
        ArrayList result = Lists.newArrayList();
        if (addPlatformAndAddOnJars) {
            for (VirtualFile file : AndroidSdkUtils.getPlatformAndAddOnJars(target)) {
                result.add(new OrderRoot(file, OrderRootType.CLASSES));
            }
        }
        if ((platformDir = AndroidSdkUtils.getPlatformDir(target)) == null) {
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "getLibraryRootsForTarget"));
            }
            return arrayList;
        }
        VirtualFile targetDir = platformDir;
        if (!target.isPlatform()) {
            targetDir = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)target.getLocation()));
        }
        boolean docsOrSourcesFound = false;
        if (targetDir != null) {
            docsOrSourcesFound = AndroidSdkUtils.addJavaDocAndSources(result, targetDir);
        }
        VirtualFile sdkDir = sdkPath != null ? LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)sdkPath)) : null;
        VirtualFile sourcesDir = null;
        if (sdkDir != null) {
            docsOrSourcesFound = AndroidSdkUtils.addJavaDocAndSources(result, sdkDir) || docsOrSourcesFound;
            sourcesDir = sdkDir.findChild("sources");
        }
        if (sourcesDir != null && sourcesDir.isDirectory() && (platformSourcesDir = sourcesDir.findChild(platformDir.getName())) != null && platformSourcesDir.isDirectory()) {
            result.add(new OrderRoot(platformSourcesDir, OrderRootType.SOURCES));
            docsOrSourcesFound = true;
        }
        if (!docsOrSourcesFound && (f = VirtualFileManager.getInstance().findFileByUrl("http://developer.android.com/reference/")) != null) {
            result.add(new OrderRoot(f, JavadocOrderRootType.getInstance()));
        }
        if ((resFolderPath = target.getPath(11)) != null && (resFolder = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)resFolderPath))) != null) {
            result.add(new OrderRoot(resFolder, OrderRootType.CLASSES));
        }
        if (sdkPath != null && AndroidSdkUtils.needsAnnotationsJarInClasspath(target) && (annotationsJar = (jarFileSystem = JarFileSystem.getInstance()).findFileByPath(annotationsJarPath = FileUtil.toSystemIndependentName((String)sdkPath) + "/tools/support/annotations.jar" + "!/")) != null) {
            result.add(new OrderRoot(annotationsJar, OrderRootType.CLASSES));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "getLibraryRootsForTarget"));
        }
        return arrayList;
    }

    public static boolean needsAnnotationsJarInClasspath(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "needsAnnotationsJarInClasspath"));
        }
        return target.getVersion().getApiLevel() <= 15;
    }

    @Nullable
    private static VirtualFile findJavadocDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/android/sdk/AndroidSdkUtils", "findJavadocDir"));
        }
        VirtualFile docsDir = dir.findChild("docs");
        if (docsDir != null) {
            return docsDir.findChild("reference");
        }
        return null;
    }

    private static boolean addJavaDocAndSources(@NotNull List<OrderRoot> list, @NotNull VirtualFile dir) {
        VirtualFile sourcesDir;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/android/sdk/AndroidSdkUtils", "addJavaDocAndSources"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/android/sdk/AndroidSdkUtils", "addJavaDocAndSources"));
        }
        boolean found = false;
        VirtualFile javadocDir = AndroidSdkUtils.findJavadocDir(dir);
        if (javadocDir != null) {
            list.add(new OrderRoot(javadocDir, JavadocOrderRootType.getInstance()));
            found = true;
        }
        if ((sourcesDir = dir.findChild("src")) != null) {
            list.add(new OrderRoot(sourcesDir, OrderRootType.SOURCES));
            found = true;
        }
        return found;
    }

    public static String getPresentableTargetName(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "getPresentableTargetName"));
        }
        IAndroidTarget parentTarget = target.getParent();
        if (parentTarget != null) {
            return target.getName() + " (" + parentTarget.getVersionName() + ')';
        }
        return target.getName();
    }

    @Nullable
    public static Sdk createNewAndroidPlatform(@Nullable String sdkPath, boolean promptUser) {
        Sdk sdk;
        IAndroidTarget target;
        Sdk jdk = Jdks.chooseOrCreateJavaSdk();
        if (sdkPath != null && jdk != null && (target = AndroidSdkUtils.findBestTarget(sdkPath = FileUtil.toSystemIndependentName((String)sdkPath))) != null && (sdk = AndroidSdkUtils.createNewAndroidPlatform(target, sdkPath, AndroidSdkUtils.chooseNameForNewLibrary(target), jdk, true)) != null) {
            return sdk;
        }
        String jdkPath = jdk == null ? null : jdk.getHomePath();
        return promptUser ? AndroidSdkUtils.promptUserForSdkCreation(null, sdkPath, jdkPath) : null;
    }

    @Nullable
    private static IAndroidTarget findBestTarget(@NotNull String sdkPath) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "org/jetbrains/android/sdk/AndroidSdkUtils", "findBestTarget"));
        }
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdkPath);
        if (sdkData != null) {
            IAndroidTarget[] targets = sdkData.getTargets();
            if (targets.length == 1) {
                return targets[0];
            }
            return AndroidSdkUtils.findBestTarget(targets);
        }
        return null;
    }

    @Nullable
    private static IAndroidTarget findBestTarget(@NotNull IAndroidTarget[] targets) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "org/jetbrains/android/sdk/AndroidSdkUtils", "findBestTarget"));
        }
        IAndroidTarget bestTarget = null;
        int maxApiLevel = -1;
        for (IAndroidTarget target : targets) {
            AndroidVersion version = target.getVersion();
            if (!target.isPlatform() || version.isPreview() || version.getApiLevel() <= maxApiLevel) continue;
            bestTarget = target;
            maxApiLevel = version.getApiLevel();
        }
        return bestTarget;
    }

    @Nullable
    public static Sdk createNewAndroidPlatform(@NotNull IAndroidTarget target, @NotNull String sdkPath, boolean addRoots) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "createNewAndroidPlatform"));
        }
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "org/jetbrains/android/sdk/AndroidSdkUtils", "createNewAndroidPlatform"));
        }
        return AndroidSdkUtils.createNewAndroidPlatform(target, sdkPath, AndroidSdkUtils.chooseNameForNewLibrary(target), addRoots);
    }

    @Nullable
    public static Sdk createNewAndroidPlatform(@NotNull IAndroidTarget target, @NotNull String sdkPath, @NotNull String sdkName, boolean addRoots) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "createNewAndroidPlatform"));
        }
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "org/jetbrains/android/sdk/AndroidSdkUtils", "createNewAndroidPlatform"));
        }
        if (sdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkName", "org/jetbrains/android/sdk/AndroidSdkUtils", "createNewAndroidPlatform"));
        }
        Sdk jdk = Jdks.chooseOrCreateJavaSdk();
        if (jdk == null) {
            return null;
        }
        return AndroidSdkUtils.createNewAndroidPlatform(target, sdkPath, sdkName, jdk, addRoots);
    }

    @Nullable
    public static Sdk createNewAndroidPlatform(@NotNull IAndroidTarget target, @NotNull String sdkPath, @NotNull String sdkName, @Nullable Sdk jdk, boolean addRoots) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "createNewAndroidPlatform"));
        }
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "org/jetbrains/android/sdk/AndroidSdkUtils", "createNewAndroidPlatform"));
        }
        if (sdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkName", "org/jetbrains/android/sdk/AndroidSdkUtils", "createNewAndroidPlatform"));
        }
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        String tmpName = SdkConfigurationUtil.createUniqueSdkName((String)"Android SDK", Arrays.asList(table.getAllJdks()));
        final Sdk sdk = table.createSdk(tmpName, (SdkTypeId)AndroidSdkType.getInstance());
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.setHomePath(sdkPath);
        sdkModificator.commitChanges();
        AndroidSdkUtils.setUpSdk(sdk, sdkName, table.getAllJdks(), target, jdk, addRoots);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectJdkTable.getInstance().addJdk(sdk);
            }
        });
        return sdk;
    }

    @NotNull
    public static String chooseNameForNewLibrary(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "chooseNameForNewLibrary"));
        }
        if (target.isPlatform()) {
            String string = SDK_NAME_PREFIX + target.getVersion().toString() + " Platform";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "chooseNameForNewLibrary"));
            }
            return string;
        }
        IAndroidTarget parentTarget = target.getParent();
        if (parentTarget != null) {
            String string = SDK_NAME_PREFIX + parentTarget.getVersionName() + ' ' + target.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "chooseNameForNewLibrary"));
            }
            return string;
        }
        String string = SDK_NAME_PREFIX + target.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "chooseNameForNewLibrary"));
        }
        return string;
    }

    public static String getTargetPresentableName(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "getTargetPresentableName"));
        }
        return target.isPlatform() ? target.getName() : target.getName() + " (" + target.getVersionName() + ')';
    }

    public static void setUpSdk(@NotNull Sdk androidSdk, @NotNull String sdkName, @NotNull Sdk[] allSdks, @NotNull IAndroidTarget target, @Nullable Sdk jdk, boolean addRoots) {
        if (androidSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdk", "org/jetbrains/android/sdk/AndroidSdkUtils", "setUpSdk"));
        }
        if (sdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkName", "org/jetbrains/android/sdk/AndroidSdkUtils", "setUpSdk"));
        }
        if (allSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allSdks", "org/jetbrains/android/sdk/AndroidSdkUtils", "setUpSdk"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "setUpSdk"));
        }
        AndroidSdkAdditionalData data = new AndroidSdkAdditionalData(androidSdk, jdk);
        data.setBuildTarget(target);
        String name = SdkConfigurationUtil.createUniqueSdkName((String)sdkName, Arrays.asList(allSdks));
        SdkModificator sdkModificator = androidSdk.getSdkModificator();
        AndroidSdkUtils.findAndSetPlatformSources(target, sdkModificator);
        sdkModificator.setName(name);
        if (jdk != null) {
            sdkModificator.setVersionString(jdk.getVersionString());
        }
        sdkModificator.setSdkAdditionalData((SdkAdditionalData)data);
        if (addRoots) {
            sdkModificator.removeAllRoots();
            for (OrderRoot orderRoot : AndroidSdkUtils.getLibraryRootsForTarget(target, androidSdk.getHomePath(), true)) {
                sdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
            }
            ExternalAnnotationsSupport.attachJdkAnnotations(sdkModificator);
        }
        sdkModificator.commitChanges();
    }

    public static void findAndSetPlatformSources(@NotNull IAndroidTarget target, @NotNull SdkModificator sdkModificator) {
        VirtualFile virtualFile;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "findAndSetPlatformSources"));
        }
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "org/jetbrains/android/sdk/AndroidSdkUtils", "findAndSetPlatformSources"));
        }
        File sources = AndroidSdkUtils.findPlatformSources(target);
        if (sources != null && (virtualFile = VfsUtil.findFileByIoFile((File)sources, (boolean)true)) != null) {
            sdkModificator.addRoot(virtualFile, OrderRootType.SOURCES);
        }
    }

    public static boolean targetHasId(@NotNull IAndroidTarget target, @NotNull String id) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "targetHasId"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/android/sdk/AndroidSdkUtils", "targetHasId"));
        }
        return id.equals(target.getVersion().getApiString()) || id.equals(target.getVersionName());
    }

    @NotNull
    public static Collection<String> getAndroidSdkPathsFromExistingPlatforms() {
        List<Sdk> androidSdks = AndroidSdkUtils.getAllAndroidSdks();
        ArrayList result = Lists.newArrayList();
        for (Sdk androidSdk : androidSdks) {
            String sdkPath;
            AndroidPlatform androidPlatform;
            AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)androidSdk.getSdkAdditionalData();
            if (data == null || (androidPlatform = data.getAndroidPlatform()) == null || result.contains(sdkPath = FileUtil.toSystemIndependentName((String)androidPlatform.getSdkData().getLocation().getPath()))) continue;
            if (androidSdk.getName().startsWith(SDK_NAME_PREFIX)) {
                result.add(0, sdkPath);
                continue;
            }
            result.add(sdkPath);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "getAndroidSdkPathsFromExistingPlatforms"));
        }
        return arrayList;
    }

    @NotNull
    public static List<Sdk> getAllAndroidSdks() {
        List allSdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)AndroidSdkType.getInstance());
        List list = (List)ObjectUtils.notNull((Object)allSdks, Collections.emptyList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "getAllAndroidSdks"));
        }
        return list;
    }

    private static boolean tryToSetAndroidPlatform(Module module, Sdk sdk) {
        AndroidPlatform platform = AndroidPlatform.parse(sdk);
        if (platform != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)sdk);
            return true;
        }
        return false;
    }

    private static void setupPlatform(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/sdk/AndroidSdkUtils", "setupPlatform"));
        }
        String targetHashString = AndroidSdkUtils.getTargetHashStringFromPropertyFile(module);
        if (targetHashString != null && AndroidSdkUtils.findAndSetSdkWithHashString(module, targetHashString)) {
            return;
        }
        PropertiesComponent component = PropertiesComponent.getInstance();
        if (component.isValueSet(DEFAULT_PLATFORM_NAME_PROPERTY)) {
            String defaultPlatformName = component.getValue(DEFAULT_PLATFORM_NAME_PROPERTY);
            Sdk defaultLib = ProjectJdkTable.getInstance().findJdk(defaultPlatformName, AndroidSdkType.getInstance().getName());
            if (defaultLib != null && AndroidSdkUtils.tryToSetAndroidPlatform(module, defaultLib)) {
                return;
            }
        }
        for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
            AndroidPlatform platform;
            AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData();
            if (data == null || (platform = data.getAndroidPlatform()) == null || !AndroidSdkUtils.checkSdkRoots(sdk, platform.getTarget(), false) || !AndroidSdkUtils.tryToSetAndroidPlatform(module, sdk)) continue;
            component.setValue(DEFAULT_PLATFORM_NAME_PROPERTY, sdk.getName());
            return;
        }
    }

    @Nullable
    public static Sdk findSuitableAndroidSdk(@NotNull String targetHash) {
        if (targetHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetHash", "org/jetbrains/android/sdk/AndroidSdkUtils", "findSuitableAndroidSdk"));
        }
        HashSet foundSdkHomePaths = Sets.newHashSet();
        ArrayList notCompatibleSdks = Lists.newArrayList();
        for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
            SdkAdditionalData originalData = sdk.getSdkAdditionalData();
            if (!(originalData instanceof AndroidSdkAdditionalData)) continue;
            AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)originalData;
            String sdkHomePath = sdk.getHomePath();
            if (foundSdkHomePaths.contains(sdkHomePath) || !targetHash.equals(data.getBuildTargetHashString())) continue;
            if (VersionCheck.isCompatibleVersion(sdkHomePath)) {
                return sdk;
            }
            notCompatibleSdks.add(sdk);
            if (sdkHomePath == null) continue;
            foundSdkHomePaths.add(sdkHomePath);
        }
        if (!notCompatibleSdks.isEmpty()) {
            return (Sdk)notCompatibleSdks.get(0);
        }
        return null;
    }

    @Nullable
    private static String getTargetHashStringFromPropertyFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/sdk/AndroidSdkUtils", "getTargetHashStringFromPropertyFile"));
        }
        Pair<String, VirtualFile> targetProp = AndroidRootUtil.getProjectPropertyValue(module, "target");
        return targetProp != null ? (String)targetProp.getFirst() : null;
    }

    private static boolean findAndSetSdkWithHashString(@NotNull Module module, @NotNull String targetHashString) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/sdk/AndroidSdkUtils", "findAndSetSdkWithHashString"));
        }
        if (targetHashString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetHashString", "org/jetbrains/android/sdk/AndroidSdkUtils", "findAndSetSdkWithHashString"));
        }
        Pair<String, VirtualFile> sdkDirProperty = AndroidRootUtil.getPropertyValue(module, "local.properties", "sdk.dir");
        String sdkDir = sdkDirProperty != null ? (String)sdkDirProperty.getFirst() : null;
        return AndroidSdkUtils.findAndSetSdk(module, targetHashString, sdkDir);
    }

    public static boolean findAndSetSdk(@NotNull Module module, @NotNull String targetHashString, @Nullable String sdkPath) {
        Sdk sdk;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/sdk/AndroidSdkUtils", "findAndSetSdk"));
        }
        if (targetHashString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetHashString", "org/jetbrains/android/sdk/AndroidSdkUtils", "findAndSetSdk"));
        }
        if (sdkPath != null) {
            sdkPath = FileUtil.toSystemIndependentName((String)sdkPath);
        }
        if ((sdk = AndroidSdkUtils.findSuitableAndroidSdk(targetHashString)) != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)sdk);
            return true;
        }
        if (sdkPath != null && AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module, sdkPath, targetHashString)) {
            return true;
        }
        String androidHomeValue = System.getenv("ANDROID_HOME");
        if (androidHomeValue != null && AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module, FileUtil.toSystemIndependentName((String)androidHomeValue), targetHashString)) {
            return true;
        }
        for (String dir : AndroidSdkUtils.getAndroidSdkPathsFromExistingPlatforms()) {
            if (!AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module, dir, targetHashString)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static boolean tryToCreateAndSetAndroidSdk(@NotNull Module module, @NotNull String sdkPath, @NotNull String targetHashString) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/sdk/AndroidSdkUtils", "tryToCreateAndSetAndroidSdk"));
        }
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "org/jetbrains/android/sdk/AndroidSdkUtils", "tryToCreateAndSetAndroidSdk"));
        }
        if (targetHashString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetHashString", "org/jetbrains/android/sdk/AndroidSdkUtils", "tryToCreateAndSetAndroidSdk"));
        }
        File path = new File(FileUtil.toSystemDependentName((String)sdkPath));
        Sdk sdk = AndroidSdkUtils.tryToCreateAndroidSdk(path, targetHashString);
        if (sdk != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)sdk);
            return true;
        }
        return false;
    }

    @Nullable
    public static Sdk tryToCreateAndroidSdk(@NotNull File sdkPath, @NotNull String targetHashString) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "org/jetbrains/android/sdk/AndroidSdkUtils", "tryToCreateAndroidSdk"));
        }
        if (targetHashString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetHashString", "org/jetbrains/android/sdk/AndroidSdkUtils", "tryToCreateAndroidSdk"));
        }
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdkPath);
        if (sdkData != null) {
            sdkData.getLocalSdk().clearLocalPkg(PkgType.PKG_ALL);
            IAndroidTarget target = sdkData.findTargetByHashString(targetHashString);
            if (target != null) {
                return AndroidSdkUtils.createNewAndroidPlatform(target, sdkData.getLocation().getPath(), true);
            }
        }
        return null;
    }

    @Nullable
    private static Sdk promptUserForSdkCreation(final @Nullable IAndroidTarget target, final @Nullable String androidSdkPath, final @Nullable String jdkPath) {
        final Ref sdkRef = new Ref();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                SelectSdkDialog dlg = new SelectSdkDialog(jdkPath, androidSdkPath);
                dlg.setModal(true);
                if (dlg.showAndGet()) {
                    Sdk sdk = AndroidSdkUtils.createNewAndroidPlatform(target, dlg.getAndroidHome(), dlg.getJdkHome());
                    sdkRef.set((Object)sdk);
                    if (sdk != null) {
                        RunAndroidSdkManagerAction.updateInWelcomePage(dlg.getContentPanel());
                    }
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            task.run();
            return (Sdk)sdkRef.get();
        }
        application.invokeAndWait(task, ModalityState.any());
        return (Sdk)sdkRef.get();
    }

    @Nullable
    private static Sdk createNewAndroidPlatform(@Nullable IAndroidTarget target, @NotNull String androidSdkPath, @NotNull String jdkPath) {
        Sdk jdk;
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdkPath", "org/jetbrains/android/sdk/AndroidSdkUtils", "createNewAndroidPlatform"));
        }
        if (jdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkPath", "org/jetbrains/android/sdk/AndroidSdkUtils", "createNewAndroidPlatform"));
        }
        if (!Strings.isNullOrEmpty((String)jdkPath) && (jdk = Jdks.createJdk(jdkPath = FileUtil.toSystemIndependentName((String)jdkPath))) != null) {
            androidSdkPath = FileUtil.toSystemIndependentName((String)androidSdkPath);
            if (target == null) {
                target = AndroidSdkUtils.findBestTarget(androidSdkPath);
            }
            if (target != null) {
                return AndroidSdkUtils.createNewAndroidPlatform(target, androidSdkPath, AndroidSdkUtils.chooseNameForNewLibrary(target), jdk, true);
            }
        }
        return null;
    }

    public static void setupAndroidPlatformIfNecessary(@NotNull Module module, boolean forceImportFromProperties) {
        AndroidPlatform platform;
        SdkAdditionalData data;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/sdk/AndroidSdkUtils", "setupAndroidPlatformIfNecessary"));
        }
        Sdk currentSdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (currentSdk == null || !AndroidSdkUtils.isAndroidSdk(currentSdk)) {
            AndroidSdkUtils.setupPlatform(module);
            return;
        }
        if (forceImportFromProperties && (data = currentSdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData && (platform = ((AndroidSdkAdditionalData)data).getAndroidPlatform()) != null) {
            String targetHashString = AndroidSdkUtils.getTargetHashStringFromPropertyFile(module);
            String currentTargetHashString = platform.getTarget().hashString();
            if (targetHashString != null && !targetHashString.equals(currentTargetHashString)) {
                AndroidSdkUtils.findAndSetSdkWithHashString(module, targetHashString);
            }
        }
    }

    public static void openModuleDependenciesConfigurable(Module module) {
        ProjectSettingsService.getInstance((Project)module.getProject()).openModuleDependenciesSettings(module, null);
    }

    @Nullable
    public static Sdk findAppropriateAndroidPlatform(@NotNull IAndroidTarget target, @NotNull AndroidSdkData sdkData, boolean forMaven) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "findAppropriateAndroidPlatform"));
        }
        if (sdkData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkData", "org/jetbrains/android/sdk/AndroidSdkUtils", "findAppropriateAndroidPlatform"));
        }
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            IAndroidTarget currentTarget;
            AndroidSdkAdditionalData data;
            AndroidSdkData currentSdkData;
            String homePath = sdk.getHomePath();
            if (homePath == null || !AndroidSdkUtils.isAndroidSdk(sdk) || (currentSdkData = AndroidSdkData.getSdkData(homePath)) == null || !currentSdkData.equals(sdkData) || (data = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData()) == null || (currentTarget = data.getBuildTarget(currentSdkData)) == null || !target.hashString().equals(currentTarget.hashString()) || !AndroidSdkUtils.checkSdkRoots(sdk, target, forMaven)) continue;
            return sdk;
        }
        return null;
    }

    public static boolean isAndroidSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/sdk/AndroidSdkUtils", "isAndroidSdk"));
        }
        return sdk.getSdkType() == AndroidSdkType.getInstance();
    }

    public static boolean checkSdkRoots(@NotNull Sdk sdk, @NotNull IAndroidTarget target, boolean forMaven) {
        Sdk javaSdk;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/sdk/AndroidSdkUtils", "checkSdkRoots"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "checkSdkRoots"));
        }
        String homePath = sdk.getHomePath();
        if (homePath == null) {
            return false;
        }
        AndroidSdkAdditionalData sdkAdditionalData = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData();
        Sdk sdk2 = javaSdk = sdkAdditionalData != null ? sdkAdditionalData.getJavaSdk() : null;
        if (javaSdk == null) {
            return false;
        }
        HashSet filesInSdk = Sets.newHashSet((Object[])sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
        List<VirtualFile> platformAndAddOnJars = AndroidSdkUtils.getPlatformAndAddOnJars(target);
        for (VirtualFile file : platformAndAddOnJars) {
            if (filesInSdk.contains(file) != forMaven) continue;
            return false;
        }
        boolean containsJarFromJdk = false;
        for (VirtualFile file : javaSdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            if (!(file.getFileType() instanceof ArchiveFileType) || !filesInSdk.contains(file)) continue;
            containsJarFromJdk = true;
        }
        return containsJarFromJdk == forMaven;
    }

    @Nullable
    public static File getAdb(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/sdk/AndroidSdkUtils", "getAdb"));
        }
        AndroidSdkData data = AndroidSdkUtils.getProjectSdkData(project);
        if (data == null) {
            data = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
        }
        File adb = data == null ? null : new File(data.getLocation(), AndroidCommonUtils.platformToolPath((String)SdkConstants.FN_ADB));
        return adb != null && adb.exists() ? adb : null;
    }

    @Nullable
    private static AndroidSdkData getFirstAndroidModuleSdkData(Project project) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        for (AndroidFacet facet : facets) {
            AndroidPlatform androidPlatform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
            if (androidPlatform == null) continue;
            return androidPlatform.getSdkData();
        }
        return null;
    }

    @Nullable
    private static AndroidSdkData getProjectSdkData(Project project) {
        AndroidSdkAdditionalData sdkData;
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectSdk != null && projectSdk.getSdkType() == AndroidSdkType.getInstance() && (sdkData = (AndroidSdkAdditionalData)projectSdk.getSdkAdditionalData()) != null) {
            AndroidPlatform platform = sdkData.getAndroidPlatform();
            return platform != null ? platform.getSdkData() : null;
        }
        return null;
    }

    public static boolean activateDdmsIfNecessary(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/sdk/AndroidSdkUtils", "activateDdmsIfNecessary"));
        }
        if (AndroidEnableAdbServiceAction.isAdbServiceEnabled()) {
            AndroidDebugBridge bridge = AndroidSdkUtils.getDebugBridge(project);
            if (bridge != null && AdbService.isDdmsCorrupted(bridge)) {
                LOG.info("DDMLIB is corrupted and will be restarted");
                AdbService.restartDdmlib(project);
            }
        } else {
            final OSProcessHandler ddmsProcessHandler = AndroidRunDdmsAction.getDdmsProcessHandler();
            if (ddmsProcessHandler != null) {
                int r = Messages.showYesNoDialog((Project)project, (String)"Monitor will be closed to enable ADB integration. Continue?", (String)"ADB Integration", (Icon)Messages.getQuestionIcon());
                if (r != 0) {
                    return false;
                }
                Runnable destroyingRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!ddmsProcessHandler.isProcessTerminated()) {
                            OSProcessManager.getInstance().killProcessTree(ddmsProcessHandler.getProcess());
                            ddmsProcessHandler.waitFor();
                        }
                    }
                };
                if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(destroyingRunnable, "Closing Monitor", true, project)) {
                    return false;
                }
                AndroidEnableAdbServiceAction.setAdbServiceEnabled(project, true);
                return true;
            }
            int result = Messages.showYesNoDialog((Project)project, (String)AndroidBundle.message("android.ddms.disabled.error", new Object[0]), (String)AndroidBundle.message("android.ddms.disabled.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result != 0) {
                return false;
            }
            AndroidEnableAdbServiceAction.setAdbServiceEnabled(project, true);
        }
        return true;
    }

    public static boolean isAndroidSdkAvailable() {
        return AndroidSdkUtils.tryToChooseAndroidSdk() != null;
    }

    @Nullable
    public static AndroidSdkData tryToChooseAndroidSdk() {
        block2: {
            String s;
            File path;
            if (ourSdkData != null) break block2;
            if (AndroidStudioSpecificInitializer.isAndroidStudio() && (path = DefaultSdks.getDefaultAndroidHome()) != null && (ourSdkData = AndroidSdkData.getSdkData(path.getPath())) != null) {
                return ourSdkData;
            }
            Iterator<String> i$ = AndroidSdkUtils.getAndroidSdkPathsFromExistingPlatforms().iterator();
            while (i$.hasNext() && (ourSdkData = AndroidSdkData.getSdkData(s = i$.next())) == null) {
            }
        }
        return ourSdkData;
    }

    public static void setSdkData(@Nullable AndroidSdkData data) {
        ourSdkData = data;
    }

    @Nullable
    public static File findPlatformSources(@NotNull IAndroidTarget target) {
        File platformSource;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "findPlatformSources"));
        }
        String path = target.getPath(18);
        if (path != null && (platformSource = new File(path)).isDirectory()) {
            return platformSource;
        }
        return null;
    }

    @NotNull
    public static String getTargetLabel(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkUtils", "getTargetLabel"));
        }
        if (!target.isPlatform()) {
            String string = String.format("%1$s (API %2$s)", target.getFullName(), target.getVersion().getApiString());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "getTargetLabel"));
            }
            return string;
        }
        AndroidVersion version = target.getVersion();
        if (version.isPreview()) {
            String string = String.format("API %d+: %s", target.getVersion().getApiLevel(), target.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "getTargetLabel"));
            }
            return string;
        }
        String name = SdkVersionInfo.getAndroidName((int)target.getVersion().getApiLevel());
        if (name != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "getTargetLabel"));
            }
            return string;
        }
        String release = target.getProperty("ro.build.version.release");
        if (release != null) {
            String string = String.format("API %1$d: Android %2$s", version.getApiLevel(), release);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "getTargetLabel"));
            }
            return string;
        }
        String string = String.format("API %1$d", version.getApiLevel());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkUtils", "getTargetLabel"));
        }
        return string;
    }

    @Nullable
    public static AndroidDebugBridge getDebugBridge(@NotNull Project project) {
        boolean retry;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/sdk/AndroidSdkUtils", "getDebugBridge"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        AndroidSdkData data = AndroidSdkUtils.getProjectSdkData(project);
        if (data == null) {
            data = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
        }
        if (data == null) {
            return null;
        }
        AndroidDebugBridge bridge = null;
        do {
            File adb;
            if ((adb = AndroidSdkUtils.getAdb(project)) == null) {
                LOG.error("Unable to locate adb within SDK");
                return null;
            }
            ListenableFuture<AndroidDebugBridge> future = AdbService.getDebugBridge(adb);
            MyMonitorBridgeConnectionTask task = new MyMonitorBridgeConnectionTask(project, (Future<AndroidDebugBridge>)future);
            ProgressManager.getInstance().run((Task)task);
            if (task.wasCanceled()) {
                return null;
            }
            retry = false;
            try {
                bridge = (AndroidDebugBridge)future.get();
            }
            catch (InterruptedException e) {
                break;
            }
            catch (ExecutionException e) {
                String adbErrors = Joiner.on((char)'\n').join((Object[])AdbErrors.getErrors());
                String message = "ADB not responding. If you'd like to retry, then please manually kill \"" + SdkConstants.FN_ADB + "\" and click 'Restart'";
                if (!adbErrors.isEmpty()) {
                    message = message + "\nErrors from ADB:\n" + adbErrors;
                }
                boolean bl = retry = Messages.showYesNoDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle(), (String)"&Restart", (String)"&Cancel", (Icon)Messages.getErrorIcon()) == 0;
            }
        } while (retry);
        return bridge;
    }

    @Nullable
    public static String getSdkDownloadUrl() {
        if (SystemInfo.isLinux) {
            return LINUX_SDK_URL;
        }
        if (SystemInfo.isWindows) {
            return WINDOWS_SDK_URL;
        }
        if (SystemInfo.isMac) {
            return MAC_SDK_URL;
        }
        return null;
    }

    private static class MyMonitorBridgeConnectionTask
    extends Task.Modal {
        private final Future<AndroidDebugBridge> myFuture;
        private boolean myCancelled;

        public MyMonitorBridgeConnectionTask(@Nullable Project project, Future<AndroidDebugBridge> future) {
            super(project, "Waiting for adb", true);
            this.myFuture = future;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/sdk/AndroidSdkUtils$MyMonitorBridgeConnectionTask", "run"));
            }
            indicator.setIndeterminate(true);
            while (!this.myFuture.isDone()) {
                try {
                    this.myFuture.get(200L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!indicator.isCanceled()) continue;
                return;
            }
        }

        public void onCancel() {
            this.myCancelled = true;
        }

        public boolean wasCanceled() {
            return this.myCancelled;
        }
    }
}

