/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChooseByNameRegistry {
    private final List<ChooseByNameContributor> myGotoClassContributors = new ArrayList<ChooseByNameContributor>();
    private final List<ChooseByNameContributor> myGotoSymbolContributors = new ArrayList<ChooseByNameContributor>();
    private boolean myGotoClassExtensionsLoaded = false;
    private boolean myGotoSymbolExtensionsLoaded = false;

    public static ChooseByNameRegistry getInstance() {
        return ServiceManager.getService(ChooseByNameRegistry.class);
    }

    public void contributeToClasses(ChooseByNameContributor contributor) {
        this.myGotoClassContributors.add(contributor);
    }

    public void contributeToSymbols(ChooseByNameContributor contributor) {
        this.myGotoSymbolContributors.add(contributor);
    }

    public void removeContributor(ChooseByNameContributor contributor) {
        this.myGotoClassContributors.remove(contributor);
        this.myGotoSymbolContributors.remove(contributor);
    }

    public ChooseByNameContributor[] getClassModelContributors() {
        if (!this.myGotoClassExtensionsLoaded) {
            this.myGotoClassExtensionsLoaded = true;
            Collections.addAll(this.myGotoClassContributors, Extensions.getExtensions(ChooseByNameContributor.CLASS_EP_NAME));
        }
        return this.myGotoClassContributors.toArray(new ChooseByNameContributor[this.myGotoClassContributors.size()]);
    }

    public ChooseByNameContributor[] getSymbolModelContributors() {
        if (!this.myGotoSymbolExtensionsLoaded) {
            this.myGotoSymbolExtensionsLoaded = true;
            Collections.addAll(this.myGotoSymbolContributors, Extensions.getExtensions(ChooseByNameContributor.SYMBOL_EP_NAME));
        }
        return this.myGotoSymbolContributors.toArray(new ChooseByNameContributor[this.myGotoSymbolContributors.size()]);
    }
}

