/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ColorSettingsUtil {
    private ColorSettingsUtil() {
    }

    public static Map<TextAttributesKey, String> keyToDisplayTextMap(ColorSettingsPage page) {
        List<AttributesDescriptor> attributeDescriptors = ColorSettingsUtil.getAllAttributeDescriptors((ColorAndFontDescriptorsProvider)page);
        HashMap displayText = new HashMap();
        for (AttributesDescriptor attributeDescriptor : attributeDescriptors) {
            TextAttributesKey key = attributeDescriptor.getKey();
            displayText.put(key, attributeDescriptor.getDisplayName());
        }
        return displayText;
    }

    public static List<AttributesDescriptor> getAllAttributeDescriptors(ColorAndFontDescriptorsProvider provider) {
        ArrayList<AttributesDescriptor> result = new ArrayList<AttributesDescriptor>();
        Collections.addAll(result, provider.getAttributeDescriptors());
        if (ColorSettingsUtil.isInspectionColorsPage(provider)) {
            ColorSettingsUtil.addInspectionSeverityAttributes(result);
        }
        return result;
    }

    private static boolean isInspectionColorsPage(ColorAndFontDescriptorsProvider provider) {
        if (!(provider instanceof InspectionColorSettingsPage)) {
            return false;
        }
        for (ColorSettingsPage settingsPage : (ColorSettingsPage[])Extensions.getExtensions((ExtensionPointName)ColorSettingsPage.EP_NAME)) {
            if (settingsPage == provider) break;
            if (!(settingsPage instanceof InspectionColorSettingsPage)) continue;
            return false;
        }
        return true;
    }

    static boolean isSharedScheme(EditorColorsScheme selected) {
        return false;
    }

    private static void addInspectionSeverityAttributes(List<AttributesDescriptor> descriptors) {
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.unknown.symbol", (Object[])new Object[0]), CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.deprecated.symbol", (Object[])new Object[0]), CodeInsightColors.DEPRECATED_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.unused.symbol", (Object[])new Object[0]), CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.error", (Object[])new Object[0]), CodeInsightColors.ERRORS_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.warning", (Object[])new Object[0]), CodeInsightColors.WARNINGS_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.weak.warning", (Object[])new Object[0]), CodeInsightColors.WEAK_WARNING_ATTRIBUTES));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.server.problems", (Object[])new Object[0]), CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING));
        descriptors.add(new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.server.duplicate", (Object[])new Object[0]), CodeInsightColors.DUPLICATE_FROM_SERVER));
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType highlightInfoType : provider.getSeveritiesHighlightInfoTypes()) {
                TextAttributesKey attributesKey = highlightInfoType.getAttributesKey();
                descriptors.add(new AttributesDescriptor(ColorSettingsUtil.toDisplayName(attributesKey), attributesKey));
            }
        }
    }

    @NotNull
    private static String toDisplayName(@NotNull TextAttributesKey attributesKey) {
        if (attributesKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributesKey", "com/intellij/application/options/colors/ColorSettingsUtil", "toDisplayName"));
        }
        String string = StringUtil.capitalize((String)attributesKey.getExternalName().toLowerCase().replaceAll("_", " "));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorSettingsUtil", "toDisplayName"));
        }
        return string;
    }
}

