/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RedundantLambdaParameterTypeIntention
extends PsiElementBaseIntentionAction {
    public static final Logger LOG = Logger.getInstance((String)("#" + RedundantLambdaParameterTypeIntention.class.getName()));

    @NotNull
    public String getFamilyName() {
        if ("Remove redundant types" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/RedundantLambdaParameterTypeIntention", "getFamilyName"));
        }
        return "Remove redundant types";
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/RedundantLambdaParameterTypeIntention", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiParameter[] parameters;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/quickFix/RedundantLambdaParameterTypeIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/quickFix/RedundantLambdaParameterTypeIntention", "isAvailable"));
        }
        PsiParameterList parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameterList.class);
        if (parameterList == null) {
            return false;
        }
        PsiElement parent = parameterList.getParent();
        if (!(parent instanceof PsiLambdaExpression)) {
            return false;
        }
        PsiLambdaExpression expression = (PsiLambdaExpression)parent;
        for (PsiParameter parameter : parameters = parameterList.getParameters()) {
            if (parameter.getTypeElement() != null) continue;
            return false;
        }
        if (parameters.length == 0) {
            return false;
        }
        PsiType functionalInterfaceType = LambdaUtil.getFunctionalInterfaceType((PsiElement)expression, (boolean)true);
        if (functionalInterfaceType != null) {
            PsiElement gParent;
            PsiElement lambdaParent = expression.getParent();
            if (lambdaParent instanceof PsiExpressionList && (gParent = lambdaParent.getParent()) instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArguments().length == 0) {
                JavaResolveResult resolveResult = ((PsiCallExpression)gParent).resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method == null) {
                    return false;
                }
                int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)((PsiExpressionList)lambdaParent), (PsiElement)expression);
                if (idx < 0) {
                    return false;
                }
                PsiTypeParameter[] typeParameters = method.getTypeParameters();
                PsiExpression[] arguments = ((PsiExpressionList)lambdaParent).getExpressions();
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
                arguments[idx] = javaPsiFacade.getElementFactory().createExpressionFromText("(" + StringUtil.join((Object[])expression.getParameterList().getParameters(), (Function)new Function<PsiParameter, String>(){

                    public String fun(PsiParameter parameter) {
                        return parameter.getName();
                    }
                }, (String)", ") + ") -> {}", (PsiElement)expression);
                PsiSubstitutor substitutor = javaPsiFacade.getResolveHelper().inferTypeArguments(typeParameters, method.getParameterList().getParameters(), arguments, ((MethodCandidateInfo)resolveResult).getSiteSubstitutor(), gParent, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
                for (PsiTypeParameter parameter : typeParameters) {
                    PsiType psiType = substitutor.substitute(parameter);
                    if (psiType != null && !RedundantLambdaParameterTypeIntention.dependsOnTypeParams(psiType, expression, parameter)) continue;
                    return false;
                }
                return functionalInterfaceType.isAssignableFrom(substitutor.substitute(method.getParameterList().getParameters()[idx].getType()));
            }
            return LambdaUtil.isLambdaFullyInferred((PsiLambdaExpression)expression, (PsiType)functionalInterfaceType);
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/quickFix/RedundantLambdaParameterTypeIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/quickFix/RedundantLambdaParameterTypeIntention", "invoke"));
        }
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
        RedundantLambdaParameterTypeIntention.removeTypes(lambdaExpression);
    }

    private static void removeTypes(PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression != null) {
            Object[] parameters = lambdaExpression.getParameterList().getParameters();
            String text = parameters.length == 1 ? parameters[0].getName() : "(" + StringUtil.join((Object[])parameters, (Function)new Function<PsiParameter, String>(){

                public String fun(PsiParameter parameter) {
                    return parameter.getName();
                }
            }, (String)", ") + ")";
            PsiLambdaExpression expression = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)lambdaExpression.getProject()).createExpressionFromText(text + "->{}", (PsiElement)lambdaExpression);
            lambdaExpression.getParameterList().replace((PsiElement)expression.getParameterList());
        }
    }

    private static boolean dependsOnTypeParams(PsiType type, PsiLambdaExpression expr, PsiTypeParameter param2Check) {
        return LambdaUtil.depends((PsiType)type, (LambdaUtil.TypeParamsChecker)new LambdaUtil.TypeParamsChecker((PsiElement)expr, PsiUtil.resolveGenericsClassInType((PsiType)LambdaUtil.getFunctionalInterfaceType((PsiElement)expr, (boolean)false)).getElement()), (PsiTypeParameter[])new PsiTypeParameter[]{param2Check});
    }
}

