/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.openapi.vcs.FileStatus;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionTreeNode
extends DefaultMutableTreeNode {
    private boolean myResolved = false;

    protected InspectionTreeNode(Object userObject) {
        super(userObject);
    }

    @Nullable
    public abstract Icon getIcon(boolean var1);

    public int getProblemCount() {
        int sum = 0;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)enumeration.nextElement();
            sum += child.getProblemCount();
        }
        return sum;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public boolean appearsBold() {
        return false;
    }

    public FileStatus getNodeStatus() {
        return FileStatus.NOT_CHANGED;
    }

    public void ignoreElement() {
        this.myResolved = true;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)enumeration.nextElement();
            child.ignoreElement();
        }
    }

    public void amnesty() {
        this.myResolved = false;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)enumeration.nextElement();
            child.amnesty();
        }
    }
}

