/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.threeside;

import com.intellij.diff.tools.util.threeside.ThreesideContentPanel;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ThreesideTextContentPanel
extends ThreesideContentPanel {
    @NotNull
    private final List<? extends Editor> myEditors;

    public ThreesideTextContentPanel(@NotNull List<? extends Editor> editors, @NotNull List<JComponent> titleComponents) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/threeside/ThreesideTextContentPanel", "<init>"));
        }
        if (titleComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleComponents", "com/intellij/diff/tools/util/threeside/ThreesideTextContentPanel", "<init>"));
        }
        super(ThreesideTextContentPanel.getComponents(editors), titleComponents);
        this.myEditors = editors;
    }

    @NotNull
    private static List<JComponent> getComponents(@NotNull List<? extends Editor> editors) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/threeside/ThreesideTextContentPanel", "getComponents"));
        }
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        for (Editor editor : editors) {
            result.add(editor != null ? editor.getComponent() : null);
        }
        ArrayList<JComponent> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/threeside/ThreesideTextContentPanel", "getComponents"));
        }
        return arrayList;
    }

    public void setScrollbarPainter(@NotNull ButtonlessScrollBarUI.ScrollbarRepaintCallback painter) {
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/diff/tools/util/threeside/ThreesideTextContentPanel", "setScrollbarPainter"));
        }
        ((EditorEx)this.myEditors.get(1)).registerScrollBarRepaintCallback(painter);
    }

    @Override
    public void repaintDivider(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/threeside/ThreesideTextContentPanel", "repaintDivider"));
        }
        super.repaintDivider(side);
        if (side == Side.RIGHT) {
            ((EditorEx)this.myEditors.get(1)).getScrollPane().getVerticalScrollBar().repaint();
        }
    }
}

