/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl.livePreview;

import com.intellij.find.EditorSearchComponent;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.impl.FindResultImpl;
import com.intellij.find.impl.livePreview.LivePreview;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivePreviewController
implements LivePreview.Delegate,
FindUtil.ReplaceDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.impl.livePreview.LivePreviewController");
    public static final int USER_ACTIVITY_TRIGGERING_DELAY = 30;
    public static final int MATCHES_LIMIT = 10000;
    protected EditorSearchComponent myComponent;
    private int myUserActivityDelay = 30;
    private final Alarm myLivePreviewAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
    protected SearchResults mySearchResults;
    private LivePreview myLivePreview;
    private final boolean myReplaceDenied = false;
    private boolean mySuppressUpdate = false;
    private boolean myTrackingDocument;
    private boolean myChanged;
    private boolean myListeningSelection = false;
    private final SelectionListener mySelectionListener = new SelectionListener(){

        public void selectionChanged(SelectionEvent e) {
            LivePreviewController.this.smartUpdate();
        }
    };
    private boolean myDisposed;
    private final DocumentAdapter myDocumentListener = new DocumentAdapter(){

        public void documentChanged(DocumentEvent e) {
            if (!LivePreviewController.this.myTrackingDocument) {
                LivePreviewController.this.myChanged = true;
                return;
            }
            if (!LivePreviewController.this.mySuppressUpdate) {
                LivePreviewController.this.smartUpdate();
            } else {
                LivePreviewController.this.mySuppressUpdate = false;
            }
        }
    };

    public void setTrackingSelection(boolean b) {
        if (b) {
            if (!this.myListeningSelection) {
                this.getEditor().getSelectionModel().addSelectionListener(this.mySelectionListener);
            }
        } else if (this.myListeningSelection) {
            this.getEditor().getSelectionModel().removeSelectionListener(this.mySelectionListener);
        }
        this.myListeningSelection = b;
    }

    private void smartUpdate() {
        this.myLivePreview.inSmartUpdate();
        this.updateInBackground(this.mySearchResults.getFindModel(), false);
    }

    public void moveCursor(SearchResults.Direction direction) {
        if (direction == SearchResults.Direction.UP) {
            this.mySearchResults.prevOccurrence(false);
        } else {
            this.mySearchResults.nextOccurrence(false);
        }
    }

    public boolean isReplaceDenied() {
        return false;
    }

    public LivePreviewController(SearchResults searchResults, @Nullable EditorSearchComponent component) {
        this.mySearchResults = searchResults;
        this.myComponent = component;
        this.getEditor().getDocument().addDocumentListener((DocumentListener)this.myDocumentListener);
    }

    public int getUserActivityDelay() {
        return this.myUserActivityDelay;
    }

    public void setUserActivityDelay(int userActivityDelay) {
        this.myUserActivityDelay = userActivityDelay;
    }

    public void updateInBackground(FindModel findModel, final boolean allowedToChangedEditorSelection) {
        final int stamp = this.mySearchResults.getStamp();
        this.myLivePreviewAlarm.cancelAllRequests();
        if (findModel == null) {
            return;
        }
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        final FindModel copy = new FindModel();
        copy.copyFrom(findModel);
        Runnable request = new Runnable(){

            @Override
            public void run() {
                if (LivePreviewController.this.myDisposed) {
                    return;
                }
                Project project = LivePreviewController.this.mySearchResults.getProject();
                if (project != null && project.isDisposed()) {
                    return;
                }
                LivePreviewController.this.mySearchResults.updateThreadSafe(copy, allowedToChangedEditorSelection, null, stamp);
            }
        };
        if (unitTestMode) {
            request.run();
        } else {
            this.myLivePreviewAlarm.addRequest(request, this.myUserActivityDelay);
        }
    }

    @Override
    public String getStringToReplace(@NotNull Editor editor, @Nullable FindResult findResult) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/impl/livePreview/LivePreviewController", "getStringToReplace"));
        }
        if (findResult == null) {
            return null;
        }
        String foundString = editor.getDocument().getText((TextRange)findResult);
        String documentText = editor.getDocument().getText();
        FindModel currentModel = this.mySearchResults.getFindModel();
        String stringToReplace = null;
        if (currentModel != null && currentModel.isReplaceState()) {
            FindManager findManager = FindManager.getInstance((Project)editor.getProject());
            try {
                stringToReplace = findManager.getStringToReplace(foundString, currentModel, findResult.getStartOffset(), (CharSequence)documentText);
            }
            catch (FindManager.MalformedReplacementStringException e) {
                return null;
            }
        }
        return stringToReplace;
    }

    @Nullable
    public TextRange performReplace(FindResult occurrence, String replacement, Editor editor) {
        if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)editor.getProject(), (Document)editor.getDocument())) {
            return null;
        }
        FindModel findModel = this.mySearchResults.getFindModel();
        TextRange result = FindUtil.doReplace(editor.getProject(), editor.getDocument(), findModel, new FindResultImpl(occurrence.getStartOffset(), occurrence.getEndOffset()), replacement, true, new ArrayList<Pair<TextRange, String>>());
        this.myLivePreview.inSmartUpdate();
        this.mySearchResults.updateThreadSafe(findModel, true, result, this.mySearchResults.getStamp());
        return result;
    }

    public void performReplaceAll(Editor e) {
        if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)e.getProject(), (Document)e.getDocument())) {
            return;
        }
        if (this.mySearchResults.getFindModel() != null) {
            int offset;
            FindModel copy = new FindModel();
            copy.copyFrom(this.mySearchResults.getFindModel());
            SelectionModel selectionModel = this.mySearchResults.getEditor().getSelectionModel();
            if (!selectionModel.hasSelection() || copy.isGlobal()) {
                copy.setGlobal(true);
                offset = 0;
            } else {
                offset = selectionModel.getBlockSelectionStarts()[0];
            }
            FindUtil.replace(e.getProject(), e, offset, copy, this);
        }
    }

    @Override
    public boolean shouldReplace(TextRange range, String replace) {
        for (RangeMarker r : this.mySearchResults.getExcluded()) {
            if (!TextRange.areSegmentsEqual((Segment)r, (Segment)range)) continue;
            return false;
        }
        return true;
    }

    public boolean canReplace() {
        if (this.mySearchResults != null && this.mySearchResults.getCursor() != null && !this.isReplaceDenied()) {
            String replacement = this.getStringToReplace(this.getEditor(), this.mySearchResults.getCursor());
            return replacement != null;
        }
        return false;
    }

    private Editor getEditor() {
        return this.mySearchResults.getEditor();
    }

    public void performReplace() {
        this.mySuppressUpdate = true;
        String replacement = this.getStringToReplace(this.getEditor(), this.mySearchResults.getCursor());
        if (replacement == null) {
            return;
        }
        TextRange textRange = this.performReplace(this.mySearchResults.getCursor(), replacement, this.getEditor());
        if (textRange == null) {
            this.mySuppressUpdate = false;
        }
        if (this.myComponent != null) {
            this.myComponent.addTextToRecent(this.myComponent.getReplaceField());
            this.myComponent.clearUndoInTextFields();
        }
    }

    public void exclude() {
        this.mySearchResults.exclude(this.mySearchResults.getCursor());
    }

    public void performReplaceAll() {
        this.performReplaceAll(this.getEditor());
    }

    public void setTrackingDocument(boolean trackingDocument) {
        this.myTrackingDocument = trackingDocument;
    }

    public void setLivePreview(LivePreview livePreview) {
        if (this.myLivePreview != null) {
            this.myLivePreview.dispose();
            this.myLivePreview.setDelegate(null);
        }
        this.myLivePreview = livePreview;
        if (this.myLivePreview != null) {
            this.myLivePreview.setDelegate(this);
        }
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myLivePreview.cleanUp();
        this.off();
        this.mySearchResults.dispose();
        this.getEditor().getDocument().removeDocumentListener((DocumentListener)this.myDocumentListener);
        this.myDisposed = true;
    }

    public void on() {
        if (this.myDisposed) {
            return;
        }
        this.mySearchResults.setMatchesLimit(10000);
        this.setTrackingDocument(true);
        if (this.myChanged) {
            this.mySearchResults.clear();
            this.myChanged = false;
        }
        this.setLivePreview(new LivePreview(this.mySearchResults));
    }

    public void off() {
        if (this.myDisposed) {
            return;
        }
        this.setTrackingDocument(false);
        this.setLivePreview(null);
        this.setTrackingSelection(false);
    }
}

