/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.Paths;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.DirectoryEntry;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.FileEntry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaGateway {
    private static final Key<ContentAndTimestamps> SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY = Key.create((String)"LocalHistory.SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY");

    public boolean isVersioned(@NotNull VirtualFile f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "isVersioned"));
        }
        return this.isVersioned(f, false);
    }

    public boolean isVersioned(@NotNull VirtualFile f, boolean shouldBeInContent) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "isVersioned"));
        }
        if (!f.isInLocalFileSystem()) {
            return false;
        }
        if (!f.isDirectory() && StringUtil.endsWith((CharSequence)f.getNameSequence(), (CharSequence)".class")) {
            return false;
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        boolean isInContent = false;
        for (Project each : openProjects) {
            if (each.isDefault() || !each.isInitialized()) continue;
            if (Comparing.equal((Object)each.getWorkspaceFile(), (Object)f)) {
                return false;
            }
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)each).getFileIndex();
            if (index.isExcluded(f)) {
                return false;
            }
            isInContent |= index.isInContent(f);
        }
        if (shouldBeInContent && !isInContent) {
            return false;
        }
        return openProjects.length != 0 || !FileTypeManager.getInstance().isFileIgnored(f);
    }

    public boolean areContentChangesVersioned(@NotNull VirtualFile f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "areContentChangesVersioned"));
        }
        return this.isVersioned(f) && !f.isDirectory() && !f.getFileType().isBinary();
    }

    public boolean areContentChangesVersioned(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/history/integration/IdeaGateway", "areContentChangesVersioned"));
        }
        return !FileTypeManager.getInstance().getFileTypeByFileName(fileName).isBinary();
    }

    public boolean ensureFilesAreWritable(@NotNull Project p, @NotNull List<VirtualFile> ff) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/history/integration/IdeaGateway", "ensureFilesAreWritable"));
        }
        if (ff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ff", "com/intellij/history/integration/IdeaGateway", "ensureFilesAreWritable"));
        }
        ReadonlyStatusHandler h = ReadonlyStatusHandler.getInstance((Project)p);
        return !h.ensureFilesWritable(VfsUtilCore.toVirtualFileArray(ff)).hasReadonlyFiles();
    }

    @Nullable
    public VirtualFile findVirtualFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "findVirtualFile"));
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @NotNull
    public VirtualFile findOrCreateFileSafely(@NotNull VirtualFile parent, @NotNull String name, boolean isDirectory) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/history/integration/IdeaGateway", "findOrCreateFileSafely"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/history/integration/IdeaGateway", "findOrCreateFileSafely"));
        }
        VirtualFile f = parent.findChild(name);
        if (f != null && f.isDirectory() != isDirectory) {
            f.delete((Object)this);
            f = null;
        }
        if (f == null) {
            f = isDirectory ? parent.createChildDirectory((Object)this, name) : parent.createChildData((Object)this, name);
        }
        VirtualFile virtualFile = f;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "findOrCreateFileSafely"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile findOrCreateFileSafely(@NotNull String path, boolean isDirectory) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "findOrCreateFileSafely"));
        }
        VirtualFile f = this.findVirtualFile(path);
        if (f != null && f.isDirectory() != isDirectory) {
            f.delete((Object)this);
            f = null;
        }
        if (f == null) {
            VirtualFile parent = this.findOrCreateFileSafely(Paths.getParentOf(path), true);
            String name = Paths.getNameOf(path);
            f = isDirectory ? parent.createChildDirectory((Object)this, name) : parent.createChildData((Object)this, name);
        }
        VirtualFile virtualFile = f;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "findOrCreateFileSafely"));
        }
        return virtualFile;
    }

    public List<VirtualFile> getAllFilesFrom(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "getAllFilesFrom"));
        }
        VirtualFile f = this.findVirtualFile(path);
        if (f == null) {
            return Collections.emptyList();
        }
        return IdeaGateway.collectFiles(f, new ArrayList<VirtualFile>());
    }

    @NotNull
    private static List<VirtualFile> collectFiles(@NotNull VirtualFile f, @NotNull List<VirtualFile> result) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "collectFiles"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/history/integration/IdeaGateway", "collectFiles"));
        }
        if (f.isDirectory()) {
            for (VirtualFile child : IdeaGateway.iterateDBChildren(f)) {
                IdeaGateway.collectFiles(child, result);
            }
        } else {
            result.add(f);
        }
        List<VirtualFile> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "collectFiles"));
        }
        return list;
    }

    @NotNull
    public static Iterable<VirtualFile> iterateDBChildren(VirtualFile f) {
        if (!(f instanceof NewVirtualFile)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "iterateDBChildren"));
            }
            return list;
        }
        NewVirtualFile nf = (NewVirtualFile)f;
        Iterable iterable = nf.iterInDbChildren();
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "iterateDBChildren"));
        }
        return iterable;
    }

    @NotNull
    public static Iterable<VirtualFile> loadAndIterateChildren(VirtualFile f) {
        if (!(f instanceof NewVirtualFile)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "loadAndIterateChildren"));
            }
            return list;
        }
        NewVirtualFile nf = (NewVirtualFile)f;
        List<VirtualFile> list = Arrays.asList(nf.getChildren());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "loadAndIterateChildren"));
        }
        return list;
    }

    @NotNull
    public RootEntry createTransientRootEntry() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootEntry root = new RootEntry();
        this.doCreateChildren(root, IdeaGateway.getLocalRoots(), false);
        RootEntry rootEntry = root;
        if (rootEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "createTransientRootEntry"));
        }
        return rootEntry;
    }

    @NotNull
    public RootEntry createTransientRootEntryForPathOnly(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "createTransientRootEntryForPathOnly"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootEntry root = new RootEntry();
        this.doCreateChildrenForPathOnly(root, path, IdeaGateway.getLocalRoots());
        RootEntry rootEntry = root;
        if (rootEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "createTransientRootEntryForPathOnly"));
        }
        return rootEntry;
    }

    private static List<VirtualFile> getLocalRoots() {
        return Arrays.asList(ManagingFS.getInstance().getLocalRoots());
    }

    private void doCreateChildrenForPathOnly(@NotNull DirectoryEntry parent, @NotNull String path, @NotNull Iterable<VirtualFile> children) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/history/integration/IdeaGateway", "doCreateChildrenForPathOnly"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "doCreateChildrenForPathOnly"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/history/integration/IdeaGateway", "doCreateChildrenForPathOnly"));
        }
        for (VirtualFile child : children) {
            Entry e;
            String rest;
            String name = StringUtil.trimStart((String)child.getName(), (String)"/");
            if (!path.startsWith(name) || !(rest = path.substring(name.length())).isEmpty() && rest.charAt(0) != '/') continue;
            if (!rest.isEmpty() && rest.charAt(0) == '/') {
                rest = rest.substring(1);
            }
            if ((e = this.doCreateEntryForPathOnly(child, rest)) == null) continue;
            parent.addChild(e);
        }
    }

    @Nullable
    private Entry doCreateEntryForPathOnly(@NotNull VirtualFile file, @NotNull String path) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/history/integration/IdeaGateway", "doCreateEntryForPathOnly"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "doCreateEntryForPathOnly"));
        }
        if (!file.isDirectory()) {
            if (!this.isVersioned(file)) {
                return null;
            }
            Pair<StoredContent, Long> contentAndStamps = IdeaGateway.getActualContentNoAcquire(file);
            return new FileEntry(file.getName(), (Content)contentAndStamps.first, (Long)contentAndStamps.second, !file.isWritable());
        }
        DirectoryEntry newDir = new DirectoryEntry(file.getName());
        this.doCreateChildrenForPathOnly(newDir, path, IdeaGateway.iterateDBChildren(file));
        if (!this.isVersioned(file) && newDir.getChildren().isEmpty()) {
            return null;
        }
        return newDir;
    }

    @Nullable
    public Entry createTransientEntry(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/history/integration/IdeaGateway", "createTransientEntry"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.doCreateEntry(file, false);
    }

    @Nullable
    public Entry createEntryForDeletion(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/history/integration/IdeaGateway", "createEntryForDeletion"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.doCreateEntry(file, true);
    }

    @Nullable
    private Entry doCreateEntry(@NotNull VirtualFile file, boolean forDeletion) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/history/integration/IdeaGateway", "doCreateEntry"));
        }
        if (!file.isDirectory()) {
            Pair<StoredContent, Long> contentAndStamps;
            if (!this.isVersioned(file)) {
                return null;
            }
            if (forDeletion) {
                FileDocumentManager m = FileDocumentManager.getInstance();
                Document d = m.isFileModified(file) ? m.getCachedDocument(file) : null;
                contentAndStamps = this.acquireAndClearCurrentContent(file, d);
            } else {
                contentAndStamps = IdeaGateway.getActualContentNoAcquire(file);
            }
            return new FileEntry(file.getName(), (Content)contentAndStamps.first, (Long)contentAndStamps.second, !file.isWritable());
        }
        DirectoryEntry newDir = new DirectoryEntry(file.getName());
        this.doCreateChildren(newDir, IdeaGateway.iterateDBChildren(file), forDeletion);
        if (!this.isVersioned(file) && newDir.getChildren().isEmpty()) {
            return null;
        }
        return newDir;
    }

    private void doCreateChildren(@NotNull DirectoryEntry parent, Iterable<VirtualFile> children, final boolean forDeletion) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/history/integration/IdeaGateway", "doCreateChildren"));
        }
        List entries = ContainerUtil.mapNotNull(children, (Function)new NullableFunction<VirtualFile, Entry>(){

            public Entry fun(@NotNull VirtualFile each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/history/integration/IdeaGateway$1", "fun"));
                }
                return IdeaGateway.this.doCreateEntry(each, forDeletion);
            }
        });
        parent.addChildren(entries);
    }

    public void registerUnsavedDocuments(final @NotNull LocalHistoryFacade vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/history/integration/IdeaGateway", "registerUnsavedDocuments"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                vcs.beginChangeSet();
                for (Document d : FileDocumentManager.getInstance().getUnsavedDocuments()) {
                    VirtualFile f = IdeaGateway.getFile(d);
                    if (!IdeaGateway.this.shouldRegisterDocument(f)) continue;
                    IdeaGateway.this.registerDocumentContents(vcs, f, d);
                }
                vcs.endChangeSet(null);
            }
        });
    }

    private boolean shouldRegisterDocument(@Nullable VirtualFile f) {
        return f != null && f.isValid() && this.areContentChangesVersioned(f);
    }

    private void registerDocumentContents(@NotNull LocalHistoryFacade vcs, @NotNull VirtualFile f, Document d) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/history/integration/IdeaGateway", "registerDocumentContents"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "registerDocumentContents"));
        }
        Pair<StoredContent, Long> contentAndStamp = this.acquireAndUpdateActualContent(f, d);
        if (contentAndStamp != null) {
            vcs.contentChanged(f.getPath(), (Content)contentAndStamp.first, (Long)contentAndStamp.second);
        }
    }

    @Nullable
    public Pair<StoredContent, Long> acquireAndUpdateActualContent(@NotNull VirtualFile f, @Nullable Document d) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "acquireAndUpdateActualContent"));
        }
        ContentAndTimestamps contentAndStamp = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY);
        if (contentAndStamp == null) {
            if (d != null) {
                IdeaGateway.saveDocumentContent(f, d);
            }
            return Pair.create((Object)StoredContent.acquireContent(f), (Object)f.getTimeStamp());
        }
        if (d == null) {
            f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, null);
            return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
        }
        if (d.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            return null;
        }
        IdeaGateway.saveDocumentContent(f, d);
        return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
    }

    private static void saveDocumentContent(@NotNull VirtualFile f, @NotNull Document d) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "saveDocumentContent"));
        }
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/history/integration/IdeaGateway", "saveDocumentContent"));
        }
        f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, (Object)new ContentAndTimestamps(Clock.getTime(), StoredContent.acquireContent(IdeaGateway.bytesFromDocument(d)), d.getModificationStamp()));
    }

    @NotNull
    public Pair<StoredContent, Long> acquireAndClearCurrentContent(@NotNull VirtualFile f, @Nullable Document d) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "acquireAndClearCurrentContent"));
        }
        ContentAndTimestamps contentAndStamp = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY);
        f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, null);
        if (d != null && contentAndStamp != null && d.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            Pair pair = Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "acquireAndClearCurrentContent"));
            }
            return pair;
        }
        if (contentAndStamp != null) {
            contentAndStamp.content.release();
        }
        if (d != null) {
            Pair pair = Pair.create((Object)StoredContent.acquireContent(IdeaGateway.bytesFromDocument(d)), (Object)Clock.getTime());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "acquireAndClearCurrentContent"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)StoredContent.acquireContent(f), (Object)f.getTimeStamp());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "acquireAndClearCurrentContent"));
        }
        return pair;
    }

    @NotNull
    private static Pair<StoredContent, Long> getActualContentNoAcquire(@NotNull VirtualFile f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "getActualContentNoAcquire"));
        }
        ContentAndTimestamps result = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY);
        if (result == null) {
            Pair pair = Pair.create((Object)StoredContent.transientContent(f), (Object)f.getTimeStamp());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "getActualContentNoAcquire"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)result.content, (Object)result.registeredTimestamp);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "getActualContentNoAcquire"));
        }
        return pair;
    }

    private static byte[] bytesFromDocument(@NotNull Document d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/history/integration/IdeaGateway", "bytesFromDocument"));
        }
        try {
            return d.getText().getBytes(IdeaGateway.getFile(d).getCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            return d.getText().getBytes();
        }
    }

    public String stringFromBytes(@NotNull byte[] bytes, @NotNull String path) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/history/integration/IdeaGateway", "stringFromBytes"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "stringFromBytes"));
        }
        try {
            VirtualFile file = this.findVirtualFile(path);
            if (file == null) {
                return CharsetToolkit.bytesToString((byte[])bytes, (Charset)EncodingRegistry.getInstance().getDefaultCharset());
            }
            return new String(bytes, file.getCharset().name());
        }
        catch (UnsupportedEncodingException e1) {
            return new String(bytes);
        }
    }

    public void saveAllUnsavedDocuments() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    @Nullable
    private static VirtualFile getFile(@NotNull Document d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/history/integration/IdeaGateway", "getFile"));
        }
        return FileDocumentManager.getInstance().getFile(d);
    }

    @Nullable
    public Document getDocument(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "getDocument"));
        }
        return FileDocumentManager.getInstance().getDocument(this.findVirtualFile(path));
    }

    @NotNull
    public FileType getFileType(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/history/integration/IdeaGateway", "getFileType"));
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "getFileType"));
        }
        return fileType;
    }

    private static class ContentAndTimestamps {
        long registeredTimestamp;
        StoredContent content;
        long documentModificationStamp;

        private ContentAndTimestamps(long registeredTimestamp, StoredContent content, long documentModificationStamp) {
            this.registeredTimestamp = registeredTimestamp;
            this.content = content;
            this.documentModificationStamp = documentModificationStamp;
        }
    }
}

