/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RootType {
    public static final ExtensionPointName<RootType> ROOT_EP = ExtensionPointName.create((String)"com.intellij.scratch.rootType");
    private final String myId;
    private final String myDisplayName;

    @NotNull
    public static RootType[] getAllRootIds() {
        RootType[] rootTypeArray = (RootType[])Extensions.getExtensions(ROOT_EP);
        if (rootTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/RootType", "getAllRootIds"));
        }
        return rootTypeArray;
    }

    @NotNull
    public static RootType findById(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/scratch/RootType", "findById"));
        }
        for (RootType type : RootType.getAllRootIds()) {
            if (!id.equals(type.getId())) continue;
            RootType rootType = type;
            if (rootType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/RootType", "findById"));
            }
            return rootType;
        }
        throw new AssertionError((Object)id);
    }

    @NotNull
    public static <T extends RootType> T findByClass(Class<T> aClass) {
        RootType rootType = (RootType)Extensions.findExtension(ROOT_EP, aClass);
        if (rootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/RootType", "findByClass"));
        }
        return (T)rootType;
    }

    protected RootType(@NotNull String id, @Nullable String displayName) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/scratch/RootType", "<init>"));
        }
        this.myId = id;
        this.myDisplayName = displayName;
    }

    @NotNull
    public final String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/RootType", "getId"));
        }
        return string;
    }

    @Nullable
    public final String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isHidden() {
        return StringUtil.isEmpty((String)this.myDisplayName);
    }

    @Nullable
    public Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/RootType", "substituteLanguage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/RootType", "substituteLanguage"));
        }
        return RootType.substituteLanguageImpl(RootType.getOriginalLanguage(file), file, project);
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/RootType", "substituteIcon"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/RootType", "substituteIcon"));
        }
        Language language = this.substituteLanguage(project, file);
        LanguageFileType fileType = language != null ? language.getAssociatedFileType() : null;
        return fileType != null ? fileType.getIcon() : null;
    }

    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/RootType", "substituteName"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/RootType", "substituteName"));
        }
        return null;
    }

    public VirtualFile findFile(@Nullable Project project, @NotNull String pathName, ScratchFileService.Option option) throws IOException {
        if (pathName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathName", "com/intellij/ide/scratch/RootType", "findFile"));
        }
        return ScratchFileService.getInstance().findFile(this, pathName, option);
    }

    public void fileOpened(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/RootType", "fileOpened"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/scratch/RootType", "fileOpened"));
        }
    }

    @Nullable
    protected static Language substituteLanguageImpl(Language language, VirtualFile file, Project project) {
        return language != null && language != ScratchFileType.INSTANCE.getLanguage() ? LanguageSubstitutors.INSTANCE.substituteLanguage(language, file, project) : language;
    }

    @Nullable
    protected static FileType getOriginalFileType(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/RootType", "getOriginalFileType"));
        }
        String extension = file.getExtension();
        if (extension == null) {
            return null;
        }
        return FileTypeManager.getInstance().getFileTypeByExtension(extension);
    }

    @Nullable
    protected static Language getOriginalLanguage(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/RootType", "getOriginalLanguage"));
        }
        FileType fileType = RootType.getOriginalFileType(file);
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    public boolean isIgnored(@NotNull Project project, @NotNull VirtualFile element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/RootType", "isIgnored"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/scratch/RootType", "isIgnored"));
        }
        return false;
    }

    public void registerTreeUpdater(@NotNull Project project, @NotNull AbstractTreeBuilder builder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/RootType", "registerTreeUpdater"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/ide/scratch/RootType", "registerTreeUpdater"));
        }
    }
}

