/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonParserDefinition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiChangeUtils;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPsiImplUtils {
    private static final Key<List<Pair<TextRange, String>>> STRING_FRAGMENTS = new Key("JSON string fragments");
    private static final String ourEscapesTable = "\"\"\\\\//b\bf\fn\nr\rt\t";

    @NotNull
    public static String getName(@NotNull JsonProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getName"));
        }
        String string = StringUtil.stripQuotesAroundValue((String)property.getNameElement().getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getName"));
        }
        return string;
    }

    @NotNull
    public static JsonValue getNameElement(@NotNull JsonProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getNameElement"));
        }
        PsiElement firstChild = property.getFirstChild();
        assert (firstChild instanceof JsonLiteral || firstChild instanceof JsonReferenceExpression);
        JsonValue jsonValue = (JsonValue)firstChild;
        if (jsonValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getNameElement"));
        }
        return jsonValue;
    }

    @Nullable
    public static JsonValue getValue(@NotNull JsonProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getValue"));
        }
        return (JsonValue)PsiTreeUtil.getNextSiblingOfType((PsiElement)JsonPsiImplUtils.getNameElement(property), JsonValue.class);
    }

    public static boolean isQuotedString(@NotNull JsonLiteral literal) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/json/psi/impl/JsonPsiImplUtils", "isQuotedString"));
        }
        return literal.getNode().findChildByType(JsonParserDefinition.STRING_LITERALS) != null;
    }

    @Nullable
    public static ItemPresentation getPresentation(final @NotNull JsonProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getPresentation"));
        }
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return property.getName();
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                if (property.getValue() instanceof JsonArray) {
                    return AllIcons.Json.Property_brackets;
                }
                if (property.getValue() instanceof JsonObject) {
                    return AllIcons.Json.Property_braces;
                }
                return PlatformIcons.PROPERTY_ICON;
            }
        };
    }

    @Nullable
    public static ItemPresentation getPresentation(@NotNull JsonArray array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getPresentation"));
        }
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return JsonBundle.message("json.array", new Object[0]);
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Json.Array;
            }
        };
    }

    @Nullable
    public static ItemPresentation getPresentation(@NotNull JsonObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getPresentation"));
        }
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return JsonBundle.message("json.object", new Object[0]);
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Json.Object;
            }
        };
    }

    @NotNull
    public static List<Pair<TextRange, String>> getTextFragments(@NotNull JsonStringLiteral literal) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getTextFragments"));
        }
        List<Pair<TextRange, String>> result = (ArrayList<Pair<TextRange, String>>)literal.getUserData(STRING_FRAGMENTS);
        if (result == null) {
            int contentEnd;
            result = new ArrayList<Pair<TextRange, String>>();
            String text = literal.getText();
            int length = text.length();
            int pos = 1;
            int unescapedSequenceStart = 1;
            while (pos < length) {
                if (text.charAt(pos) == '\\') {
                    if (unescapedSequenceStart != pos) {
                        result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(unescapedSequenceStart, pos), (Object)text.substring(unescapedSequenceStart, pos)));
                    }
                    if (pos == length - 1) {
                        result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, pos + 1), (Object)"\\"));
                        break;
                    }
                    char next = text.charAt(pos + 1);
                    switch (next) {
                        case '\"': 
                        case '/': 
                        case '\\': 
                        case 'b': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            int idx = ourEscapesTable.indexOf(next);
                            result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, pos + 2), (Object)ourEscapesTable.substring(idx + 1, idx + 2)));
                            pos += 2;
                            break;
                        }
                        case 'u': {
                            int i;
                            for (i = pos + 2; i < pos + 6 && i != length && StringUtil.isHexDigit((char)text.charAt(i)); ++i) {
                            }
                            result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, i), (Object)text.substring(pos, i)));
                            pos = i;
                            break;
                        }
                        default: {
                            result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, pos + 2), (Object)text.substring(pos, pos + 2)));
                            pos += 2;
                        }
                    }
                    unescapedSequenceStart = pos;
                    continue;
                }
                ++pos;
            }
            int n = contentEnd = text.charAt(0) == text.charAt(length - 1) ? length - 1 : length;
            if (unescapedSequenceStart < contentEnd) {
                result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(unescapedSequenceStart, length), (Object)text.substring(unescapedSequenceStart, contentEnd)));
            }
            result = Collections.unmodifiableList(result);
            literal.putUserData(STRING_FRAGMENTS, result);
        }
        ArrayList<Pair<TextRange, String>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getTextFragments"));
        }
        return arrayList;
    }

    public static void delete(@NotNull JsonProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/json/psi/impl/JsonPsiImplUtils", "delete"));
        }
        ASTNode myNode = property.getNode();
        JsonPsiChangeUtils.removeCommaSeparatedFromList(myNode, myNode.getTreeParent());
    }

    @Nullable
    public static JsonProperty findProperty(@NotNull JsonObject object, @NotNull String name) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/json/psi/impl/JsonPsiImplUtils", "findProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/json/psi/impl/JsonPsiImplUtils", "findProperty"));
        }
        Collection properties = PsiTreeUtil.findChildrenOfType((PsiElement)object, JsonProperty.class);
        for (JsonProperty property : properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    @NotNull
    public static String getValue(@NotNull JsonStringLiteral literal) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getValue"));
        }
        String string = StringUtil.unescapeStringCharacters((String)StringUtil.unquoteString((String)literal.getText()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getValue"));
        }
        return string;
    }

    public static boolean getValue(@NotNull JsonBooleanLiteral literal) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getValue"));
        }
        return literal.textMatches("true");
    }

    public static double getValue(@NotNull JsonNumberLiteral literal) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/json/psi/impl/JsonPsiImplUtils", "getValue"));
        }
        return Double.parseDouble(literal.getText());
    }
}

