/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.navigation.RelatedToHtmlFilesContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.xml.util.HtmlLinkUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LinkedToHtmlFilesContributor
extends RelatedToHtmlFilesContributor {
    @Override
    public void fillRelatedFiles(@NotNull XmlFile xmlFile, final @NotNull Set<PsiFile> resultSet) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/navigation/LinkedToHtmlFilesContributor", "fillRelatedFiles"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/navigation/LinkedToHtmlFilesContributor", "fillRelatedFiles"));
        }
        HtmlLinkUtil.processLinks(xmlFile, new Processor<XmlTag>(){

            public boolean process(XmlTag tag) {
                XmlAttribute attribute = tag.getAttribute("href");
                if (attribute == null) {
                    return true;
                }
                XmlAttributeValue link = attribute.getValueElement();
                if (link == null) {
                    return true;
                }
                for (PsiReference reference : link.getReferences()) {
                    if (reference instanceof PsiPolyVariantReference) {
                        ResolveResult[] results;
                        for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                            PsiElement resolvedElement = result.getElement();
                            if (!(resolvedElement instanceof PsiFile)) continue;
                            resultSet.add((PsiFile)resolvedElement);
                        }
                        continue;
                    }
                    PsiElement resolvedElement = reference.resolve();
                    if (!(resolvedElement instanceof PsiFile)) continue;
                    resultSet.add((PsiFile)resolvedElement);
                }
                return true;
            }
        });
    }

    @Override
    public String getGroupName() {
        return "Linked files";
    }
}

