/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.notification.EventLog;
import com.intellij.notification.LogModel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EventLogConsole {
    private final NotNullLazyValue<Editor> myLogEditor = new NotNullLazyValue<Editor>(){

        @NotNull
        protected Editor compute() {
            Editor editor = EventLogConsole.this.createLogEditor();
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLogConsole$1", "compute"));
            }
            return editor;
        }
    };
    private final NotNullLazyValue<EditorHyperlinkSupport> myHyperlinkSupport = new NotNullLazyValue<EditorHyperlinkSupport>(){

        @NotNull
        protected EditorHyperlinkSupport compute() {
            EditorHyperlinkSupport editorHyperlinkSupport = new EditorHyperlinkSupport((Editor)EventLogConsole.this.myLogEditor.getValue(), EventLogConsole.this.myProjectModel.getProject());
            if (editorHyperlinkSupport == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLogConsole$2", "compute"));
            }
            return editorHyperlinkSupport;
        }
    };
    private final LogModel myProjectModel;

    EventLogConsole(LogModel model) {
        this.myProjectModel = model;
    }

    private Editor createLogEditor() {
        Project project = this.myProjectModel.getProject();
        final EditorEx editor = ConsoleViewUtil.setupConsoleEditor(project, false, false);
        this.myProjectModel.getProject().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerAdapter(){

            public void projectClosed(Project project) {
                if (project == EventLogConsole.this.myProjectModel.getProject()) {
                    EditorFactory.getInstance().releaseEditor(editor);
                }
            }
        });
        ((EditorMarkupModel)editor.getMarkupModel()).setErrorStripeVisible(true);
        final ClearLogAction clearLog = new ClearLogAction(this);
        clearLog.registerCustomShortcutSet(ActionManager.getInstance().getAction("ConsoleView.ClearAll").getShortcutSet(), editor.getContentComponent());
        editor.addEditorMouseListener((EditorMouseListener)new EditorPopupHandler(){

            @Override
            public void invokePopup(EditorMouseEvent event) {
                ActionManager actionManager = ActionManager.getInstance();
                ActionPopupMenu menu = actionManager.createActionPopupMenu("EditorPopup", (ActionGroup)EventLogConsole.this.createPopupActions(actionManager, clearLog));
                MouseEvent mouseEvent = event.getMouseEvent();
                menu.getComponent().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        return editor;
    }

    private DefaultActionGroup createPopupActions(ActionManager actionManager, ClearLogAction action) {
        AnAction[] children = ((ActionGroup)actionManager.getAction("ConsoleEditorPopupMenu")).getChildren(null);
        DefaultActionGroup group = new DefaultActionGroup(children);
        group.addSeparator();
        group.add((AnAction)action);
        return group;
    }

    void doPrintNotification(Notification notification) {
        Editor editor = (Editor)this.myLogEditor.getValue();
        if (editor.isDisposed()) {
            return;
        }
        Document document = editor.getDocument();
        boolean scroll = document.getTextLength() == editor.getCaretModel().getOffset() || !editor.getContentComponent().hasFocus();
        Long notificationTime = this.myProjectModel.getNotificationTime(notification);
        if (notificationTime == null) {
            return;
        }
        String date = DateFormatUtil.formatTimeWithSeconds((long)notificationTime) + " ";
        EventLogConsole.append(document, date);
        int startLine = document.getLineCount() - 1;
        EventLog.LogEntry pair = EventLog.formatForLog(notification, StringUtil.repeatSymbol((char)' ', (int)date.length()));
        NotificationType type = notification.getType();
        TextAttributesKey key = type == NotificationType.ERROR ? ConsoleViewContentType.LOG_ERROR_OUTPUT_KEY : (type == NotificationType.INFORMATION ? ConsoleViewContentType.NORMAL_OUTPUT_KEY : ConsoleViewContentType.LOG_WARNING_OUTPUT_KEY);
        int msgStart = document.getTextLength();
        String message = pair.message;
        EventLogConsole.append(document, message);
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(key);
        int layer = 1001;
        editor.getMarkupModel().addRangeHighlighter(msgStart, document.getTextLength(), layer, attributes, HighlighterTargetArea.EXACT_RANGE);
        for (Pair<TextRange, HyperlinkInfo> link : pair.links) {
            RangeHighlighter rangeHighlighter = ((EditorHyperlinkSupport)this.myHyperlinkSupport.getValue()).createHyperlink(((TextRange)link.first).getStartOffset() + msgStart, ((TextRange)link.first).getEndOffset() + msgStart, null, (HyperlinkInfo)link.second);
            if (!(link.second instanceof EventLog.ShowBalloon)) continue;
            ((EventLog.ShowBalloon)link.second).setRangeHighlighter(rangeHighlighter);
        }
        EventLogConsole.append(document, "\n");
        if (scroll) {
            editor.getCaretModel().moveToOffset(document.getTextLength());
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        if (notification.isImportant()) {
            this.highlightNotification(notification, pair.status, startLine, document.getLineCount() - 1);
        }
    }

    private void highlightNotification(Notification notification, String message, int line1, int line2) {
        final MarkupModel markupModel = ((Editor)this.myLogEditor.getValue()).getMarkupModel();
        TextAttributes bold = new TextAttributes(null, null, null, null, 1);
        final ArrayList<RangeHighlighter> lineColors = new ArrayList<RangeHighlighter>();
        for (int line = line1; line < line2; ++line) {
            RangeHighlighter lineHighlighter = markupModel.addLineHighlighter(line, 1001, bold);
            JBColor color = notification.getType() == NotificationType.ERROR ? JBColor.RED : (notification.getType() == NotificationType.WARNING ? JBColor.YELLOW : JBColor.GREEN);
            lineHighlighter.setErrorStripeMarkColor((Color)color);
            lineHighlighter.setErrorStripeTooltip((Object)message);
            lineColors.add(lineHighlighter);
        }
        final Document document = ((Editor)this.myLogEditor.getValue()).getDocument();
        Runnable removeHandler = new Runnable(){

            @Override
            public void run() {
                TextAttributes expired = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(ConsoleViewContentType.LOG_EXPIRED_ENTRY);
                TextAttributes italic = new TextAttributes(null, null, null, null, 2);
                for (RangeHighlighter colorHighlighter : lineColors) {
                    if (colorHighlighter.isValid()) {
                        int line = document.getLineNumber(colorHighlighter.getStartOffset());
                        markupModel.addLineHighlighter(line, 1001, expired);
                        for (RangeHighlighter highlighter : ((EditorHyperlinkSupport)EventLogConsole.this.myHyperlinkSupport.getValue()).findAllHyperlinksOnLine(line)) {
                            markupModel.addRangeHighlighter(highlighter.getStartOffset(), highlighter.getEndOffset(), 1002, italic, HighlighterTargetArea.EXACT_RANGE);
                            ((EditorHyperlinkSupport)EventLogConsole.this.myHyperlinkSupport.getValue()).removeHyperlink(highlighter);
                        }
                    }
                    markupModel.removeHighlighter(colorHighlighter);
                }
            }
        };
        if (!notification.isExpired()) {
            this.myProjectModel.removeHandlers.put(notification, removeHandler);
        } else {
            removeHandler.run();
        }
    }

    public Editor getConsoleEditor() {
        return (Editor)this.myLogEditor.getValue();
    }

    @Nullable
    public RelativePoint getRangeHighlighterLocation(RangeHighlighter range) {
        Editor editor = (Editor)this.myLogEditor.getValue();
        Project project = editor.getProject();
        Window window = NotificationsManagerImpl.findWindowForBalloon(project);
        if (range != null && window != null) {
            Point point = editor.visualPositionToXY(editor.offsetToVisualPosition(range.getStartOffset()));
            return new RelativePoint((Component)window, SwingUtilities.convertPoint(editor.getContentComponent(), point, window));
        }
        return null;
    }

    private static void append(Document document, String s) {
        document.insertString(document.getTextLength(), (CharSequence)s);
    }

    public static class ClearLogAction
    extends DumbAwareAction {
        private EventLogConsole myConsole;

        public ClearLogAction(EventLogConsole console) {
            super("Clear All", "Clear the contents of the Event Log", AllIcons.Actions.GC);
            this.myConsole = console;
        }

        public void update(AnActionEvent e) {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            e.getPresentation().setEnabled(editor != null && editor.getDocument().getTextLength() > 0);
        }

        public void actionPerformed(AnActionEvent e) {
            LogModel model = this.myConsole.myProjectModel;
            for (Notification notification : model.getNotifications()) {
                notification.expire();
                model.removeNotification(notification);
            }
            model.setStatusMessage(null, 0L);
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != null) {
                editor.getDocument().deleteString(0, editor.getDocument().getTextLength());
            }
        }
    }
}

