/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.stores.BaseFileConfigurableStoreImpl;
import com.intellij.openapi.components.impl.stores.ProjectStateStorageManager;
import com.intellij.openapi.components.impl.stores.ProjectStoreImpl;
import com.intellij.openapi.components.impl.stores.ProjectWithModulesStoreImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.convertors.Convertor01;
import com.intellij.openapi.project.impl.convertors.Convertor12;
import com.intellij.openapi.project.impl.convertors.Convertor23;
import com.intellij.openapi.project.impl.convertors.Convertor34;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

class IdeaProjectStoreImpl
extends ProjectWithModulesStoreImpl {
    public IdeaProjectStoreImpl(@NotNull ProjectImpl project, @NotNull PathMacroManager pathMacroManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/IdeaProjectStoreImpl", "<init>"));
        }
        if (pathMacroManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathMacroManager", "com/intellij/openapi/components/impl/stores/IdeaProjectStoreImpl", "<init>"));
        }
        super(project, pathMacroManager);
    }

    @Override
    @NotNull
    protected StateStorageManager createStateStorageManager() {
        ProjectStateStorageManager projectStateStorageManager = new ProjectStateStorageManager(this.myPathMacroManager.createTrackingSubstitutor(), this.myProject){

            @Override
            public StorageData createIprStorageData(@NotNull String filePath) {
                if (filePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/components/impl/stores/IdeaProjectStoreImpl$1", "createIprStorageData"));
                }
                return new IdeaIprStorageData("project", this.myProject, filePath);
            }
        };
        if (projectStateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/IdeaProjectStoreImpl", "createStateStorageManager"));
        }
        return projectStateStorageManager;
    }

    private static class IdeaIprStorageData
    extends ProjectStoreImpl.IprStorageData {
        private final String myFilePath;

        public IdeaIprStorageData(@NotNull String rootElementName, @NotNull Project project, @NotNull String filePath) {
            if (rootElementName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElementName", "com/intellij/openapi/components/impl/stores/IdeaProjectStoreImpl$IdeaIprStorageData", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/IdeaProjectStoreImpl$IdeaIprStorageData", "<init>"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/components/impl/stores/IdeaProjectStoreImpl$IdeaIprStorageData", "<init>"));
            }
            super(rootElementName, project);
            this.myFilePath = filePath;
        }

        private IdeaIprStorageData(@NotNull IdeaIprStorageData storageData) {
            if (storageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/IdeaProjectStoreImpl$IdeaIprStorageData", "<init>"));
            }
            super(storageData);
            this.myFilePath = storageData.myFilePath;
        }

        @Override
        public StorageData clone() {
            return new IdeaIprStorageData(this);
        }

        @Override
        protected void convert(Element root, int originalVersion) {
            if (originalVersion < 1) {
                Convertor01.execute(root);
            }
            if (originalVersion < 2) {
                Convertor12.execute(root);
            }
            if (originalVersion < 3) {
                Convertor23.execute(root);
            }
            if (originalVersion < 4) {
                Convertor34.execute(root, this.myFilePath, BaseFileConfigurableStoreImpl.getConversionProblemsStorage());
            }
        }
    }
}

