/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.MacUIUtil;

public class DeleteAction
extends EditorAction {
    public DeleteAction() {
        super((EditorActionHandler)new Handler());
    }

    private static int getCaretLineLength(Editor editor) {
        Document document = editor.getDocument();
        if (document.getLineCount() == 0) {
            return 0;
        }
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        if (lineNumber >= document.getLineCount()) {
            return 0;
        }
        return document.getLineEndOffset(lineNumber) - document.getLineStartOffset(lineNumber);
    }

    private static int getCaretLineStart(Editor editor) {
        Document document = editor.getDocument();
        if (document.getLineCount() == 0) {
            return 0;
        }
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        if (lineNumber >= document.getLineCount()) {
            return document.getLineStartOffset(document.getLineCount() - 1);
        }
        return document.getLineStartOffset(lineNumber);
    }

    public static void deleteCharAtCaret(Editor editor) {
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        int afterLineEnd = EditorModificationUtil.calcAfterLineEnd((Editor)editor);
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        if (afterLineEnd < 0 || offset < document.getTextLength() - 1 && editor.getSoftWrapModel().getSoftWrap(offset) != null) {
            FoldRegion region = editor.getFoldingModel().getCollapsedRegionAtOffset(offset);
            if (region != null && region.shouldNeverExpand()) {
                document.deleteString(region.getStartOffset(), region.getEndOffset());
                editor.getCaretModel().moveToOffset(region.getStartOffset());
            } else {
                document.deleteString(offset, offset + 1);
                editor.getCaretModel().moveToOffset(offset);
            }
            return;
        }
        if (lineNumber + 1 >= document.getLineCount()) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.setCurrentCommandGroupId(null);
        int nextLineStart = document.getLineStartOffset(lineNumber + 1);
        int nextLineEnd = document.getLineEndOffset(lineNumber + 1);
        if (nextLineEnd - nextLineStart > 0) {
            StringBuilder buf = new StringBuilder();
            StringUtil.repeatSymbol((Appendable)buf, (char)' ', (int)afterLineEnd);
            document.insertString(DeleteAction.getCaretLineStart(editor) + DeleteAction.getCaretLineLength(editor), (CharSequence)buf.toString());
            nextLineStart = document.getLineStartOffset(lineNumber + 1);
        }
        int thisLineEnd = document.getLineEndOffset(lineNumber);
        document.deleteString(thisLineEnd, nextLineStart);
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            MacUIUtil.hideCursor();
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            CopyPasteManager.getInstance().stopKillRings();
            SelectionModel selectionModel = editor.getSelectionModel();
            if (!selectionModel.hasSelection()) {
                DeleteAction.deleteCharAtCaret(editor);
            } else {
                EditorModificationUtil.deleteSelectedText((Editor)editor);
            }
        }
    }
}

