/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public class CallCommand
extends AbstractCommand {
    public static final String PREFIX = "%call";

    public CallCommand(String text, int line) {
        super(text, line, true);
    }

    @Override
    protected ActionCallback _execute(final PlaybackContext context) {
        final ActionCallback cmdResult = new ActionCallback();
        String cmd = this.getText().substring(PREFIX.length()).trim();
        int open = cmd.indexOf("(");
        if (open == -1) {
            context.error("( expected", this.getLine());
            return new ActionCallback.Done();
        }
        int close = cmd.lastIndexOf(")");
        if (close == -1) {
            context.error(") expected", this.getLine());
            return new ActionCallback.Done();
        }
        String methodName = cmd.substring(0, open);
        String[] args = cmd.substring(open + 1, close).split(",");
        boolean noArgs = args.length == 1 && args[0].length() == 0;
        Class[] types = noArgs ? new Class[1] : new Class[args.length + 1];
        types[0] = PlaybackContext.class;
        for (int i = 1; i < types.length; ++i) {
            types[i] = String.class;
        }
        try {
            Pair<Method, Class> methodClass = CallCommand.findMethod(context, methodName, types);
            if (methodClass == null) {
                context.error("No method \"" + methodName + "\" found in facade classes: " + context.getCallClasses(), this.getLine());
                return new ActionCallback.Rejected();
            }
            Method m = (Method)methodClass.getFirst();
            if (!m.getReturnType().isAssignableFrom(AsyncResult.class)) {
                context.error("Method " + methodClass.getSecond() + ":" + methodName + " must return AsyncResult object", this.getLine());
                return new ActionCallback.Rejected();
            }
            Object[] actualArgs = noArgs ? new Object[1] : new Object[args.length + 1];
            actualArgs[0] = context;
            System.arraycopy(args, 0, actualArgs, 1, actualArgs.length - 1);
            AsyncResult result = (AsyncResult)m.invoke(null, actualArgs);
            if (result == null) {
                context.error("Method " + methodClass.getSecond() + ":" + methodName + " must return AsyncResult object, but was null", this.getLine());
                return new ActionCallback.Rejected();
            }
            result.doWhenDone((Consumer)new Consumer<String>(){

                public void consume(String s) {
                    if (s != null) {
                        context.message(s, CallCommand.this.getLine());
                    }
                    cmdResult.setDone();
                }
            }).doWhenRejected((Consumer)new Consumer<String>(){

                public void consume(String s) {
                    context.error(s, CallCommand.this.getLine());
                    cmdResult.setRejected();
                }
            });
        }
        catch (InvocationTargetException ignored) {
            context.error("InvocationTargetException while executing command: " + cmd, this.getLine());
        }
        catch (IllegalAccessException ignored) {
            context.error("IllegalAccessException while executing command: " + cmd, this.getLine());
        }
        return cmdResult;
    }

    private static Pair<Method, Class> findMethod(PlaybackContext context, String methodName, Class[] types) {
        Set<Class> classes = context.getCallClasses();
        for (Class eachClass : classes) {
            try {
                Method method = eachClass.getMethod(methodName, types);
                return Pair.create((Object)method, (Object)eachClass);
            }
            catch (NoSuchMethodException ignored) {
            }
        }
        return null;
    }
}

