/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.FileStatusManagerImpl;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsFileStatusProvider
implements FileStatusProvider,
VcsBaseContentProvider {
    private final Project myProject;
    private final FileStatusManagerImpl myFileStatusManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final ChangeListManager myChangeListManager;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final VcsConfiguration myConfiguration;
    private boolean myHaveEmptyContentRevisions;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.VcsFileStatusProvider");

    public VcsFileStatusProvider(Project project, FileStatusManagerImpl fileStatusManager, ProjectLevelVcsManager vcsManager, ChangeListManager changeListManager, VcsDirtyScopeManager dirtyScopeManager, VcsConfiguration configuration) {
        this.myProject = project;
        this.myFileStatusManager = fileStatusManager;
        this.myVcsManager = vcsManager;
        this.myChangeListManager = changeListManager;
        this.myDirtyScopeManager = dirtyScopeManager;
        this.myConfiguration = configuration;
        this.myHaveEmptyContentRevisions = true;
        this.myFileStatusManager.setFileStatusProvider(this);
        changeListManager.addChangeListListener((ChangeListListener)new ChangeListAdapter(){

            public void changeListAdded(ChangeList list) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListRemoved(ChangeList list) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListChanged(ChangeList list) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListUpdateDone() {
                if (VcsFileStatusProvider.this.myHaveEmptyContentRevisions) {
                    VcsFileStatusProvider.this.myHaveEmptyContentRevisions = false;
                    VcsFileStatusProvider.this.fileStatusesChanged();
                }
            }

            public void unchangedFileStatusChanged() {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }
        });
    }

    private void fileStatusesChanged() {
        this.myFileStatusManager.fileStatusesChanged();
    }

    @Override
    @NotNull
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/VcsFileStatusProvider", "getFileStatus"));
        }
        AbstractVcs vcs = this.myVcsManager.getVcsFor(virtualFile);
        if (vcs == null) {
            FileStatus fileStatus = FileStatusManagerImpl.getDefaultStatus(virtualFile);
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsFileStatusProvider", "getFileStatus"));
            }
            return fileStatus;
        }
        FileStatus status = this.myChangeListManager.getStatus(virtualFile);
        if (status == FileStatus.NOT_CHANGED && VcsFileStatusProvider.isDocumentModified(virtualFile)) {
            FileStatus fileStatus = FileStatus.MODIFIED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsFileStatusProvider", "getFileStatus"));
            }
            return fileStatus;
        }
        if (status == FileStatus.NOT_CHANGED) {
            FileStatus fileStatus = FileStatusManagerImpl.getDefaultStatus(virtualFile);
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsFileStatusProvider", "getFileStatus"));
            }
            return fileStatus;
        }
        FileStatus fileStatus = status;
        if (fileStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsFileStatusProvider", "getFileStatus"));
        }
        return fileStatus;
    }

    private static boolean isDocumentModified(VirtualFile virtualFile) {
        if (virtualFile.isDirectory()) {
            return false;
        }
        return FileDocumentManager.getInstance().isFileModified(virtualFile);
    }

    @Override
    public void refreshFileStatusFromDocument(@NotNull VirtualFile virtualFile, @NotNull Document doc) {
        FileStatus cachedStatus;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/VcsFileStatusProvider", "refreshFileStatusFromDocument"));
        }
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/openapi/vcs/impl/VcsFileStatusProvider", "refreshFileStatusFromDocument"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("refreshFileStatusFromDocument: file.getModificationStamp()=" + virtualFile.getModificationStamp() + ", document.getModificationStamp()=" + doc.getModificationStamp());
        }
        if ((cachedStatus = this.myFileStatusManager.getCachedStatus(virtualFile)) == null || cachedStatus == FileStatus.NOT_CHANGED || !VcsFileStatusProvider.isDocumentModified(virtualFile)) {
            RollbackEnvironment rollbackEnvironment;
            AbstractVcs vcs = this.myVcsManager.getVcsFor(virtualFile);
            if (vcs == null) {
                return;
            }
            if (cachedStatus == FileStatus.MODIFIED && !VcsFileStatusProvider.isDocumentModified(virtualFile) && !((ReadonlyStatusHandlerImpl)ReadonlyStatusHandlerImpl.getInstance((Project)this.myProject)).getState().SHOW_DIALOG && (rollbackEnvironment = vcs.getRollbackEnvironment()) != null) {
                rollbackEnvironment.rollbackIfUnchanged(virtualFile);
            }
            this.myFileStatusManager.fileStatusChanged(virtualFile);
            ChangeProvider cp = vcs.getChangeProvider();
            if (cp != null && cp.isModifiedDocumentTrackingRequired()) {
                this.myDirtyScopeManager.fileDirty(virtualFile);
            }
        }
    }

    @Override
    @NotNull
    public ThreeState getNotChangedDirectoryParentingStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/VcsFileStatusProvider", "getNotChangedDirectoryParentingStatus"));
        }
        ThreeState threeState = this.myConfiguration.SHOW_DIRTY_RECURSIVELY ? this.myChangeListManager.haveChangesUnder(virtualFile) : ThreeState.NO;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsFileStatusProvider", "getNotChangedDirectoryParentingStatus"));
        }
        return threeState;
    }

    @Override
    @Nullable
    public Pair<VcsRevisionNumber, String> getBaseRevision(final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/VcsFileStatusProvider", "getBaseRevision"));
        }
        Change change = ChangeListManager.getInstance((Project)this.myProject).getChange(file);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision instanceof BinaryContentRevision) {
                return null;
            }
            if (beforeRevision != null) {
                String content;
                try {
                    content = beforeRevision.getContent();
                }
                catch (VcsException ex) {
                    content = null;
                }
                if (content == null) {
                    this.myHaveEmptyContentRevisions = true;
                    return null;
                }
                return Pair.create((Object)beforeRevision.getRevisionNumber(), (Object)content);
            }
            return null;
        }
        if (VcsFileStatusProvider.isDocumentModified(file)) {
            String content = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    if (!file.isValid()) {
                        return null;
                    }
                    return ((Object)LoadTextUtil.loadText(file)).toString();
                }
            });
            if (content == null) {
                return null;
            }
            return Pair.create((Object)VcsRevisionNumber.NULL, (Object)content);
        }
        return null;
    }
}

