/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class NonPhysicalReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public NonPhysicalReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        LocalSearchScope currentScope;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/NonPhysicalReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/NonPhysicalReferenceSearcher", "processQuery"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        SearchScope scope = queryParameters.getScopeDeterminedByUser();
        PsiElement element = queryParameters.getElementToSearch();
        PsiFile containingFile = element.getContainingFile();
        if (NonPhysicalReferenceSearcher.isPhysicalAndNonScratch(containingFile) && !(scope instanceof GlobalSearchScope)) {
            return;
        }
        if (scope instanceof LocalSearchScope) {
            if (queryParameters.isIgnoreAccessScope()) {
                return;
            }
            currentScope = (LocalSearchScope)scope;
        } else {
            currentScope = null;
        }
        Project project = element.getProject();
        if (!project.isInitialized()) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile virtualFile : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
            PsiFile file;
            if (virtualFile.getFileType().isBinary() || NonPhysicalReferenceSearcher.isPhysicalAndNonScratch(file = psiManager.findFile(virtualFile))) continue;
            LocalSearchScope newScope = new LocalSearchScope((PsiElement)file);
            LocalSearchScope searchScope = currentScope == null ? newScope : newScope.intersectWith(currentScope);
            ReferencesSearch.searchOptimized((PsiElement)element, (SearchScope)searchScope, (boolean)true, (SearchRequestCollector)queryParameters.getOptimizer(), consumer);
        }
    }

    private static boolean isPhysicalAndNonScratch(PsiFile file) {
        if (file == null || file instanceof PsiCodeFragment) {
            return true;
        }
        return file.getViewProvider().isPhysical() && ScratchFileService.getInstance().getRootType(file.getVirtualFile()) == null;
    }
}

