/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.tokenizer.LanguageSpellchecking;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.SuppressibleSpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellCheckingInspection
extends LocalInspectionTool {
    public static final String SPELL_CHECKING_INSPECTION_TOOL_NAME = "SpellCheckingInspection";
    public boolean processCode = true;
    public boolean processLiterals = true;
    public boolean processComments = true;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = SpellCheckerBundle.message("spelling", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = SpellCheckerBundle.message("spellchecking.inspection.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        Language language;
        SpellcheckingStrategy strategy;
        if (element != null && (strategy = SpellCheckingInspection.getSpellcheckingStrategy(element, language = element.getLanguage())) instanceof SuppressibleSpellcheckingStrategy) {
            SuppressQuickFix[] suppressQuickFixArray = ((SuppressibleSpellcheckingStrategy)strategy).getSuppressActions(element, this.getShortName());
            if (suppressQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "getBatchSuppressActions"));
            }
            return suppressQuickFixArray;
        }
        SuppressQuickFix[] suppressQuickFixArray = super.getBatchSuppressActions(element);
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "getBatchSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    private static SpellcheckingStrategy getSpellcheckingStrategy(@NotNull PsiElement element, @NotNull Language language) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "getSpellcheckingStrategy"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "getSpellcheckingStrategy"));
        }
        for (SpellcheckingStrategy strategy : LanguageSpellchecking.INSTANCE.allForLanguage(language)) {
            if (!strategy.isMyContext(element)) continue;
            return strategy;
        }
        return null;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "isSuppressedFor"));
        }
        Language language = element.getLanguage();
        SpellcheckingStrategy strategy = SpellCheckingInspection.getSpellcheckingStrategy(element, language);
        if (strategy instanceof SuppressibleSpellcheckingStrategy) {
            return ((SuppressibleSpellcheckingStrategy)strategy).isSuppressedFor(element, this.getShortName());
        }
        return super.isSuppressedFor(element);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if (SPELL_CHECKING_INSPECTION_TOOL_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "getShortName"));
        }
        return SPELL_CHECKING_INSPECTION_TOOL_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = SpellCheckerManager.getHighlightDisplayLevel();
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "buildVisitor"));
        }
        final SpellCheckerManager manager = SpellCheckerManager.getInstance(holder.getProject());
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                ASTNode node = element.getNode();
                if (node == null) {
                    return;
                }
                Language language = element.getLanguage();
                IElementType elementType = node.getElementType();
                ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
                if (parserDefinition != null && (parserDefinition.getStringLiteralElements().contains(elementType) ? !SpellCheckingInspection.this.processLiterals : (parserDefinition.getCommentTokens().contains(elementType) ? !SpellCheckingInspection.this.processComments : !SpellCheckingInspection.this.processCode))) {
                    return;
                }
                SpellCheckingInspection.tokenize(element, language, new MyTokenConsumer(manager, holder, (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(language)));
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    public static void tokenize(@NotNull PsiElement element, @NotNull Language language, TokenConsumer consumer) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "tokenize"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "tokenize"));
        }
        SpellcheckingStrategy factoryByLanguage = SpellCheckingInspection.getSpellcheckingStrategy(element, language);
        if (factoryByLanguage == null) {
            return;
        }
        Tokenizer tokenizer = factoryByLanguage.getTokenizer(element);
        tokenizer.tokenize(element, consumer);
    }

    private static void addBatchDescriptor(PsiElement element, int offset, @NotNull TextRange textRange, @NotNull ProblemsHolder holder) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "addBatchDescriptor"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "addBatchDescriptor"));
        }
        SpellCheckerQuickFix[] fixes = SpellcheckingStrategy.getDefaultBatchFixes();
        ProblemDescriptor problemDescriptor = SpellCheckingInspection.createProblemDescriptor(element, offset, textRange, holder, fixes, false);
        holder.registerProblem(problemDescriptor);
    }

    private static void addRegularDescriptor(PsiElement element, int offset, @NotNull TextRange textRange, @NotNull ProblemsHolder holder, boolean useRename, String wordWithTypo) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "addRegularDescriptor"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "addRegularDescriptor"));
        }
        SpellcheckingStrategy strategy = SpellCheckingInspection.getSpellcheckingStrategy(element, element.getLanguage());
        SpellCheckerQuickFix[] fixes = strategy != null ? strategy.getRegularFixes(element, offset, textRange, useRename, wordWithTypo) : SpellcheckingStrategy.getDefaultRegularFixes(useRename, wordWithTypo);
        ProblemDescriptor problemDescriptor = SpellCheckingInspection.createProblemDescriptor(element, offset, textRange, holder, fixes, true);
        holder.registerProblem(problemDescriptor);
    }

    private static ProblemDescriptor createProblemDescriptor(PsiElement element, int offset, TextRange textRange, ProblemsHolder holder, SpellCheckerQuickFix[] fixes, boolean onTheFly) {
        String description = SpellCheckerBundle.message("typo.in.word.ref", new Object[0]);
        TextRange highlightRange = TextRange.from((int)(offset + textRange.getStartOffset()), (int)textRange.getLength());
        assert (highlightRange.getStartOffset() >= 0);
        return holder.getManager().createProblemDescriptor(element, highlightRange, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, (LocalQuickFix[])fixes);
    }

    public JComponent createOptionsPanel() {
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add((Component)new SingleCheckboxOptionsPanel(SpellCheckerBundle.message("process.code", new Object[0]), (InspectionProfileEntry)this, "processCode"));
        verticalBox.add((Component)new SingleCheckboxOptionsPanel(SpellCheckerBundle.message("process.literals", new Object[0]), (InspectionProfileEntry)this, "processLiterals"));
        verticalBox.add((Component)new SingleCheckboxOptionsPanel(SpellCheckerBundle.message("process.comments", new Object[0]), (InspectionProfileEntry)this, "processComments"));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)verticalBox, "North");
        return panel;
    }

    private static class MyTokenConsumer
    extends TokenConsumer
    implements Consumer<TextRange> {
        private final Set<String> myAlreadyChecked = new THashSet();
        private final SpellCheckerManager myManager;
        private final ProblemsHolder myHolder;
        private final NamesValidator myNamesValidator;
        private PsiElement myElement;
        private String myText;
        private boolean myUseRename;
        private int myOffset;

        public MyTokenConsumer(SpellCheckerManager manager, ProblemsHolder holder, NamesValidator namesValidator) {
            this.myManager = manager;
            this.myHolder = holder;
            this.myNamesValidator = namesValidator;
        }

        @Override
        public void consumeToken(PsiElement element, String text, boolean useRename, int offset, TextRange rangeToCheck, Splitter splitter) {
            this.myElement = element;
            this.myText = text;
            this.myUseRename = useRename;
            this.myOffset = offset;
            splitter.split(text, rangeToCheck, this);
        }

        public void consume(TextRange textRange) {
            String word = textRange.substring(this.myText);
            if (this.myHolder.isOnTheFly() && this.myAlreadyChecked.contains(word)) {
                return;
            }
            boolean keyword = this.myNamesValidator.isKeyword(word, this.myElement.getProject());
            if (keyword) {
                return;
            }
            boolean hasProblems = this.myManager.hasProblem(word);
            if (hasProblems) {
                if (this.myHolder.isOnTheFly()) {
                    SpellCheckingInspection.addRegularDescriptor(this.myElement, this.myOffset, textRange, this.myHolder, this.myUseRename, word);
                } else {
                    this.myAlreadyChecked.add(word);
                    SpellCheckingInspection.addBatchDescriptor(this.myElement, this.myOffset, textRange, this.myHolder);
                }
            }
        }
    }
}

