/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.SequentialTask;
import com.intellij.util.ui.UIUtil;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SequentialModalProgressTask
extends Task.Modal {
    private static final Logger LOG = Logger.getInstance((String)("#" + SequentialModalProgressTask.class.getName()));
    private static final long DEFAULT_MIN_ITERATION_MIN_TIME = 500L;
    private long myMinIterationTime;
    private final String myTitle;
    private ProgressIndicator myIndicator;
    private SequentialTask myTask;

    public SequentialModalProgressTask(@Nullable Project project, @NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/SequentialModalProgressTask", "<init>"));
        }
        this(project, title, true);
    }

    public SequentialModalProgressTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/SequentialModalProgressTask", "<init>"));
        }
        super(project, title, canBeCancelled);
        this.myMinIterationTime = 500L;
        this.myTitle = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/SequentialModalProgressTask", "run"));
        }
        try {
            this.doRun(indicator);
        }
        catch (Exception e) {
            LOG.info("Unexpected exception occurred during processing sequential task '" + this.myTitle + "'", (Throwable)e);
        }
        finally {
            indicator.stop();
        }
    }

    public void doRun(@NotNull ProgressIndicator indicator) throws InvocationTargetException, InterruptedException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/SequentialModalProgressTask", "doRun"));
        }
        final SequentialTask task = this.myTask;
        if (task == null) {
            return;
        }
        this.myIndicator = indicator;
        indicator.setIndeterminate(false);
        this.prepare(task);
        while (!task.isDone()) {
            if (indicator.isCanceled()) {
                task.stop();
                break;
            }
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    long start = System.currentTimeMillis();
                    try {
                        while (!task.isDone() && System.currentTimeMillis() - start < SequentialModalProgressTask.this.myMinIterationTime) {
                            task.iteration();
                        }
                    }
                    catch (RuntimeException e) {
                        task.stop();
                        throw e;
                    }
                }
            });
        }
    }

    public void setMinIterationTime(long minIterationTime) {
        this.myMinIterationTime = minIterationTime;
    }

    public void setTask(@Nullable SequentialTask task) {
        this.myTask = task;
    }

    @Nullable
    public ProgressIndicator getIndicator() {
        return this.myIndicator;
    }

    protected void prepare(@NotNull SequentialTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/SequentialModalProgressTask", "prepare"));
        }
        task.prepare();
    }
}

