/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.jetbrains.javascript.debugger.ExpressionInfoFactory;
import com.jetbrains.javascript.debugger.NameMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.MemberFilter;

public abstract class JavaScriptDebugAware {
    public static final ExtensionPointName<JavaScriptDebugAware> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.javaScriptDebugAware");

    @Nullable
    protected LanguageFileType getFileType() {
        return null;
    }

    @Nullable
    public Class<? extends XLineBreakpointType<?>> getBreakpointTypeClass() {
        return null;
    }

    public boolean isOnlySourceMappedBreakpoints() {
        return true;
    }

    public final boolean canGetEvaluationInfo(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/JavaScriptDebugAware", "canGetEvaluationInfo"));
        }
        return file.getFileType().equals(this.getFileType());
    }

    @Nullable
    public final ExpressionInfo getEvaluationInfo(@NotNull PsiFile file, int offset, @NotNull Document document, @NotNull ExpressionInfoFactory expressionInfoFactory) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/JavaScriptDebugAware", "getEvaluationInfo"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/javascript/debugger/JavaScriptDebugAware", "getEvaluationInfo"));
        }
        if (expressionInfoFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionInfoFactory", "com/jetbrains/javascript/debugger/JavaScriptDebugAware", "getEvaluationInfo"));
        }
        PsiElement element = file.findElementAt(offset);
        return element == null ? null : this.getEvaluationInfo(element, document, expressionInfoFactory);
    }

    @Nullable
    protected ExpressionInfo getEvaluationInfo(@NotNull PsiElement elementAtOffset, @NotNull Document document, @NotNull ExpressionInfoFactory expressionInfoFactory) {
        if (elementAtOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAtOffset", "com/jetbrains/javascript/debugger/JavaScriptDebugAware", "getEvaluationInfo"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/javascript/debugger/JavaScriptDebugAware", "getEvaluationInfo"));
        }
        if (expressionInfoFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionInfoFactory", "com/jetbrains/javascript/debugger/JavaScriptDebugAware", "getEvaluationInfo"));
        }
        return null;
    }

    public static boolean isBreakpointAware(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/jetbrains/javascript/debugger/JavaScriptDebugAware", "isBreakpointAware"));
        }
        return JavaScriptDebugAware.getBreakpointAware(fileType) != null;
    }

    @Nullable
    public static JavaScriptDebugAware getBreakpointAware(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/jetbrains/javascript/debugger/JavaScriptDebugAware", "getBreakpointAware"));
        }
        for (JavaScriptDebugAware debugAware : (JavaScriptDebugAware[])EP_NAME.getExtensions()) {
            if (debugAware.getBreakpointTypeClass() != null || !fileType.equals(debugAware.getFileType())) continue;
            return debugAware;
        }
        return null;
    }

    @Nullable
    public MemberFilter createMemberFilter(@Nullable NameMapper nameMapper, @NotNull PsiElement element, int end) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/javascript/debugger/JavaScriptDebugAware", "createMemberFilter"));
        }
        return null;
    }

    @Nullable
    public PsiElement getNavigationElementForSourcemapInspector(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/JavaScriptDebugAware", "getNavigationElementForSourcemapInspector"));
        }
        return null;
    }
}

