/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;

abstract class DelegatingHttpRequestHandlerBase
extends SimpleChannelInboundHandlerAdapter<FullHttpRequest> {
    DelegatingHttpRequestHandlerBase() {
    }

    @Override
    protected void messageReceived(ChannelHandlerContext context, FullHttpRequest message) throws Exception {
        if (BuiltInServer.LOG.isDebugEnabled()) {
            BuiltInServer.LOG.debug("IN HTTP: " + message.uri());
        }
        if (!this.process(context, message, new QueryStringDecoder(message.uri()))) {
            Responses.sendStatus(HttpResponseStatus.NOT_FOUND, context.channel(), (HttpRequest)message);
        }
    }

    protected abstract boolean process(@NotNull ChannelHandlerContext var1, @NotNull FullHttpRequest var2, @NotNull QueryStringDecoder var3) throws Exception;

    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/DelegatingHttpRequestHandlerBase", "exceptionCaught"));
        }
        if (cause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "org/jetbrains/io/DelegatingHttpRequestHandlerBase", "exceptionCaught"));
        }
        NettyUtil.logAndClose(cause, BuiltInServer.LOG, context.channel());
    }
}

