/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.parser;

import com.intellij.lexer.LexerBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;

public class ManifestLexer
extends LexerBase {
    private static final Map<Character, IElementType> SPECIAL_CHARACTERS_TOKEN_MAPPING = new HashMap<Character, IElementType>();
    private CharSequence myBuffer;
    private int myEndOffset;
    private int myTokenStart;
    private int myTokenEnd;
    private State myCurrentState;
    private IElementType myTokenType;

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/lang/manifest/parser/ManifestLexer", "start"));
        }
        this.myBuffer = buffer;
        this.myEndOffset = endOffset;
        this.myCurrentState = State.values()[initialState];
        this.myTokenStart = startOffset;
        this.parseNextToken();
    }

    public void advance() {
        this.myTokenStart = this.myTokenEnd;
        this.parseNextToken();
    }

    public int getState() {
        return this.myCurrentState.ordinal();
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myTokenType;
    }

    public int getTokenStart() {
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        return this.myTokenEnd;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/parser/ManifestLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    private void parseNextToken() {
        if (this.myTokenStart < this.myEndOffset) {
            if (this.isNewline(this.myTokenStart)) {
                this.myTokenType = this.isLineStart(this.myTokenStart) ? ManifestTokenType.SECTION_END : ManifestTokenType.NEWLINE;
                this.myTokenEnd = this.myTokenStart + 1;
                this.myCurrentState = State.INITIAL_STATE;
            } else if (this.myCurrentState == State.WAITING_FOR_HEADER_ASSIGNMENT_STATE) {
                if (this.isColon(this.myTokenStart)) {
                    this.myTokenType = ManifestTokenType.COLON;
                    this.myCurrentState = State.WAITING_FOR_SPACE_AFTER_HEADER_NAME_STATE;
                } else {
                    this.myTokenType = TokenType.BAD_CHARACTER;
                }
                this.myTokenEnd = this.myTokenStart + 1;
            } else if (this.myCurrentState == State.WAITING_FOR_SPACE_AFTER_HEADER_NAME_STATE) {
                if (this.isSpace(this.myTokenStart)) {
                    this.myTokenEnd = this.myTokenStart + 1;
                    this.myTokenType = ManifestTokenType.SIGNIFICANT_SPACE;
                } else {
                    this.myTokenEnd = this.myTokenStart;
                    while (this.myTokenEnd < this.myEndOffset && !this.isSpecialCharacter(this.myTokenEnd) && !this.isNewline(this.myTokenEnd)) {
                        ++this.myTokenEnd;
                    }
                    this.myTokenType = ManifestTokenType.HEADER_VALUE_PART;
                }
                this.myCurrentState = State.INITIAL_STATE;
            } else if (this.isHeaderStart(this.myTokenStart)) {
                if (this.isAlphaNum(this.myTokenStart)) {
                    this.myTokenEnd = this.myTokenStart + 1;
                    while (this.myTokenEnd < this.myEndOffset && this.isHeaderChar(this.myTokenEnd)) {
                        ++this.myTokenEnd;
                    }
                    this.myTokenType = ManifestTokenType.HEADER_NAME;
                    this.myCurrentState = State.WAITING_FOR_HEADER_ASSIGNMENT_STATE;
                } else {
                    this.myTokenEnd = this.myTokenStart + 1;
                    this.myTokenType = TokenType.BAD_CHARACTER;
                    this.myCurrentState = State.BROKEN_LINE;
                }
            } else if (this.isContinuationStart(this.myTokenStart)) {
                this.myTokenType = ManifestTokenType.SIGNIFICANT_SPACE;
                this.myTokenEnd = this.myTokenStart + 1;
                this.myCurrentState = State.INITIAL_STATE;
            } else if (this.myCurrentState == State.BROKEN_LINE) {
                this.myTokenEnd = this.myTokenStart + 1;
                this.myTokenType = TokenType.BAD_CHARACTER;
            } else if (this.isSpecialCharacter(this.myTokenStart)) {
                this.myTokenType = this.getTokenTypeForSpecialCharacter(this.myTokenStart);
                this.myTokenEnd = this.myTokenStart + 1;
                this.myCurrentState = State.INITIAL_STATE;
            } else {
                this.myTokenEnd = this.myTokenStart;
                while (this.myTokenEnd < this.myEndOffset && !this.isSpecialCharacter(this.myTokenEnd) && !this.isNewline(this.myTokenEnd)) {
                    ++this.myTokenEnd;
                }
                this.myTokenType = ManifestTokenType.HEADER_VALUE_PART;
            }
        } else {
            this.myTokenType = null;
            this.myTokenEnd = this.myTokenStart;
        }
    }

    private boolean isNewline(int position) {
        return this.myBuffer.charAt(position) == '\n';
    }

    private boolean isHeaderStart(int position) {
        return this.isLineStart(position) && !Character.isWhitespace(this.myBuffer.charAt(position));
    }

    private boolean isAlphaNum(int position) {
        return Character.isLetterOrDigit(this.myBuffer.charAt(position));
    }

    private boolean isHeaderChar(int position) {
        return this.isAlphaNum(position) || this.myBuffer.charAt(position) == '-' || this.myBuffer.charAt(position) == '_';
    }

    private boolean isContinuationStart(int position) {
        return this.isLineStart(position) && !this.isHeaderStart(position);
    }

    private boolean isLineStart(int position) {
        return position == 0 || this.isNewline(position - 1);
    }

    private boolean isSpace(int position) {
        return this.myBuffer.charAt(position) == ' ';
    }

    private boolean isColon(int position) {
        return this.myBuffer.charAt(position) == ':';
    }

    private boolean isSpecialCharacter(int position) {
        return SPECIAL_CHARACTERS_TOKEN_MAPPING.get(Character.valueOf(this.myBuffer.charAt(position))) != null;
    }

    private IElementType getTokenTypeForSpecialCharacter(int position) {
        return SPECIAL_CHARACTERS_TOKEN_MAPPING.get(Character.valueOf(this.myBuffer.charAt(position)));
    }

    static {
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(':'), ManifestTokenType.COLON);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(';'), ManifestTokenType.SEMICOLON);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(','), ManifestTokenType.COMMA);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf('='), ManifestTokenType.EQUALS);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf('('), ManifestTokenType.OPENING_PARENTHESIS_TOKEN);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(')'), ManifestTokenType.CLOSING_PARENTHESIS_TOKEN);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf('['), ManifestTokenType.OPENING_BRACKET_TOKEN);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(']'), ManifestTokenType.CLOSING_BRACKET_TOKEN);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf('\"'), ManifestTokenType.QUOTE);
    }

    private static enum State {
        INITIAL_STATE,
        WAITING_FOR_HEADER_ASSIGNMENT_STATE,
        WAITING_FOR_SPACE_AFTER_HEADER_NAME_STATE,
        BROKEN_LINE;

    }
}

