/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.reflectasm;

import com.esotericsoftware.reflectasm.AccessClassLoader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldAccess {
    private String[] fieldNames;

    public int getIndex(String string) {
        int n = this.fieldNames.length;
        for (int i = 0; i < n; ++i) {
            if (!this.fieldNames[i].equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unable to find public field: " + string);
    }

    public void set(Object object, String string, Object object2) {
        this.set(object, this.getIndex(string), object2);
    }

    public Object get(Object object, String string) {
        return this.get(object, this.getIndex(string));
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public abstract void set(Object var1, int var2, Object var3);

    public abstract void setBoolean(Object var1, int var2, boolean var3);

    public abstract void setByte(Object var1, int var2, byte var3);

    public abstract void setShort(Object var1, int var2, short var3);

    public abstract void setInt(Object var1, int var2, int var3);

    public abstract void setLong(Object var1, int var2, long var3);

    public abstract void setDouble(Object var1, int var2, double var3);

    public abstract void setFloat(Object var1, int var2, float var3);

    public abstract void setChar(Object var1, int var2, char var3);

    public abstract Object get(Object var1, int var2);

    public abstract String getString(Object var1, int var2);

    public abstract char getChar(Object var1, int var2);

    public abstract boolean getBoolean(Object var1, int var2);

    public abstract byte getByte(Object var1, int var2);

    public abstract short getShort(Object var1, int var2);

    public abstract int getInt(Object var1, int var2);

    public abstract long getLong(Object var1, int var2);

    public abstract double getDouble(Object var1, int var2);

    public abstract float getFloat(Object var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static FieldAccess get(Class clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Class clazz3 = clazz; clazz3 != Object.class; clazz3 = clazz3.getSuperclass()) {
            for (Field clazz22 : clazz3.getDeclaredFields()) {
                int n = clazz22.getModifiers();
                if (Modifier.isStatic(n) || Modifier.isPrivate(n)) continue;
                arrayList.add(clazz22);
            }
        }
        Object[] objectArray = new String[arrayList.size()];
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = ((Field)arrayList.get(i)).getName();
        }
        String string = clazz.getName();
        String string2 = string + "FieldAccess";
        if (string2.startsWith("java.")) {
            string2 = "reflectasm." + string2;
        }
        Object var6_9 = null;
        AccessClassLoader accessClassLoader = AccessClassLoader.get(clazz);
        Object object = accessClassLoader;
        synchronized (object) {
            try {
                Class<?> clazz2 = accessClassLoader.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string3 = string2.replace('.', '/');
                String string4 = string.replace('.', '/');
                ClassWriter classWriter = new ClassWriter(0);
                classWriter.visit(196653, 33, string3, null, "com/esotericsoftware/reflectasm/FieldAccess", null);
                FieldAccess.insertConstructor(classWriter);
                FieldAccess.insertGetObject(classWriter, string4, arrayList);
                FieldAccess.insertSetObject(classWriter, string4, arrayList);
                FieldAccess.insertGetPrimitive(classWriter, string4, arrayList, Type.BOOLEAN_TYPE);
                FieldAccess.insertSetPrimitive(classWriter, string4, arrayList, Type.BOOLEAN_TYPE);
                FieldAccess.insertGetPrimitive(classWriter, string4, arrayList, Type.BYTE_TYPE);
                FieldAccess.insertSetPrimitive(classWriter, string4, arrayList, Type.BYTE_TYPE);
                FieldAccess.insertGetPrimitive(classWriter, string4, arrayList, Type.SHORT_TYPE);
                FieldAccess.insertSetPrimitive(classWriter, string4, arrayList, Type.SHORT_TYPE);
                FieldAccess.insertGetPrimitive(classWriter, string4, arrayList, Type.INT_TYPE);
                FieldAccess.insertSetPrimitive(classWriter, string4, arrayList, Type.INT_TYPE);
                FieldAccess.insertGetPrimitive(classWriter, string4, arrayList, Type.LONG_TYPE);
                FieldAccess.insertSetPrimitive(classWriter, string4, arrayList, Type.LONG_TYPE);
                FieldAccess.insertGetPrimitive(classWriter, string4, arrayList, Type.DOUBLE_TYPE);
                FieldAccess.insertSetPrimitive(classWriter, string4, arrayList, Type.DOUBLE_TYPE);
                FieldAccess.insertGetPrimitive(classWriter, string4, arrayList, Type.FLOAT_TYPE);
                FieldAccess.insertSetPrimitive(classWriter, string4, arrayList, Type.FLOAT_TYPE);
                FieldAccess.insertGetPrimitive(classWriter, string4, arrayList, Type.CHAR_TYPE);
                FieldAccess.insertSetPrimitive(classWriter, string4, arrayList, Type.CHAR_TYPE);
                FieldAccess.insertGetString(classWriter, string4, arrayList);
                classWriter.visitEnd();
                Class<?> clazz3 = accessClassLoader.defineClass(string2, classWriter.toByteArray());
            }
        }
        try {
            void var6_12;
            object = (FieldAccess)var6_12.newInstance();
            ((FieldAccess)object).fieldNames = objectArray;
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error constructing field access class: " + string2, exception);
        }
    }

    private static void insertConstructor(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "com/esotericsoftware/reflectasm/FieldAccess", "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
    }

    private static void insertSetObject(ClassWriter classWriter, String string, ArrayList<Field> arrayList) {
        int n = 6;
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "set", "(Ljava/lang/Object;ILjava/lang/Object;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(21, 2);
        if (!arrayList.isEmpty()) {
            --n;
            Label[] labelArray = new Label[arrayList.size()];
            int n2 = labelArray.length;
            for (int i = 0; i < n2; ++i) {
                labelArray[i] = new Label();
            }
            Label label = new Label();
            methodVisitor.visitTableSwitchInsn(0, labelArray.length - 1, label, labelArray);
            int n3 = labelArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Field field = arrayList.get(n2);
                Type type = Type.getType(field.getType());
                methodVisitor.visitLabel(labelArray[n2]);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, string);
                methodVisitor.visitVarInsn(25, 3);
                switch (type.getSort()) {
                    case 1: {
                        methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
                        methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                        break;
                    }
                    case 3: {
                        methodVisitor.visitTypeInsn(192, "java/lang/Byte");
                        methodVisitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                        break;
                    }
                    case 2: {
                        methodVisitor.visitTypeInsn(192, "java/lang/Character");
                        methodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                        break;
                    }
                    case 4: {
                        methodVisitor.visitTypeInsn(192, "java/lang/Short");
                        methodVisitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                        break;
                    }
                    case 5: {
                        methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                        methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                        break;
                    }
                    case 6: {
                        methodVisitor.visitTypeInsn(192, "java/lang/Float");
                        methodVisitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                        break;
                    }
                    case 7: {
                        methodVisitor.visitTypeInsn(192, "java/lang/Long");
                        methodVisitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                        break;
                    }
                    case 8: {
                        methodVisitor.visitTypeInsn(192, "java/lang/Double");
                        methodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                        break;
                    }
                    case 9: {
                        methodVisitor.visitTypeInsn(192, type.getDescriptor());
                        break;
                    }
                    case 10: {
                        methodVisitor.visitTypeInsn(192, type.getInternalName());
                    }
                }
                methodVisitor.visitFieldInsn(181, string, field.getName(), type.getDescriptor());
                methodVisitor.visitInsn(177);
            }
            methodVisitor.visitLabel(label);
            methodVisitor.visitFrame(3, 0, null, 0, null);
        }
        methodVisitor = FieldAccess.insertThrowExceptionForFieldNotFound(methodVisitor);
        methodVisitor.visitMaxs(n, 4);
        methodVisitor.visitEnd();
    }

    private static void insertGetObject(ClassWriter classWriter, String string, ArrayList<Field> arrayList) {
        int n = 6;
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "get", "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(21, 2);
        if (!arrayList.isEmpty()) {
            --n;
            Label[] labelArray = new Label[arrayList.size()];
            int n2 = labelArray.length;
            for (int i = 0; i < n2; ++i) {
                labelArray[i] = new Label();
            }
            Label label = new Label();
            methodVisitor.visitTableSwitchInsn(0, labelArray.length - 1, label, labelArray);
            int n3 = labelArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Field field = arrayList.get(n2);
                methodVisitor.visitLabel(labelArray[n2]);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, string);
                methodVisitor.visitFieldInsn(180, string, field.getName(), Type.getDescriptor(field.getType()));
                Type type = Type.getType(field.getType());
                switch (type.getSort()) {
                    case 1: {
                        methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                        break;
                    }
                    case 3: {
                        methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                        break;
                    }
                    case 2: {
                        methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                        break;
                    }
                    case 4: {
                        methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                        break;
                    }
                    case 5: {
                        methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                        break;
                    }
                    case 6: {
                        methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                        break;
                    }
                    case 7: {
                        methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                        break;
                    }
                    case 8: {
                        methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                    }
                }
                methodVisitor.visitInsn(176);
            }
            methodVisitor.visitLabel(label);
            methodVisitor.visitFrame(3, 0, null, 0, null);
        }
        FieldAccess.insertThrowExceptionForFieldNotFound(methodVisitor);
        methodVisitor.visitMaxs(n, 3);
        methodVisitor.visitEnd();
    }

    private static void insertGetString(ClassWriter classWriter, String string, ArrayList<Field> arrayList) {
        int n = 6;
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "getString", "(Ljava/lang/Object;I)Ljava/lang/String;", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(21, 2);
        if (!arrayList.isEmpty()) {
            --n;
            Label[] labelArray = new Label[arrayList.size()];
            Label label = new Label();
            boolean bl = false;
            int n2 = labelArray.length;
            for (int i = 0; i < n2; ++i) {
                if (arrayList.get(i).getType().equals(String.class)) {
                    labelArray[i] = new Label();
                    continue;
                }
                labelArray[i] = label;
                bl = true;
            }
            Label label2 = new Label();
            methodVisitor.visitTableSwitchInsn(0, labelArray.length - 1, label2, labelArray);
            int n3 = labelArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                if (labelArray[n2].equals(label)) continue;
                methodVisitor.visitLabel(labelArray[n2]);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, string);
                methodVisitor.visitFieldInsn(180, string, arrayList.get(n2).getName(), "Ljava/lang/String;");
                methodVisitor.visitInsn(176);
            }
            if (bl) {
                methodVisitor.visitLabel(label);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                FieldAccess.insertThrowExceptionForFieldType(methodVisitor, "String");
            }
            methodVisitor.visitLabel(label2);
            methodVisitor.visitFrame(3, 0, null, 0, null);
        }
        FieldAccess.insertThrowExceptionForFieldNotFound(methodVisitor);
        methodVisitor.visitMaxs(n, 3);
        methodVisitor.visitEnd();
    }

    private static void insertSetPrimitive(ClassWriter classWriter, String string, ArrayList<Field> arrayList, Type type) {
        int n;
        String string2;
        int n2 = 6;
        int n3 = 4;
        String string3 = type.getDescriptor();
        switch (type.getSort()) {
            case 1: {
                string2 = "setBoolean";
                n = 21;
                break;
            }
            case 3: {
                string2 = "setByte";
                n = 21;
                break;
            }
            case 2: {
                string2 = "setChar";
                n = 21;
                break;
            }
            case 4: {
                string2 = "setShort";
                n = 21;
                break;
            }
            case 5: {
                string2 = "setInt";
                n = 21;
                break;
            }
            case 6: {
                string2 = "setFloat";
                n = 23;
                break;
            }
            case 7: {
                string2 = "setLong";
                n = 22;
                ++n3;
                break;
            }
            case 8: {
                string2 = "setDouble";
                n = 24;
                ++n3;
                break;
            }
            default: {
                string2 = "set";
                n = 25;
            }
        }
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string2, "(Ljava/lang/Object;I" + string3 + ")V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(21, 2);
        if (!arrayList.isEmpty()) {
            --n2;
            Label[] labelArray = new Label[arrayList.size()];
            Label label = new Label();
            boolean bl = false;
            int n4 = labelArray.length;
            for (int i = 0; i < n4; ++i) {
                if (Type.getType(arrayList.get(i).getType()).equals((Object)type)) {
                    labelArray[i] = new Label();
                    continue;
                }
                labelArray[i] = label;
                bl = true;
            }
            Label label2 = new Label();
            methodVisitor.visitTableSwitchInsn(0, labelArray.length - 1, label2, labelArray);
            int n5 = labelArray.length;
            for (n4 = 0; n4 < n5; ++n4) {
                if (labelArray[n4].equals(label)) continue;
                methodVisitor.visitLabel(labelArray[n4]);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, string);
                methodVisitor.visitVarInsn(n, 3);
                methodVisitor.visitFieldInsn(181, string, arrayList.get(n4).getName(), string3);
                methodVisitor.visitInsn(177);
            }
            if (bl) {
                methodVisitor.visitLabel(label);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                FieldAccess.insertThrowExceptionForFieldType(methodVisitor, type.getClassName());
            }
            methodVisitor.visitLabel(label2);
            methodVisitor.visitFrame(3, 0, null, 0, null);
        }
        methodVisitor = FieldAccess.insertThrowExceptionForFieldNotFound(methodVisitor);
        methodVisitor.visitMaxs(n2, n3);
        methodVisitor.visitEnd();
    }

    private static void insertGetPrimitive(ClassWriter classWriter, String string, ArrayList<Field> arrayList, Type type) {
        int n;
        String string2;
        int n2 = 6;
        String string3 = type.getDescriptor();
        switch (type.getSort()) {
            case 1: {
                string2 = "getBoolean";
                n = 172;
                break;
            }
            case 3: {
                string2 = "getByte";
                n = 172;
                break;
            }
            case 2: {
                string2 = "getChar";
                n = 172;
                break;
            }
            case 4: {
                string2 = "getShort";
                n = 172;
                break;
            }
            case 5: {
                string2 = "getInt";
                n = 172;
                break;
            }
            case 6: {
                string2 = "getFloat";
                n = 174;
                break;
            }
            case 7: {
                string2 = "getLong";
                n = 173;
                break;
            }
            case 8: {
                string2 = "getDouble";
                n = 175;
                break;
            }
            default: {
                string2 = "get";
                n = 176;
            }
        }
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string2, "(Ljava/lang/Object;I)" + string3, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(21, 2);
        if (!arrayList.isEmpty()) {
            --n2;
            Label[] labelArray = new Label[arrayList.size()];
            Label label = new Label();
            boolean bl = false;
            int n3 = labelArray.length;
            for (int i = 0; i < n3; ++i) {
                if (Type.getType(arrayList.get(i).getType()).equals((Object)type)) {
                    labelArray[i] = new Label();
                    continue;
                }
                labelArray[i] = label;
                bl = true;
            }
            Label label2 = new Label();
            methodVisitor.visitTableSwitchInsn(0, labelArray.length - 1, label2, labelArray);
            int n4 = labelArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                Field field = arrayList.get(n3);
                if (labelArray[n3].equals(label)) continue;
                methodVisitor.visitLabel(labelArray[n3]);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, string);
                methodVisitor.visitFieldInsn(180, string, field.getName(), string3);
                methodVisitor.visitInsn(n);
            }
            if (bl) {
                methodVisitor.visitLabel(label);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                FieldAccess.insertThrowExceptionForFieldType(methodVisitor, type.getClassName());
            }
            methodVisitor.visitLabel(label2);
            methodVisitor.visitFrame(3, 0, null, 0, null);
        }
        methodVisitor = FieldAccess.insertThrowExceptionForFieldNotFound(methodVisitor);
        methodVisitor.visitMaxs(n2, 3);
        methodVisitor.visitEnd();
    }

    private static MethodVisitor insertThrowExceptionForFieldNotFound(MethodVisitor methodVisitor) {
        methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        methodVisitor.visitInsn(89);
        methodVisitor.visitTypeInsn(187, "java/lang/StringBuilder");
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)"Field not found: ");
        methodVisitor.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        methodVisitor.visitInsn(191);
        return methodVisitor;
    }

    private static MethodVisitor insertThrowExceptionForFieldType(MethodVisitor methodVisitor, String string) {
        methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        methodVisitor.visitInsn(89);
        methodVisitor.visitTypeInsn(187, "java/lang/StringBuilder");
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)("Field not declared as " + string + ": "));
        methodVisitor.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        methodVisitor.visitInsn(191);
        return methodVisitor;
    }
}

