/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.CvsInfo;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CvsRootOnFileSystem
extends CvsRootProvider {
    private final CvsConnectionSettings mySettings;

    private CvsRootOnFileSystem(CvsConnectionSettings cvsRoot, File fileRoot) {
        super(fileRoot, cvsRoot);
        this.mySettings = cvsRoot;
    }

    public static CvsRootOnFileSystem createMeOn(File file) throws CannotFindCvsRootException {
        File nearestRoot = CvsRootOnFileSystem.getRootFor(file);
        if (nearestRoot == null) {
            throw new CannotFindCvsRootException(file);
        }
        CvsConnectionSettings cvsRoot = CvsRootOnFileSystem.getCvsRootFor(nearestRoot);
        if (cvsRoot == CvsInfo.getAbsentSettings()) {
            throw new CannotFindCvsRootException(file);
        }
        File commonRoot = CvsRootOnFileSystem.getCommonRoot(nearestRoot, cvsRoot);
        return new CvsRootOnFileSystem(CvsRootOnFileSystem.getCvsEntriesManager().getCvsConnectionSettingsFor(commonRoot), commonRoot);
    }

    private static CvsEntriesManager getCvsEntriesManager() {
        return CvsEntriesManager.getInstance();
    }

    @Override
    public int hashCode() {
        return this.mySettings.hashCode() ^ this.getLocalRoot().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CvsRootOnFileSystem)) {
            return false;
        }
        CvsRootOnFileSystem other = (CvsRootOnFileSystem)obj;
        return this.mySettings.equals((Object)other.mySettings) && this.getLocalRoot().equals(other.getLocalRoot());
    }

    private static File getCommonRoot(File nearestRoot, CvsConnectionSettings cvsRoot) {
        File result = nearestRoot;
        if (result.getParentFile() == null) {
            return result;
        }
        while (cvsRoot.equals((Object)CvsRootOnFileSystem.getCvsRootFor(result.getParentFile()))) {
            if ((result = result.getParentFile()).getParentFile() != null) continue;
            return result;
        }
        return result;
    }

    private static CvsConnectionSettings getCvsRootFor(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cvsSupport2/connections/CvsRootOnFileSystem", "getCvsRootFor"));
        }
        return CvsRootOnFileSystem.getCvsEntriesManager().getCvsConnectionSettingsFor(file);
    }

    @Nullable
    private static File getRootFor(File file) {
        if (file == null) {
            return null;
        }
        if (!file.isDirectory()) {
            return CvsRootOnFileSystem.getRootFor(file.getParentFile());
        }
        if (CvsUtil.fileIsUnderCvs(file)) {
            return file;
        }
        return CvsRootOnFileSystem.getRootFor(file.getParentFile());
    }

    public String getRepository() {
        return this.myCvsEnvironment.getRepository();
    }

    public RevisionOrDate getRevisionOrDate() {
        return RevisionOrDate.EMPTY;
    }
}

