/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.stats.DistributionService;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.ChooseApiLevelDialog;
import com.android.tools.idea.wizard.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.FormFactorApiComboBox;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureFormFactorStep
extends DynamicWizardStepWithHeaderAndDescription {
    public static final String MIN_SDK_STRING = "Minimum SDK";
    private static final ScopedStateStore.Key<String> API_FEEDBACK_KEY = ScopedStateStore.createKey("API Feedback", ScopedStateStore.Scope.STEP, String.class);
    public static final ScopedStateStore.Key<Integer> NUM_ENABLED_FORM_FACTORS_KEY = ScopedStateStore.createKey("NumberOfEnabledFormFactors", ScopedStateStore.Scope.WIZARD, Integer.class);
    private JPanel myPanel;
    private JPanel myFormFactorPanel;
    private JBLabel myHelpMeChooseLabel;
    private List<FormFactorUtils.FormFactor> myFormFactors;
    private ChooseApiLevelDialog myChooseApiLevelDialog;
    private Disposable myDisposable;
    private Map<FormFactorUtils.FormFactor, FormFactorSdkControls> myFormFactorApiSelectors;

    public ConfigureFormFactorStep(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/wizard/ConfigureFormFactorStep", "<init>"));
        }
        super("Select the form factors your app will run on", "Different platforms require separate SDKs", disposable);
        this.$$$setupUI$$$();
        this.myHelpMeChooseLabel = new JBLabel("Help Me Choose");
        this.myFormFactors = Lists.newArrayList();
        this.myChooseApiLevelDialog = new ChooseApiLevelDialog(null, -1);
        this.myFormFactorApiSelectors = Maps.newHashMap();
        this.myDisposable = disposable;
        Disposer.register((Disposable)disposable, (Disposable)this.myChooseApiLevelDialog.getDisposable());
        this.setBodyComponent(this.myPanel);
    }

    @Override
    public void init() {
        super.init();
        this.myHelpMeChooseLabel.addMouseListener((MouseListener)new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ConfigureFormFactorStep.this.myChooseApiLevelDialog = new ChooseApiLevelDialog(null, ConfigureFormFactorStep.this.myState.get(FormFactorUtils.getMinApiLevelKey(FormFactorUtils.FormFactor.MOBILE)));
                Disposer.register((Disposable)ConfigureFormFactorStep.this.myDisposable, (Disposable)ConfigureFormFactorStep.this.myChooseApiLevelDialog.getDisposable());
                if (ConfigureFormFactorStep.this.myChooseApiLevelDialog.showAndGet()) {
                    int minApiLevel = ConfigureFormFactorStep.this.myChooseApiLevelDialog.getSelectedApiLevel();
                    ((FormFactorSdkControls)ConfigureFormFactorStep.this.myFormFactorApiSelectors.get(FormFactorUtils.FormFactor.MOBILE)).setSelectedItem(Integer.toString(minApiLevel));
                }
            }
        });
        this.myHelpMeChooseLabel.setMaximumSize(new Dimension(250, 200));
        this.register(API_FEEDBACK_KEY, this.myHelpMeChooseLabel, new ScopedDataBinder.ComponentBinding<String, JBLabel>(){

            @Override
            public void setValue(@Nullable String newValue, @NotNull JBLabel label) {
                if (label == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/wizard/ConfigureFormFactorStep$2", "setValue"));
                }
                final JBLabel referenceLabel = label;
                final String referenceString = newValue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        referenceLabel.setText(referenceString);
                    }
                });
            }
        });
        this.registerValueDeriver(API_FEEDBACK_KEY, new ScopedDataBinder.ValueDeriver<String>(){

            @Override
            @Nullable
            public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                return 3.makeSetOf(FormFactorUtils.getTargetComboBoxKey(FormFactorUtils.FormFactor.MOBILE));
            }

            @Override
            @Nullable
            public String deriveValue(ScopedStateStore state, ScopedStateStore.Key changedKey, @Nullable String currentValue) {
                FormFactorApiComboBox.AndroidTargetComboBoxItem selectedItem = state.get(FormFactorUtils.getTargetComboBoxKey(FormFactorUtils.FormFactor.MOBILE));
                if (selectedItem == null) {
                    return currentValue;
                }
                Integer selectedApi = selectedItem.apiLevel;
                float percentage = (float)(DistributionService.getInstance().getSupportedDistributionForApiLevel(selectedApi) * 100.0);
                return String.format(Locale.getDefault(), "<html>Lower API levels target more devices, but have fewer features available. By targeting API %1$d and later, your app will run on " + (percentage < 1.0f ? "&lt; 1%%" : String.format(Locale.getDefault(), "approximately <b>%.1f%%%%</b>", Float.valueOf(percentage))) + " of the devices that are active on the Google Play Store. " + "<span color=\"#%2$s\">Help me choose.</span></html>", selectedApi, Integer.toHexString(JBColor.blue.getRGB()).substring(2));
            }
        });
        this.populateAdditionalFormFactors();
    }

    private void populateAdditionalFormFactors() {
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        GridLayoutManager gridLayoutManager = new GridLayoutManager(applicationTemplates.size() * 2 + 1, 2);
        gridLayoutManager.setVGap(5);
        gridLayoutManager.setHGap(10);
        this.myFormFactorPanel.setLayout((LayoutManager)gridLayoutManager);
        GridConstraints c = new GridConstraints();
        c.setVSizePolicy(0);
        int row = 0;
        for (File templateFile : applicationTemplates) {
            FormFactorUtils.FormFactor formFactor;
            TemplateMetadata metadata = manager.getTemplate(templateFile);
            if (metadata == null || metadata.getFormFactor() == null || (formFactor = FormFactorUtils.FormFactor.get(metadata.getFormFactor())) == null) continue;
            this.myFormFactors.add(formFactor);
            c.setRow(row);
            c.setColumn(0);
            c.setFill(0);
            c.setAnchor(8);
            JCheckBox inclusionCheckBox = new JCheckBox(formFactor.toString());
            this.myFormFactorPanel.add((Component)inclusionCheckBox, c);
            this.register(FormFactorUtils.getInclusionKey(formFactor), inclusionCheckBox);
            FormFactorSdkControls controls = new FormFactorSdkControls(formFactor, metadata.getMinSdk());
            FormFactorApiComboBox minSdkComboBox = controls.getMinSdkCombo();
            minSdkComboBox.setName(formFactor.id + ".minSdk");
            controls.layout(this.myFormFactorPanel, ++row, inclusionCheckBox.getIconTextGap());
            minSdkComboBox.register(this);
            this.myFormFactorApiSelectors.put(formFactor, controls);
            if (minSdkComboBox.getItemCount() == 0) {
                inclusionCheckBox.setSelected(false);
                inclusionCheckBox.setEnabled(false);
                inclusionCheckBox.setText(inclusionCheckBox.getText() + " (Not Installed)");
            } else if (row == 1) {
                this.myState.put(FormFactorUtils.getInclusionKey(formFactor), true);
            }
            if (formFactor.equals(FormFactorUtils.FormFactor.MOBILE)) {
                c.setRow(++row);
                c.setColumn(1);
                c.setAnchor(9);
                c.setFill(0);
                this.myFormFactorPanel.add((Component)this.myHelpMeChooseLabel, c);
            }
            ++row;
        }
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        if (this.myState.containsKey(WizardConstants.NEWLY_INSTALLED_API_KEY)) {
            FormFactorApiComboBox.loadInstalledVersions();
        }
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        super.deriveValues(modified);
        int enabledFormFactors = 0;
        for (FormFactorUtils.FormFactor formFactor : this.myFormFactors) {
            Boolean included = this.myState.get(FormFactorUtils.getInclusionKey(formFactor));
            if (included == null) continue;
            if (this.myFormFactorApiSelectors.containsKey(formFactor)) {
                this.myFormFactorApiSelectors.get(formFactor).setEnabled(included);
            }
            if (!included.booleanValue()) continue;
            ++enabledFormFactors;
            FormFactorSdkControls controls = this.myFormFactorApiSelectors.get(formFactor);
            if (controls == null) continue;
            controls.getMinSdkCombo().deriveValues(this.myState, modified);
        }
        this.myState.put(NUM_ENABLED_FORM_FACTORS_KEY, enabledFormFactors);
    }

    @Override
    public boolean validate() {
        this.setErrorHtml("");
        Integer enabledFormFactors = this.myState.get(NUM_ENABLED_FORM_FACTORS_KEY);
        if (enabledFormFactors == null || enabledFormFactors < 1) {
            this.setErrorHtml("At least one form factor must be selected.");
            return false;
        }
        for (FormFactorUtils.FormFactor formFactor : this.myFormFactors) {
            Boolean included = this.myState.get(FormFactorUtils.getInclusionKey(formFactor));
            if (included == null || !included.booleanValue() || this.myState.get(FormFactorUtils.getMinApiKey(formFactor)) != null) continue;
            this.setErrorHtml("Each form factor must have a Minimum SDK level selected.");
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Configure Form Factors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureFormFactorStep", "getStepName"));
        }
        return "Configure Form Factors";
    }

    @Nullable
    public String getHelpText(@NotNull String param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/android/tools/idea/wizard/ConfigureFormFactorStep", "getHelpText"));
        }
        if (param.equals("minApi")) {
            return "Choose the lowest version of Android that your application will support. Lower API levels target more devices, but means fewer features are available. By targeting API 10 and later, you reach approximately 99% of the market.";
        }
        if (param.equals("targetApi")) {
            return "Choose the highest API level that the application is known to work with. This attribute informs the system that you have tested against the target version and the system should not enable any compatibility behaviors to maintain your app's forward-compatibility with the target version. The application is still able to run on older versions (down to minSdkVersion). Your application may look dated if you are not targeting the current version.";
        }
        if (param.equals("buildApi")) {
            return "Choose a target API to compile your code against, from your installed SDKs. This is typically the most recent version, or the first version that supports all the APIs you want to directly access without reflection.";
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel;
    }

    @Override
    @NotNull
    protected DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings getStepHeader() {
        DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings wizardStepHeaderSettings = DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createTitleOnlyHeader("Target Android Devices");
        if (wizardStepHeaderSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureFormFactorStep", "getStepHeader"));
        }
        return wizardStepHeaderSettings;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 5, 5, 5), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFormFactorPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(750, -1), new Dimension(750, -1)));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(1, 2, 1, 1, 0, 1, 7, 1, null, null, null));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static final class FormFactorSdkControls {
        private final JLabel myLabel = new JLabel("Minimum SDK");
        private final FormFactorApiComboBox myMinSdkCombobox;

        public FormFactorSdkControls(FormFactorUtils.FormFactor formFactor, int minApi) {
            this.myMinSdkCombobox = new FormFactorApiComboBox(formFactor, minApi);
        }

        public void setEnabled(boolean enabled) {
            for (JComponent component : ImmutableSet.of((Object)this.myLabel, (Object)this.myMinSdkCombobox)) {
                component.setEnabled(enabled);
            }
        }

        public void setSelectedItem(String item) {
            ScopedDataBinder.setSelectedItem(this.myMinSdkCombobox, item);
        }

        public JLabel getLabel() {
            return this.myLabel;
        }

        public FormFactorApiComboBox getMinSdkCombo() {
            return this.myMinSdkCombobox;
        }

        private void layout(JPanel panel, int row, int ident) {
            GridConstraints c = new GridConstraints();
            c.setVSizePolicy(0);
            c.setRow(row);
            c.setColumn(0);
            c.setFill(0);
            c.setAnchor(8);
            c.setRow(row);
            c.setIndent(ident);
            panel.add((Component)this.myLabel, c);
            c.setIndent(0);
            c.setColumn(1);
            c.setFill(1);
            panel.add((Component)this.myMinSdkCombobox, c);
        }
    }
}

