/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.sdk.Jdks;
import com.intellij.CommonBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.JavaDependentSdkType;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import icons.AndroidIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.sdk.AndroidNewSdkDialog;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkConfigurable;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkType
extends JavaDependentSdkType
implements JavaSdkType {
    @NonNls
    public static final String SDK_NAME = "Android SDK";
    @NonNls
    public static final String DEFAULT_EXTERNAL_DOCUMENTATION_URL = "http://developer.android.com/reference/";

    public AndroidSdkType() {
        super(SDK_NAME);
    }

    @Nullable
    public String getBinPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/sdk/AndroidSdkType", "getBinPath"));
        }
        Sdk internalJavaSdk = AndroidSdkType.getInternalJavaSdk(sdk);
        return internalJavaSdk == null ? null : JavaSdk.getInstance().getBinPath(internalJavaSdk);
    }

    @Nullable
    public String getToolsPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/sdk/AndroidSdkType", "getToolsPath"));
        }
        Sdk jdk = AndroidSdkType.getInternalJavaSdk(sdk);
        if (jdk != null && jdk.getVersionString() != null) {
            return JavaSdk.getInstance().getToolsPath(jdk);
        }
        return null;
    }

    @Nullable
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/sdk/AndroidSdkType", "getVMExecutablePath"));
        }
        Sdk internalJavaSdk = AndroidSdkType.getInternalJavaSdk(sdk);
        return internalJavaSdk == null ? null : JavaSdk.getInstance().getVMExecutablePath(internalJavaSdk);
    }

    public String suggestHomePath() {
        return null;
    }

    public boolean isValidSdkHome(String path) {
        return (Boolean)AndroidSdkType.validateAndroidSdk(path).getFirst();
    }

    @NotNull
    public static Pair<Boolean, String> validateAndroidSdk(@Nullable String path) {
        if (path == null) {
            Pair pair = Pair.create((Object)Boolean.FALSE, (Object)"");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkType", "validateAndroidSdk"));
            }
            return pair;
        }
        File f = new File(path = FileUtil.toSystemDependentName((String)path));
        if (!f.exists() || !f.isDirectory()) {
            Pair pair = Pair.create((Object)Boolean.FALSE, (Object)"SDK does not exist");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkType", "validateAndroidSdk"));
            }
            return pair;
        }
        File platformsDir = new File(f, "platforms");
        if (!platformsDir.exists() || !platformsDir.isDirectory()) {
            Pair pair = Pair.create((Object)Boolean.FALSE, (Object)"SDK does not contain any platforms");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkType", "validateAndroidSdk"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)Boolean.TRUE, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkType", "validateAndroidSdk"));
        }
        return pair;
    }

    public String getVersionString(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/sdk/AndroidSdkType", "getVersionString"));
        }
        Sdk internalJavaSdk = AndroidSdkType.getInternalJavaSdk(sdk);
        return internalJavaSdk != null ? internalJavaSdk.getVersionString() : null;
    }

    @Nullable
    public String suggestSdkName(String currentSdkName, String sdkHome) {
        return SDK_NAME;
    }

    public boolean setupSdkPaths(Sdk sdk, SdkModel sdkModel) {
        Sdk[] sdks;
        ArrayList<String> javaSdks = new ArrayList<String>();
        for (Sdk jdk : sdks = sdkModel.getSdks()) {
            if (!Jdks.isApplicableJdk(jdk)) continue;
            javaSdks.add(jdk.getName());
        }
        if (javaSdks.isEmpty()) {
            Messages.showErrorDialog((String)AndroidBundle.message("no.jdk.for.android.found.error", new Object[0]), (String)"No Java SDK Found");
            return false;
        }
        MessageBuildingSdkLog log = new MessageBuildingSdkLog();
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (sdkData == null) {
            String errorMessage = log.getErrorMessage().length() > 0 ? log.getErrorMessage() : AndroidBundle.message("cannot.parse.sdk.error", new Object[0]);
            Messages.showErrorDialog((String)errorMessage, (String)"SDK Parsing Error");
            return false;
        }
        IAndroidTarget[] targets = sdkData.getTargets();
        if (targets.length == 0) {
            if (Messages.showOkCancelDialog((String)AndroidBundle.message("no.android.targets.error", new Object[0]), (String)CommonBundle.getErrorTitle(), (String)"Open SDK Manager", (String)Messages.CANCEL_BUTTON, (Icon)Messages.getErrorIcon()) == 0) {
                RunAndroidSdkManagerAction.runSpecificSdkManager(null, sdkData.getLocation());
            }
            return false;
        }
        String[] targetNames = new String[targets.length];
        String newestPlatform = null;
        AndroidVersion version = null;
        for (int i = 0; i < targets.length; ++i) {
            String targetName;
            IAndroidTarget target = targets[i];
            targetNames[i] = targetName = AndroidSdkUtils.getTargetPresentableName(target);
            if (!target.isPlatform() || version != null && target.getVersion().compareTo(version) <= 0) continue;
            newestPlatform = targetName;
            version = target.getVersion();
        }
        AndroidNewSdkDialog dialog = new AndroidNewSdkDialog(null, javaSdks, (String)javaSdks.get(0), Arrays.asList(targetNames), newestPlatform != null ? newestPlatform : targetNames[0]);
        if (!dialog.showAndGet()) {
            return false;
        }
        String name = (String)javaSdks.get(dialog.getSelectedJavaSdkIndex());
        Sdk jdk = sdkModel.findSdk(name);
        IAndroidTarget target = targets[dialog.getSelectedTargetIndex()];
        String sdkName = AndroidSdkUtils.chooseNameForNewLibrary(target);
        AndroidSdkUtils.setUpSdk(sdk, sdkName, sdks, target, jdk, true);
        return true;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(SdkModel sdkModel, SdkModificator sdkModificator) {
        return new AndroidSdkConfigurable(sdkModel, sdkModificator);
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData data, @NotNull Element e) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/android/sdk/AndroidSdkType", "saveAdditionalData"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/sdk/AndroidSdkType", "saveAdditionalData"));
        }
        if (data instanceof AndroidSdkAdditionalData) {
            ((AndroidSdkAdditionalData)data).save(e);
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, Element additional) {
        if (currentSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSdk", "org/jetbrains/android/sdk/AndroidSdkType", "loadAdditionalData"));
        }
        return new AndroidSdkAdditionalData(currentSdk, additional);
    }

    public String getPresentableName() {
        return AndroidBundle.message("android.sdk.presentable.name", new Object[0]);
    }

    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    public Icon getIconForAddAction() {
        return this.getIcon();
    }

    @Nullable
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/sdk/AndroidSdkType", "getDefaultDocumentationUrl"));
        }
        return DEFAULT_EXTERNAL_DOCUMENTATION_URL;
    }

    public boolean isRootTypeApplicable(OrderRootType type) {
        return type == OrderRootType.CLASSES || type == OrderRootType.SOURCES || type == JavadocOrderRootType.getInstance() || type == AnnotationOrderRootType.getInstance();
    }

    @Nullable
    private static Sdk getInternalJavaSdk(Sdk sdk) {
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        if (data instanceof AndroidSdkAdditionalData) {
            return ((AndroidSdkAdditionalData)data).getJavaSdk();
        }
        return null;
    }

    public static AndroidSdkType getInstance() {
        return (AndroidSdkType)SdkType.findInstance(AndroidSdkType.class);
    }
}

