/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.usability.plugin;

import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.ReaderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.usability.plugin.Expression;
import org.apache.maven.usability.plugin.ExpressionDocumentation;
import org.apache.maven.usability.plugin.ExpressionDocumentationException;
import org.apache.maven.usability.plugin.io.xpp3.ParamdocXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ExpressionDocumenter {
    private static final String[] EXPRESSION_ROOTS = new String[]{"project", "settings", "session", "plugin", "rootless"};
    private static final String EXPRESSION_DOCO_ROOTPATH = "META-INF/maven/plugin-expressions/";
    private static Map expressionDocumentation;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map load() throws ExpressionDocumentationException {
        if (expressionDocumentation == null) {
            expressionDocumentation = new HashMap();
            ClassLoader docLoader = ExpressionDocumenter.initializeDocLoader();
            for (int i = 0; i < EXPRESSION_ROOTS.length; ++i) {
                InputStream docStream = null;
                try {
                    docStream = docLoader.getResourceAsStream(EXPRESSION_DOCO_ROOTPATH + EXPRESSION_ROOTS[i] + ".paramdoc.xml");
                    if (docStream != null) {
                        Map doco = ExpressionDocumenter.parseExpressionDocumentation(docStream);
                        expressionDocumentation.putAll(doco);
                    }
                }
                catch (IOException e) {
                    try {
                        throw new ExpressionDocumentationException("Failed to read documentation for expression root: " + EXPRESSION_ROOTS[i], e);
                        catch (XmlPullParserException e2) {
                            throw new ExpressionDocumentationException("Failed to parse documentation for expression root: " + EXPRESSION_ROOTS[i], e2);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(docStream);
                        throw throwable;
                    }
                }
                IOUtil.close(docStream);
            }
        }
        return expressionDocumentation;
    }

    private static Map parseExpressionDocumentation(InputStream docStream) throws IOException, XmlPullParserException {
        BufferedReader reader = new BufferedReader(ReaderFactory.newXmlReader(docStream));
        ParamdocXpp3Reader paramdocReader = new ParamdocXpp3Reader();
        ExpressionDocumentation documentation = paramdocReader.read(reader, true);
        List<Expression> expressions = documentation.getExpressions();
        HashMap<String, Expression> bySyntax = new HashMap<String, Expression>();
        if (expressions != null && !expressions.isEmpty()) {
            for (Expression expr : expressions) {
                bySyntax.put(expr.getSyntax(), expr);
            }
        }
        return bySyntax;
    }

    private static ClassLoader initializeDocLoader() throws ExpressionDocumentationException {
        URL docResource;
        String myResourcePath = ExpressionDocumenter.class.getName().replace('.', '/') + ".class";
        URL myResource = ExpressionDocumenter.class.getClassLoader().getResource(myResourcePath);
        String myClasspathEntry = myResource.getPath();
        if ((myClasspathEntry = myClasspathEntry.substring(0, myClasspathEntry.length() - (myResourcePath.length() + 2))).startsWith("file:")) {
            myClasspathEntry = myClasspathEntry.substring("file:".length());
        }
        try {
            docResource = new File(myClasspathEntry).toURL();
        }
        catch (MalformedURLException e) {
            throw new ExpressionDocumentationException("Cannot construct expression documentation classpath resource base.", e);
        }
        return new URLClassLoader(new URL[]{docResource});
    }
}

