/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.collectors;

import java.util.HashMap;
import java.util.Set;

public class BytecodeMappingTracer {
    private int current_sourceline;
    private HashMap<Integer, Integer> mapping = new HashMap();

    public BytecodeMappingTracer() {
    }

    public BytecodeMappingTracer(int initial_source_line) {
        this.current_sourceline = initial_source_line;
    }

    public void incrementSourceLine() {
        ++this.current_sourceline;
    }

    public void incrementSourceLine(int number_lines) {
        this.current_sourceline += number_lines;
    }

    public void addMapping(int bytecode_offset) {
        if (!this.mapping.containsKey(bytecode_offset)) {
            this.mapping.put(bytecode_offset, this.current_sourceline);
        }
    }

    public void addMapping(Set<Integer> bytecode_offsets) {
        if (bytecode_offsets != null) {
            for (Integer bytecode_offset : bytecode_offsets) {
                this.addMapping(bytecode_offset);
            }
        }
    }

    public HashMap<Integer, Integer> getMapping() {
        return this.mapping;
    }

    public int getCurrentSourceline() {
        return this.current_sourceline;
    }

    public void setCurrentSourceline(int current_sourceline) {
        this.current_sourceline = current_sourceline;
    }
}

