/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitCommit;
import git4idea.GitFileRevision;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleHandler;
import git4idea.history.GitChangeType;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogStatusInfo;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.browser.SHAHash;
import git4idea.history.browser.SymbolicRefs;
import git4idea.history.browser.SymbolicRefsI;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.log.GitRefManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHistoryUtils {
    public static final List<String> LOG_ALL = Arrays.asList("HEAD", "--branches", "--remotes", "--tags");
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.GitHistoryUtils");

    private GitHistoryUtils() {
    }

    @Nullable
    public static VcsRevisionNumber getCurrentRevision(@NotNull Project project, @NotNull FilePath filePath, @Nullable String branch) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getCurrentRevision"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitHistoryUtils", "getCurrentRevision"));
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters(!StringUtil.isEmpty((String)branch) ? branch : "--all");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        return new GitRevisionNumber(record.getHash(), record.getDate());
    }

    @Nullable
    public static VcsRevisionDescription getCurrentRevisionDescription(Project project, FilePath filePath, @Nullable String branch) throws VcsException {
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        if (branch != null && !branch.isEmpty()) {
            h.addParameters(branch);
        } else {
            h.addParameters("--all");
        }
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        String author = Comparing.equal((String)record.getAuthorName(), (String)record.getCommitterName()) ? record.getAuthorName() : record.getAuthorName() + " (" + record.getCommitterName() + ")";
        return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), record.getDate(), author, record.getFullMessage());
    }

    @Nullable
    public static ItemLatestState getLastRevision(Project project, FilePath filePath) throws VcsException {
        GitRemoteBranch t;
        VirtualFile root = GitUtil.getGitRoot(filePath);
        GitLocalBranch c = GitBranchUtil.getCurrentBranch(project, root);
        GitRemoteBranch gitRemoteBranch = t = c == null ? null : GitBranchUtil.tracked(project, root, c.getName());
        if (t == null) {
            return new ItemLatestState(GitHistoryUtils.getCurrentRevision(project, filePath, null), true, false);
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty(), "--name-status", t.getFullName());
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return null;
        }
        List<Change> changes = record.parseChanges(project, root);
        boolean exists = changes.isEmpty() || !FileStatus.DELETED.equals(changes.get(0).getFileStatus());
        record.setUsedHandler(h);
        return new ItemLatestState((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), exists, false);
    }

    public static void history(final Project project, FilePath path, @Nullable VirtualFile root, final Consumer<GitFileRevision> consumer, final Consumer<VcsException> exceptionConsumer, String ... parameters) {
        VirtualFile finalRoot;
        final FilePath filePath = GitHistoryUtils.getLastCommitName(project, path);
        try {
            finalRoot = root == null ? GitUtil.getGitRoot(filePath) : root;
        }
        catch (VcsException e) {
            exceptionConsumer.consume((Object)e);
            return;
        }
        GitLogParser logParser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.AUTHOR_TIME);
        final AtomicReference<String> firstCommit = new AtomicReference<String>("HEAD");
        final AtomicReference<String> firstCommitParent = new AtomicReference<String>("HEAD");
        final AtomicReference<FilePath> currentPath = new AtomicReference<FilePath>(filePath);
        final AtomicReference<GitLineHandler> logHandler = new AtomicReference<GitLineHandler>();
        final AtomicBoolean skipFurtherOutput = new AtomicBoolean();
        Consumer<GitLogRecord> resultAdapter = new Consumer<GitLogRecord>(){

            public void consume(GitLogRecord record) {
                if (skipFurtherOutput.get()) {
                    return;
                }
                if (record == null) {
                    exceptionConsumer.consume((Object)new VcsException("revision details are null."));
                    return;
                }
                record.setUsedHandler((GitHandler)logHandler.get());
                GitRevisionNumber revision = new GitRevisionNumber(record.getHash(), record.getDate());
                firstCommit.set(record.getHash());
                String[] parentHashes = record.getParentsHashes();
                if (parentHashes == null || parentHashes.length < 1) {
                    firstCommitParent.set(null);
                } else {
                    firstCommitParent.set(parentHashes[0]);
                }
                String message = record.getFullMessage();
                try {
                    List<FilePath> paths = record.getFilePaths(finalRoot);
                    FilePath revisionPath = paths.size() > 0 ? paths.get(0) : (FilePath)currentPath.get();
                    Couple authorPair = Couple.of((Object)record.getAuthorName(), (Object)record.getAuthorEmail());
                    Couple committerPair = record.getCommitterName() == null ? null : Couple.of((Object)record.getCommitterName(), (Object)record.getCommitterEmail());
                    List<String> parents = parentHashes == null ? Collections.emptyList() : Arrays.asList(parentHashes);
                    consumer.consume((Object)new GitFileRevision(project, revisionPath, revision, (Couple<Couple<String>>)Couple.of((Object)authorPair, (Object)committerPair), message, null, new Date(record.getAuthorTimeStamp()), parents));
                    List<GitLogStatusInfo> statusInfos = record.getStatusInfos();
                    if (statusInfos.isEmpty()) {
                        return;
                    }
                    if (statusInfos.get(0).getType() == GitChangeType.ADDED && !filePath.isDirectory()) {
                        skipFurtherOutput.set(true);
                    }
                }
                catch (VcsException e) {
                    exceptionConsumer.consume((Object)e);
                }
            }
        };
        AtomicBoolean criticalFailure = new AtomicBoolean();
        while (currentPath.get() != null && firstCommitParent.get() != null) {
            logHandler.set(GitHistoryUtils.getLogHandler(project, finalRoot, logParser, currentPath.get(), firstCommitParent.get(), parameters));
            final MyTokenAccumulator accumulator = new MyTokenAccumulator(logParser);
            Semaphore semaphore = new Semaphore();
            ((GitLineHandler)logHandler.get()).addLineListener(new GitLineHandlerAdapter((Consumer)resultAdapter, exceptionConsumer, criticalFailure, semaphore){
                final /* synthetic */ Consumer val$resultAdapter;
                final /* synthetic */ Consumer val$exceptionConsumer;
                final /* synthetic */ AtomicBoolean val$criticalFailure;
                final /* synthetic */ Semaphore val$semaphore;
                {
                    this.val$resultAdapter = consumer;
                    this.val$exceptionConsumer = consumer2;
                    this.val$criticalFailure = atomicBoolean;
                    this.val$semaphore = semaphore;
                }

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    GitLogRecord record = accumulator.acceptLine(line);
                    if (record != null) {
                        this.val$resultAdapter.consume((Object)record);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void startFailed(Throwable exception) {
                    try {
                        this.val$exceptionConsumer.consume((Object)new VcsException(exception));
                    }
                    finally {
                        this.val$criticalFailure.set(true);
                        this.val$semaphore.up();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void processTerminated(int exitCode) {
                    try {
                        super.processTerminated(exitCode);
                        GitLogRecord record = accumulator.processLast();
                        if (record != null) {
                            this.val$resultAdapter.consume((Object)record);
                        }
                    }
                    catch (Throwable t) {
                        LOG.error(t);
                        this.val$exceptionConsumer.consume((Object)new VcsException("Internal error " + t.getMessage(), t));
                        this.val$criticalFailure.set(true);
                    }
                    finally {
                        this.val$semaphore.up();
                    }
                }
            });
            semaphore.down();
            ((GitLineHandler)logHandler.get()).start();
            semaphore.waitFor();
            if (criticalFailure.get()) {
                return;
            }
            try {
                FilePath firstCommitRenamePath = GitHistoryUtils.getFirstCommitRenamePath(project, finalRoot, firstCommit.get(), currentPath.get());
                currentPath.set(firstCommitRenamePath);
                skipFurtherOutput.set(false);
            }
            catch (VcsException e) {
                LOG.warn("Tried to get first commit rename path", (Throwable)e);
                exceptionConsumer.consume((Object)e);
                return;
            }
        }
    }

    private static GitLineHandler getLogHandler(Project project, VirtualFile root, GitLogParser parser, FilePath path, String lastCommit, String ... parameters) {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        h.setStdoutSuppressed(true);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8", lastCommit);
        if (parameters != null && parameters.length > 0) {
            h.addParameters(parameters);
        }
        h.endOptions();
        h.addRelativePaths(path);
        return h;
    }

    @Nullable
    private static FilePath getFirstCommitRenamePath(Project project, VirtualFile root, String commit, FilePath filePath) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setStdoutSuppressed(true);
        h.addParameters("-M", "--name-status", parser.getPretty(), "--encoding=UTF-8", commit);
        h.endOptions();
        String output = h.run();
        List<GitLogRecord> records = parser.parse(output);
        if (records.isEmpty()) {
            return null;
        }
        List<Change> changes = records.get(0).parseChanges(project, root);
        for (Change change : changes) {
            if (!change.isMoved() && !change.isRenamed() || !filePath.equals(change.getAfterRevision().getFile())) continue;
            return change.getBeforeRevision().getFile();
        }
        return null;
    }

    public static List<? extends VcsShortCommitDetails> readMiniDetails(Project project, final VirtualFile root, List<String> hashes) throws VcsException {
        final VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return Collections.emptyList();
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--no-walk");
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(new ArrayList<String>(hashes));
        String output = h.run();
        List<GitLogRecord> records = parser.parse(output);
        return ContainerUtil.map(records, (Function)new Function<GitLogRecord, VcsShortCommitDetails>(){

            public VcsShortCommitDetails fun(GitLogRecord record) {
                SmartList parents = new SmartList();
                for (String parent : record.getParentsHashes()) {
                    parents.add(HashImpl.build((String)parent));
                }
                return factory.createShortDetails(HashImpl.build((String)record.getHash()), (List)parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
            }
        });
    }

    @Nullable
    public static List<VcsCommitMetadata> readLastCommits(@NotNull Project project, final @NotNull VirtualFile root, String ... refs) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "readLastCommits"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "readLastCommits"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "git4idea/history/GitHistoryUtils", "readLastCommits"));
        }
        final VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return null;
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--no-walk");
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(refs);
        String output = h.run();
        List<GitLogRecord> records = parser.parse(output);
        if (records.size() != refs.length) {
            return null;
        }
        return ContainerUtil.map(records, (Function)new Function<GitLogRecord, VcsCommitMetadata>(){

            public VcsCommitMetadata fun(GitLogRecord record) {
                return factory.createCommitMetadata(factory.createHash(record.getHash()), GitHistoryUtils.getParentHashes(factory, record), record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
            }
        });
    }

    public static void readCommits(@NotNull Project project, final @NotNull VirtualFile root, @NotNull List<String> parameters, final @NotNull Consumer<VcsUser> userConsumer, final @NotNull Consumer<VcsRef> refConsumer, final @NotNull Consumer<TimedVcsCommit> commitConsumer) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (userConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userConsumer", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (refConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refConsumer", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        final VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return;
        }
        int COMMIT_BUFFER = 1000;
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        final GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.REF_NAMES);
        h.setStdoutSuppressed(true);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters("--full-history");
        h.addParameters("--date-order");
        h.addParameters("--decorate=full");
        h.addParameters(parameters);
        h.endOptions();
        final StringBuilder record = new StringBuilder();
        final AtomicInteger records = new AtomicInteger();
        final Ref ex = new Ref();
        h.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                try {
                    String afterParseRemainder;
                    int recordEnd = line.indexOf("\u0003");
                    if (recordEnd == line.length() - 1) {
                        record.append(line);
                        afterParseRemainder = "";
                    } else if (recordEnd == -1) {
                        record.append(line);
                        afterParseRemainder = null;
                    } else {
                        record.append(line.substring(0, recordEnd + 1));
                        afterParseRemainder = line.substring(recordEnd + 1);
                    }
                    if (afterParseRemainder != null && records.incrementAndGet() > 1000) {
                        List commits = GitHistoryUtils.parseCommit(parser, record, (Consumer<VcsUser>)userConsumer, (Consumer<VcsRef>)refConsumer, factory, root);
                        for (TimedVcsCommit commit : commits) {
                            commitConsumer.consume((Object)commit);
                        }
                        record.setLength(0);
                        record.append(afterParseRemainder);
                    }
                }
                catch (Exception e) {
                    ex.set((Object)new VcsException((Throwable)e));
                }
            }

            public void processTerminated(int exitCode) {
                try {
                    List commits = GitHistoryUtils.parseCommit(parser, record, (Consumer<VcsUser>)userConsumer, (Consumer<VcsRef>)refConsumer, factory, root);
                    for (TimedVcsCommit commit : commits) {
                        commitConsumer.consume((Object)commit);
                    }
                }
                catch (Exception e) {
                    ex.set((Object)new VcsException((Throwable)e));
                }
            }

            public void startFailed(Throwable exception) {
                ex.set((Object)new VcsException(exception));
            }
        });
        h.runInCurrentThread(null);
        if (!ex.isNull()) {
            throw (VcsException)((Object)ex.get());
        }
    }

    @NotNull
    private static List<TimedVcsCommit> parseCommit(@NotNull GitLogParser parser, @NotNull StringBuilder record, final @NotNull Consumer<VcsUser> userRegistry, final @NotNull Consumer<VcsRef> refConsumer, final @NotNull VcsLogObjectsFactory factory, final @NotNull VirtualFile root) {
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (userRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userRegistry", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (refConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refConsumer", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        List<GitLogRecord> rec = parser.parse(record.toString());
        List list = ContainerUtil.mapNotNull(rec, (Function)new Function<GitLogRecord, TimedVcsCommit>(){

            public TimedVcsCommit fun(GitLogRecord record) {
                if (record == null) {
                    return null;
                }
                Pair pair = GitHistoryUtils.convert(record, factory, root);
                TimedVcsCommit commit = (TimedVcsCommit)pair.first;
                for (VcsRef ref : (Collection)pair.second) {
                    refConsumer.consume((Object)ref);
                }
                userRegistry.consume((Object)factory.createUser(record.getAuthorName(), record.getAuthorEmail()));
                return commit;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        return list;
    }

    @NotNull
    private static Pair<TimedVcsCommit, Collection<VcsRef>> convert(@NotNull GitLogRecord rec, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root) {
        if (rec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rec", "git4idea/history/GitHistoryUtils", "convert"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitHistoryUtils", "convert"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "convert"));
        }
        Hash hash = HashImpl.build((String)rec.getHash());
        List<Hash> parents = GitHistoryUtils.getParentHashes(factory, rec);
        TimedVcsCommit commit = factory.createTimedCommit(hash, parents, rec.getCommitTime());
        Pair pair = Pair.create((Object)commit, GitHistoryUtils.parseRefs(rec.getRefs(), hash, factory, root));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "convert"));
        }
        return pair;
    }

    @NotNull
    private static Collection<VcsRef> parseRefs(@NotNull Collection<String> refs, final @NotNull Hash hash, final @NotNull VcsLogObjectsFactory factory, final @NotNull VirtualFile root) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        List list = ContainerUtil.mapNotNull(refs, (Function)new Function<String, VcsRef>(){

            public VcsRef fun(String refName) {
                VcsRefType type = GitRefManager.getRefType(refName);
                refName = GitBranchUtil.stripRefsPrefix(refName);
                return factory.createRef(hash, refName, type, root);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        return list;
    }

    @Nullable
    private static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getObjectsFactoryWithDisposeCheck"));
        }
        return (VcsLogObjectsFactory)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VcsLogObjectsFactory>(){

            public VcsLogObjectsFactory compute() {
                if (!project.isDisposed()) {
                    return (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
                }
                return null;
            }
        });
    }

    public static List<VcsFileRevision> history(Project project, FilePath path) throws VcsException {
        VirtualFile root = GitUtil.getGitRoot(path);
        return GitHistoryUtils.history(project, path, root, new String[0]);
    }

    public static List<VcsFileRevision> history(Project project, FilePath path, VirtualFile root, String ... parameters) throws VcsException {
        final ArrayList<VcsFileRevision> rc = new ArrayList<VcsFileRevision>();
        final ArrayList exceptions = new ArrayList();
        GitHistoryUtils.history(project, path, root, new Consumer<GitFileRevision>(){

            public void consume(GitFileRevision gitFileRevision) {
                rc.add(gitFileRevision);
            }
        }, new Consumer<VcsException>(){

            public void consume(VcsException e) {
                exceptions.add(e);
            }
        }, parameters);
        if (!exceptions.isEmpty()) {
            throw (VcsException)((Object)exceptions.get(0));
        }
        return rc;
    }

    @Deprecated
    public static List<Pair<SHAHash, Date>> onlyHashesHistory(Project project, FilePath path, String ... parameters) throws VcsException {
        VirtualFile root = GitUtil.getGitRoot(path);
        return GitHistoryUtils.onlyHashesHistory(project, path, root, parameters);
    }

    public static List<Pair<SHAHash, Date>> onlyHashesHistory(Project project, FilePath path, VirtualFile root, String ... parameters) throws VcsException {
        path = GitHistoryUtils.getLastCommitName(project, path);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.endOptions();
        h.addRelativePaths(path);
        String output = h.run();
        ArrayList<Pair<SHAHash, Date>> rc = new ArrayList<Pair<SHAHash, Date>>();
        for (GitLogRecord record : parser.parse(output)) {
            record.setUsedHandler(h);
            rc.add((Pair<SHAHash, Date>)Pair.create((Object)new SHAHash(record.getHash()), (Object)record.getDate()));
        }
        return rc;
    }

    @NotNull
    public static VcsLogProvider.DetailedLogData loadMetadata(final @NotNull Project project, final @NotNull VirtualFile root, final boolean withRefs, String ... params) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "loadMetadata"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "loadMetadata"));
        }
        final VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "loadMetadata"));
            }
            return logDataImpl;
        }
        final HashSet refs = ContainerUtil.newHashSet();
        List<VcsCommitMetadata> commits = GitHistoryUtils.loadDetails(project, root, withRefs, false, new NullableFunction<GitLogRecord, VcsCommitMetadata>(){

            @Nullable
            public VcsCommitMetadata fun(GitLogRecord record) {
                GitCommit commit = GitHistoryUtils.createCommit(project, root, record, factory);
                if (withRefs) {
                    refs.addAll(GitHistoryUtils.parseRefs(record.getRefs(), commit.getId(), factory, root));
                }
                return commit;
            }
        }, params);
        LogDataImpl logDataImpl = new LogDataImpl((Set)refs, commits);
        if (logDataImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "loadMetadata"));
        }
        return logDataImpl;
    }

    @NotNull
    public static List<GitCommit> history(final @NotNull Project project, final @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "history"));
        }
        final VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List<GitCommit> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
            }
            return list;
        }
        List<GitCommit> list = GitHistoryUtils.loadDetails(project, root, false, true, new NullableFunction<GitLogRecord, GitCommit>(){

            @Nullable
            public GitCommit fun(GitLogRecord record) {
                return GitHistoryUtils.createCommit(project, root, record, factory);
            }
        }, parameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
        }
        return list;
    }

    @NotNull
    public static <T> List<T> loadDetails(@NotNull Project project, @NotNull VirtualFile root, boolean withRefs, boolean withChanges, @NotNull NullableFunction<GitLogRecord, T> converter, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser.NameStatus status = withChanges ? GitLogParser.NameStatus.STATUS : GitLogParser.NameStatus.NONE;
        GitLogParser.GitLogOption[] options = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY};
        if (withRefs) {
            options = (GitLogParser.GitLogOption[])ArrayUtil.append((Object[])options, (Object)((Object)GitLogParser.GitLogOption.REF_NAMES));
        }
        GitLogParser parser = new GitLogParser(project, status, options);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        if (withRefs) {
            h.addParameters("--decorate=full");
        }
        if (withChanges) {
            h.addParameters("-M", "--name-status", "-c");
        }
        h.endOptions();
        StopWatch sw = StopWatch.start((String)"loading details");
        String output = h.run();
        sw.report();
        sw = StopWatch.start((String)"parsing");
        List<GitLogRecord> records = parser.parse(output);
        sw.report();
        sw = StopWatch.start((String)"Creating objects");
        List commits = ContainerUtil.mapNotNull(records, converter);
        sw.report();
        List list = commits;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        return list;
    }

    private static GitCommit createCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLogRecord record, @NotNull VcsLogObjectsFactory factory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        List<Hash> parents = GitHistoryUtils.getParentHashes(factory, record);
        return new GitCommit(project, HashImpl.build((String)record.getHash()), parents, record.getCommitTime(), root, record.getSubject(), factory.createUser(record.getAuthorName(), record.getAuthorEmail()), record.getFullMessage(), factory.createUser(record.getCommitterName(), record.getCommitterEmail()), record.getAuthorTimeStamp(), record.getStatusInfos());
    }

    @NotNull
    private static List<Hash> getParentHashes(final @NotNull VcsLogObjectsFactory factory, @NotNull GitLogRecord record) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitHistoryUtils", "getParentHashes"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "git4idea/history/GitHistoryUtils", "getParentHashes"));
        }
        List list = ContainerUtil.map((Object[])record.getParentsHashes(), (Function)new Function<String, Hash>(){

            public Hash fun(String hash) {
                return factory.createHash(hash);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "getParentHashes"));
        }
        return list;
    }

    private static void takeLine(Project project, String line, StringBuilder sb, GitLogParser parser, SymbolicRefsI refs, VirtualFile root, VcsException[] exc, GitLineHandler h, AsynchConsumer<GitHeavyCommit> gitCommitConsumer) {
        GitHeavyCommit gitCommit;
        String text = sb.toString();
        sb.setLength(0);
        sb.append(line);
        if (text.length() == 0) {
            return;
        }
        GitLogRecord record = parser.parseOneRecord(text);
        try {
            gitCommit = GitHistoryUtils.createCommit(project, refs, root, record);
        }
        catch (VcsException e) {
            exc[0] = e;
            h.cancel();
            return;
        }
        gitCommitConsumer.consume((Object)gitCommit);
    }

    @NotNull
    private static GitHeavyCommit createCommit(@NotNull Project project, @Nullable SymbolicRefsI refs, @NotNull VirtualFile root, @NotNull GitLogRecord record) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        Collection<String> currentRefs = record.getRefs();
        ArrayList<String> locals = new ArrayList<String>();
        ArrayList<String> remotes = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        String s = GitHistoryUtils.parseRefs(refs, currentRefs, locals, remotes, tags);
        GitHeavyCommit gitCommit = new GitHeavyCommit(root, AbstractHash.create(record.getHash()), new SHAHash(record.getHash()), record.getAuthorName(), record.getCommitterName(), record.getDate(), record.getSubject(), record.getFullMessage(), new HashSet<String>(Arrays.asList(record.getParentsHashes())), record.getFilePaths(root), record.getAuthorEmail(), record.getCommitterEmail(), tags, locals, remotes, record.parseChanges(project, root), record.getAuthorTimeStamp());
        gitCommit.setCurrentBranch(s);
        GitHeavyCommit gitHeavyCommit = gitCommit;
        if (gitHeavyCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        return gitHeavyCommit;
    }

    @Nullable
    private static String parseRefs(@Nullable SymbolicRefsI refs, Collection<String> currentRefs, List<String> locals, List<String> remotes, List<String> tags) {
        if (refs == null) {
            return null;
        }
        for (String ref : currentRefs) {
            SymbolicRefs.Kind kind = refs.getKind(ref);
            if (SymbolicRefs.Kind.LOCAL.equals((Object)kind)) {
                locals.add(ref);
                continue;
            }
            if (SymbolicRefs.Kind.REMOTE.equals((Object)kind)) {
                remotes.add(ref);
                continue;
            }
            tags.add(ref);
        }
        if (refs.getCurrent() != null && currentRefs.contains(refs.getCurrent().getName())) {
            return refs.getCurrent().getName();
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static List<GitHeavyCommit> commitsDetails(@NotNull Project project, @NotNull FilePath path, @Nullable SymbolicRefsI refs, @NotNull Collection<String> commitsIds) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        if (commitsIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitsIds", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        path = GitHistoryUtils.getLastCommitName(project, path);
        VirtualFile root = GitUtil.getGitRoot(path);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.REF_NAMES, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters("--name-status", "-M", parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(new ArrayList<String>(commitsIds));
        String output = h.run();
        ArrayList<GitHeavyCommit> rc = new ArrayList<GitHeavyCommit>();
        for (GitLogRecord record : parser.parse(output)) {
            GitHeavyCommit gitCommit = GitHistoryUtils.createCommit(project, refs, root, record);
            rc.add(gitCommit);
        }
        ArrayList<GitHeavyCommit> arrayList = rc;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        return arrayList;
    }

    public static long getAuthorTime(Project project, FilePath path, String commitsId) throws VcsException {
        path = GitHistoryUtils.getLastCommitName(project, path);
        VirtualFile root = GitUtil.getGitRoot(path);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(commitsId);
        String output = h.run();
        GitLogRecord logRecord = parser.parseOneRecord(output);
        return logRecord.getAuthorTimeStamp();
    }

    public static FilePath getLastCommitName(@NotNull Project project, FilePath path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getLastCommitName"));
        }
        if (project.isDefault()) {
            return path;
        }
        ChangeListManager changeManager = ChangeListManager.getInstance((Project)project);
        Change change = changeManager.getChange(path);
        if (change != null && change.getType() == Change.Type.MOVED) {
            assert (change.getBeforeRevision() != null) : "Move change always have beforeRevision";
            path = change.getBeforeRevision().getFile();
        }
        return path;
    }

    @Nullable
    public static GitRevisionNumber getMergeBase(Project project, VirtualFile root, @NotNull String first, @NotNull String second) throws VcsException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "git4idea/history/GitHistoryUtils", "getMergeBase"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "git4idea/history/GitHistoryUtils", "getMergeBase"));
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.MERGE_BASE);
        h.setSilent(true);
        h.addParameters(first, second);
        String output = h.run().trim();
        if (output.length() == 0) {
            return null;
        }
        return GitRevisionNumber.resolve(project, root, output);
    }

    private static class MyTokenAccumulator {
        private final StringBuilder myBuffer = new StringBuilder();
        private boolean myNotStarted = true;
        private GitLogParser myParser;

        public MyTokenAccumulator(GitLogParser parser) {
            this.myParser = parser;
        }

        @Nullable
        public GitLogRecord acceptLine(String s) {
            boolean lineEnd = s.startsWith("\u0001");
            if (lineEnd && !this.myNotStarted) {
                String line = this.myBuffer.toString();
                this.myBuffer.setLength(0);
                this.myBuffer.append(s.substring("\u0001".length()));
                return this.processResult(line);
            }
            this.myBuffer.append(lineEnd ? s.substring("\u0001".length()) : s);
            this.myBuffer.append("\n");
            this.myNotStarted = false;
            return null;
        }

        public GitLogRecord processLast() {
            return this.processResult(this.myBuffer.toString());
        }

        private GitLogRecord processResult(String line) {
            return this.myParser.parseOneRecord(line);
        }
    }
}

