/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.FileCheckingInspection;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.JavaCreatePropertyFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvalidPropertyKeyInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.PROPERTIES_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = CodeInsightBundle.message((String)"inspection.unresolved.property.key.reference.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("UnresolvedPropertyKey" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection", "getShortName"));
        }
        return "UnresolvedPropertyKey";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection", "checkMethod"));
        }
        return InvalidPropertyKeyInspection.checkElement((PsiElement)method, manager, isOnTheFly);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection", "checkClass"));
        }
        PsiClassInitializer[] initializers = aClass.getInitializers();
        ArrayList result = new ArrayList();
        for (PsiClassInitializer initializer : initializers) {
            Object[] descriptors = InvalidPropertyKeyInspection.checkElement((PsiElement)initializer, manager, isOnTheFly);
            if (descriptors == null) continue;
            ContainerUtil.addAll(result, (Object[])descriptors);
        }
        return result.isEmpty() ? null : result.toArray(new ProblemDescriptor[result.size()]);
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection", "checkField"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection", "checkField"));
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        InvalidPropertyKeyInspection.appendProblems(manager, isOnTheFly, result, (PsiElement)field.getInitializer());
        InvalidPropertyKeyInspection.appendProblems(manager, isOnTheFly, result, (PsiElement)field.getModifierList());
        if (field instanceof PsiEnumConstant) {
            InvalidPropertyKeyInspection.appendProblems(manager, isOnTheFly, result, (PsiElement)((PsiEnumConstant)field).getArgumentList());
        }
        return result.isEmpty() ? null : result.toArray(new ProblemDescriptor[result.size()]);
    }

    private static void appendProblems(InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> result, PsiElement element) {
        ProblemDescriptor[] descriptors;
        if (element != null && (descriptors = InvalidPropertyKeyInspection.checkElement(element, manager, isOnTheFly)) != null) {
            Collections.addAll(result, descriptors);
        }
    }

    @Nullable
    private static ProblemDescriptor[] checkElement(PsiElement element, InspectionManager manager, boolean onTheFly) {
        UnresolvedPropertyVisitor visitor = new UnresolvedPropertyVisitor(manager, onTheFly);
        element.accept((PsiElementVisitor)visitor);
        List<ProblemDescriptor> problems = visitor.getProblems();
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        FileCheckingInspection[] fileCheckingInspections;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection", "checkFile"));
        }
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.invalidPropertyKeyInspectionTool");
        for (FileCheckingInspection obj : fileCheckingInspections = (FileCheckingInspection[])point.getExtensions()) {
            ProblemDescriptor[] descriptors = obj.checkFile(file, manager, isOnTheFly);
            if (descriptors == null) continue;
            return descriptors;
        }
        return null;
    }

    private static class UnresolvedPropertyVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final InspectionManager myManager;
        private final List<ProblemDescriptor> myProblems = new ArrayList<ProblemDescriptor>();
        private final boolean onTheFly;

        public UnresolvedPropertyVisitor(InspectionManager manager, boolean onTheFly) {
            this.myManager = manager;
            this.onTheFly = onTheFly;
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
            PsiExpressionList argList = aClass.getArgumentList();
            if (argList != null) {
                argList.accept((PsiElementVisitor)this);
            }
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitField(PsiField field) {
        }

        public void visitLiteralExpression(PsiLiteralExpression expression) {
            block8: {
                String key;
                block9: {
                    List propFiles;
                    block7: {
                        Object value = expression.getValue();
                        if (!(value instanceof String)) {
                            return;
                        }
                        key = (String)value;
                        if (UnresolvedPropertyVisitor.isComputablePropertyExpression((PsiExpression)expression)) {
                            return;
                        }
                        Ref resourceBundleName = new Ref();
                        if (JavaI18nUtil.isValidPropertyReference(this.myManager.getProject(), expression, key, (Ref<String>)resourceBundleName)) break block7;
                        String bundleName = (String)resourceBundleName.get();
                        if (bundleName == null) break block8;
                        UnresolvedPropertyVisitor.appendPropertyKeyNotFoundProblem(bundleName, key, expression, this.myManager, this.myProblems, this.onTheFly);
                        break block8;
                    }
                    if (!(expression.getParent() instanceof PsiNameValuePair)) break block9;
                    PsiNameValuePair nvp = (PsiNameValuePair)expression.getParent();
                    if (!Comparing.equal((String)nvp.getName(), (String)"resourceBundle")) break block8;
                    PropertiesReferenceManager manager = PropertiesReferenceManager.getInstance((Project)expression.getProject());
                    Module module = ModuleUtil.findModuleForPsiElement((PsiElement)expression);
                    if (module != null && (propFiles = manager.findPropertiesFiles(module, key)).isEmpty()) {
                        String description = CodeInsightBundle.message((String)"inspection.invalid.resource.bundle.reference", (Object[])new Object[]{key});
                        ProblemDescriptor problem = this.myManager.createProblemDescriptor((PsiElement)expression, description, (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, this.onTheFly);
                        this.myProblems.add(problem);
                    }
                    break block8;
                }
                if (expression.getParent() instanceof PsiExpressionList && expression.getParent().getParent() instanceof PsiMethodCallExpression) {
                    HashMap<String, Object> annotationParams = new HashMap<String, Object>();
                    annotationParams.put("resourceBundle", null);
                    if (!JavaI18nUtil.mustBePropertyKey(this.myManager.getProject(), expression, annotationParams)) {
                        return;
                    }
                    int paramsCount = JavaI18nUtil.getPropertyValueParamsMaxCount(expression);
                    if (paramsCount == -1) {
                        return;
                    }
                    PsiExpressionList expressions = (PsiExpressionList)expression.getParent();
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expressions.getParent();
                    PsiMethod method = methodCall.resolveMethod();
                    PsiExpression[] args = expressions.getExpressions();
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i] != expression) continue;
                        if (i + paramsCount < args.length || method == null || method.getParameterList().getParametersCount() != i + 2 || !method.getParameterList().getParameters()[i + 1].isVarArgs() || UnresolvedPropertyVisitor.hasArrayTypeAt(i + 1, methodCall)) break;
                        this.myProblems.add(this.myManager.createProblemDescriptor((PsiElement)methodCall, CodeInsightBundle.message((String)"property.has.more.parameters.than.passed", (Object[])new Object[]{key, paramsCount, args.length - i - 1}), this.onTheFly, new LocalQuickFix[0], ProblemHighlightType.GENERIC_ERROR));
                        break;
                    }
                }
            }
        }

        private static void appendPropertyKeyNotFoundProblem(@NotNull String bundleName, @NotNull String key, @NotNull PsiLiteralExpression expression, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> problems, boolean onTheFly) {
            if (bundleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleName", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection$UnresolvedPropertyVisitor", "appendPropertyKeyNotFoundProblem"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection$UnresolvedPropertyVisitor", "appendPropertyKeyNotFoundProblem"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection$UnresolvedPropertyVisitor", "appendPropertyKeyNotFoundProblem"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection$UnresolvedPropertyVisitor", "appendPropertyKeyNotFoundProblem"));
            }
            if (problems == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection$UnresolvedPropertyVisitor", "appendPropertyKeyNotFoundProblem"));
            }
            String description = CodeInsightBundle.message((String)"inspection.unresolved.property.key.reference.message", (Object[])new Object[]{key});
            List<PropertiesFile> propertiesFiles = UnresolvedPropertyVisitor.filterNotInLibrary(expression.getProject(), JavaI18nUtil.propertiesFilesByBundleName((String)bundleName, (PsiElement)expression));
            problems.add(manager.createProblemDescriptor((PsiElement)expression, description, (LocalQuickFix)(propertiesFiles.isEmpty() ? null : new JavaCreatePropertyFix((PsiElement)expression, key, propertiesFiles)), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly));
        }

        @NotNull
        private static List<PropertiesFile> filterNotInLibrary(@NotNull Project project, @NotNull List<PropertiesFile> propertiesFiles) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection$UnresolvedPropertyVisitor", "filterNotInLibrary"));
            }
            if (propertiesFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFiles", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection$UnresolvedPropertyVisitor", "filterNotInLibrary"));
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            ArrayList<PropertiesFile> result = new ArrayList<PropertiesFile>(propertiesFiles.size());
            for (PropertiesFile file : propertiesFiles) {
                if (fileIndex.isInLibraryClasses(file.getVirtualFile()) || fileIndex.isInLibrarySource(file.getVirtualFile())) continue;
                result.add(file);
            }
            ArrayList<PropertiesFile> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/InvalidPropertyKeyInspection$UnresolvedPropertyVisitor", "filterNotInLibrary"));
            }
            return arrayList;
        }

        private static boolean hasArrayTypeAt(int i, PsiMethodCallExpression methodCall) {
            return methodCall != null && methodCall.getArgumentList().getExpressionTypes().length > i && methodCall.getArgumentList().getExpressionTypes()[i] instanceof PsiArrayType;
        }

        private static boolean isComputablePropertyExpression(PsiExpression expression) {
            while (expression != null && expression.getParent() instanceof PsiParenthesizedExpression) {
                expression = (PsiExpression)expression.getParent();
            }
            return expression != null && expression.getParent() instanceof PsiExpression;
        }

        public List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }
    }
}

