/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProcessOutput {
    private final StringBuilder myStdoutBuilder = new StringBuilder();
    private final StringBuilder myStderrBuilder = new StringBuilder();
    private int myExitCode;
    private boolean myTimeout;
    private boolean myCancelled;

    public ProcessOutput() {
        this.myExitCode = -1;
    }

    public ProcessOutput(int exitCode) {
        this.myExitCode = exitCode;
    }

    public void appendStdout(String text) {
        this.myStdoutBuilder.append(text);
    }

    public void appendStderr(String text) {
        this.myStderrBuilder.append(text);
    }

    public String getStdout() {
        return this.myStdoutBuilder.toString();
    }

    public String getStderr() {
        return this.myStderrBuilder.toString();
    }

    public List<String> getStdoutLines() {
        return ProcessOutput.splitLines(this.getStdout());
    }

    public List<String> getStderrLines() {
        return ProcessOutput.splitLines(this.getStderr());
    }

    private static List<String> splitLines(String s) {
        String converted = StringUtil.convertLineSeparators((String)s);
        return StringUtil.split((String)converted, (String)"\n");
    }

    public boolean checkSuccess(@NotNull Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/execution/process/ProcessOutput", "checkSuccess"));
        }
        if (this.getExitCode() != 0 || this.isTimeout()) {
            logger.info(this.getStderr() + (this.isTimeout() ? "\nTimed out" : "\nExit code " + this.getExitCode()));
            return false;
        }
        return true;
    }

    public void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    public void setTimeout() {
        this.myTimeout = true;
    }

    public boolean isTimeout() {
        return this.myTimeout;
    }

    public void setCancelled() {
        this.myCancelled = true;
    }

    public boolean isCancelled() {
        return this.myCancelled;
    }
}

