/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Notifications {
    public static final Topic<Notifications> TOPIC = Topic.create((String)"Notifications", Notifications.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
    public static final String SYSTEM_MESSAGES_GROUP_ID = "System Messages";

    public void notify(@NotNull Notification var1);

    public void register(@NotNull String var1, @NotNull NotificationDisplayType var2);

    public void register(@NotNull String var1, @NotNull NotificationDisplayType var2, boolean var3);

    public void register(@NotNull String var1, @NotNull NotificationDisplayType var2, boolean var3, boolean var4);

    public static class Bus {
        public static void register(final @NotNull String group_id, final @NotNull NotificationDisplayType defaultDisplayType) {
            if (group_id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group_id", "com/intellij/notification/Notifications$Bus", "register"));
            }
            if (defaultDisplayType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultDisplayType", "com/intellij/notification/Notifications$Bus", "register"));
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Application app = ApplicationManager.getApplication();
                    if (!app.isDisposed()) {
                        ((Notifications)app.getMessageBus().syncPublisher(TOPIC)).register(group_id, defaultDisplayType);
                    }
                }
            });
        }

        public static void notify(@NotNull Notification notification) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/Notifications$Bus", "notify"));
            }
            Bus.notify(notification, null);
        }

        public static void notify(final @NotNull Notification notification, final @Nullable Project project) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/Notifications$Bus", "notify"));
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                Bus.doNotify(notification, project);
            } else {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Bus.doNotify(notification, project);
                    }
                });
            }
        }

        private static void doNotify(Notification notification, @Nullable Project project) {
            if (project != null && !project.isDisposed()) {
                ((Notifications)project.getMessageBus().syncPublisher(TOPIC)).notify(notification);
            } else {
                Application app = ApplicationManager.getApplication();
                if (!app.isDisposed()) {
                    ((Notifications)app.getMessageBus().syncPublisher(TOPIC)).notify(notification);
                }
            }
        }
    }
}

