/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.BuildNumber;
import java.awt.Rectangle;
import java.util.Calendar;

public abstract class ApplicationInfo {
    public abstract Calendar getBuildDate();

    public abstract BuildNumber getBuild();

    public abstract String getApiVersion();

    public abstract String getMajorVersion();

    public abstract String getMinorVersion();

    public abstract String getVersionName();

    public abstract String getHelpURL();

    public abstract String getCompanyName();

    public abstract String getCompanyURL();

    public abstract String getThirdPartySoftwareURL();

    public abstract Rectangle getAboutLogoRect();

    public abstract boolean hasHelp();

    public abstract boolean hasContextHelp();

    public String getFullVersion() {
        String majorVersion = this.getMajorVersion();
        if (majorVersion != null && majorVersion.trim().length() > 0) {
            String minorVersion = this.getMinorVersion();
            if (minorVersion != null && minorVersion.trim().length() > 0) {
                return majorVersion + "." + minorVersion;
            }
            return majorVersion + ".0";
        }
        return this.getVersionName();
    }

    public static ApplicationInfo getInstance() {
        return ApplicationManager.getApplication().getComponent(ApplicationInfo.class);
    }

    public static boolean helpAvailable() {
        return ApplicationManager.getApplication() != null && ApplicationInfo.getInstance() != null && ApplicationInfo.getInstance().hasHelp();
    }

    public static boolean contextHelpAvailable() {
        return ApplicationManager.getApplication() != null && ApplicationInfo.getInstance() != null && ApplicationInfo.getInstance().hasContextHelp();
    }

    public String getBuildNumber() {
        return this.getBuild().asString();
    }
}

