/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StdArrangementSettings
implements ArrangementSettings {
    @NotNull
    private final List<ArrangementSectionRule> mySectionRules;
    @NotNull
    private final List<ArrangementGroupingRule> myGroupings;
    @NotNull
    protected final List<StdArrangementMatchRule> myRulesByPriority;

    public StdArrangementSettings() {
        this.mySectionRules = new ArrayList<ArrangementSectionRule>();
        this.myGroupings = new ArrayList<ArrangementGroupingRule>();
        this.myRulesByPriority = new ArrayList<StdArrangementMatchRule>();
    }

    public StdArrangementSettings(@NotNull List<ArrangementSectionRule> rules) {
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rules", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "<init>"));
        }
        this(Collections.EMPTY_LIST, rules);
    }

    public StdArrangementSettings(@NotNull List<ArrangementGroupingRule> groupingRules, @NotNull List<ArrangementSectionRule> sectionRules) {
        if (groupingRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupingRules", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "<init>"));
        }
        if (sectionRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sectionRules", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "<init>"));
        }
        this.mySectionRules = new ArrayList<ArrangementSectionRule>();
        this.myGroupings = new ArrayList<ArrangementGroupingRule>();
        this.myRulesByPriority = new ArrayList<StdArrangementMatchRule>();
        this.myGroupings.addAll(groupingRules);
        this.mySectionRules.addAll(sectionRules);
    }

    public static StdArrangementSettings createByMatchRules(@NotNull List<ArrangementGroupingRule> groupingRules, @NotNull List<StdArrangementMatchRule> matchRules) {
        if (groupingRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupingRules", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "createByMatchRules"));
        }
        if (matchRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchRules", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "createByMatchRules"));
        }
        ArrayList<ArrangementSectionRule> sectionRules = new ArrayList<ArrangementSectionRule>();
        for (StdArrangementMatchRule rule : matchRules) {
            sectionRules.add(ArrangementSectionRule.create(rule));
        }
        return new StdArrangementSettings(groupingRules, sectionRules);
    }

    @NotNull
    protected List<ArrangementGroupingRule> cloneGroupings() {
        ArrayList<ArrangementGroupingRule> groupings = new ArrayList<ArrangementGroupingRule>();
        for (ArrangementGroupingRule grouping : this.myGroupings) {
            groupings.add(grouping.clone());
        }
        ArrayList<ArrangementGroupingRule> arrayList = groupings;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "cloneGroupings"));
        }
        return arrayList;
    }

    @NotNull
    protected List<ArrangementSectionRule> cloneSectionRules() {
        ArrayList<ArrangementSectionRule> rules = new ArrayList<ArrangementSectionRule>();
        for (ArrangementSectionRule rule : this.mySectionRules) {
            rules.add(rule.clone());
        }
        ArrayList<ArrangementSectionRule> arrayList = rules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "cloneSectionRules"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public ArrangementSettings clone() {
        StdArrangementSettings stdArrangementSettings = new StdArrangementSettings(this.cloneGroupings(), this.cloneSectionRules());
        if (stdArrangementSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "clone"));
        }
        return stdArrangementSettings;
    }

    @Override
    @NotNull
    public List<ArrangementGroupingRule> getGroupings() {
        List<ArrangementGroupingRule> list = this.myGroupings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "getGroupings"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<ArrangementSectionRule> getSections() {
        List<ArrangementSectionRule> list = this.mySectionRules;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "getSections"));
        }
        return list;
    }

    @NotNull
    public List<StdArrangementMatchRule> getRules() {
        List<StdArrangementMatchRule> list = ArrangementUtil.collectMatchRules(this.mySectionRules);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "getRules"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends ArrangementMatchRule> getRulesSortedByPriority() {
        if (this.myRulesByPriority.isEmpty()) {
            for (ArrangementSectionRule rule : this.mySectionRules) {
                this.myRulesByPriority.addAll(rule.getMatchRules());
            }
            ContainerUtil.sort(this.myRulesByPriority);
        }
        List<StdArrangementMatchRule> list = this.myRulesByPriority;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "getRulesSortedByPriority"));
        }
        return list;
    }

    public void addRule(@NotNull StdArrangementMatchRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "addRule"));
        }
        this.addRule(ArrangementSectionRule.create(rule));
    }

    public void addRule(@NotNull ArrangementSectionRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "addRule"));
        }
        this.mySectionRules.add(rule);
        this.myRulesByPriority.clear();
    }

    public void addGrouping(@NotNull ArrangementGroupingRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings", "addGrouping"));
        }
        this.myGroupings.add(rule);
    }

    public int hashCode() {
        int result = ((Object)this.mySectionRules).hashCode();
        result = 31 * result + ((Object)this.myGroupings).hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementSettings settings = (StdArrangementSettings)o;
        if (!((Object)this.myGroupings).equals(settings.myGroupings)) {
            return false;
        }
        return ((Object)this.mySectionRules).equals(settings.mySectionRules);
    }
}

