/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.StringRef;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class StubInputStream
extends DataInputStream {
    private final AbstractStringEnumerator myNameStorage;
    private final byte[] myStringIOBuffer;

    public StubInputStream(@NotNull InputStream in, @NotNull AbstractStringEnumerator nameStorage) {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/stubs/StubInputStream", "<init>"));
        }
        if (nameStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameStorage", "com/intellij/psi/stubs/StubInputStream", "<init>"));
        }
        super(in);
        this.myStringIOBuffer = IOUtil.allocReadWriteUTFBuffer();
        this.myNameStorage = nameStorage;
    }

    public String readUTFFast() throws IOException {
        return IOUtil.readUTFFast((byte[])this.myStringIOBuffer, (DataInput)this);
    }

    public StringRef readName() throws IOException {
        return DataInputOutputUtil.readNAME((DataInput)this, (AbstractStringEnumerator)this.myNameStorage);
    }

    public int readVarInt() throws IOException {
        return DataInputOutputUtil.readINT((DataInput)this);
    }

    public String stringFromId(int id) throws IOException {
        return (String)this.myNameStorage.valueOf(id);
    }
}

